# Generated by Django 4.0.5 on 2023-03-21 04:07

import time

from django.db import migrations


def transfer_subscription_keys(apps, schema_editor):
    OrganizationSetting = apps.get_model("metering_billing", "OrganizationSetting")
    for org_setting in OrganizationSetting.objects.filter(
        setting_name="subscription_filter_keys"
    ):
        organization = org_setting.organization
        organization.subscription_filter_keys = org_setting.setting_values
        organization.save()
        # just to be safe w the timescale background workers
        time.sleep(1)


class Migration(migrations.Migration):
    dependencies = [
        (
            "metering_billing",
            "0235_historicalorganization_subscription_filter_keys_and_more",
        ),
    ]

    operations = [
        migrations.RunPython(transfer_subscription_keys),
    ]
