# Generated by Django 4.0.5 on 2023-03-20 00:39

from django.db import migrations, models
import django.db.models.deletion
import metering_billing.utils.utils


class Migration(migrations.Migration):

    dependencies = [
        ('metering_billing', '0228_auto_20230315_0342'),
    ]

    operations = [
        migrations.AddField(
            model_name='historicalorganization',
            name='crm_settings_provisioned',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='organization',
            name='crm_settings_provisioned',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='team',
            name='crm_integration_allowed',
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name='historicalorganizationsetting',
            name='setting_group',
            field=models.CharField(blank=True, choices=[('stripe', 'Stripe'), ('braintree', 'Braintree'), ('billing', 'Billing'), ('crm', 'CRM')], max_length=64, null=True),
        ),
        migrations.AlterField(
            model_name='historicalorganizationsetting',
            name='setting_name',
            field=models.CharField(choices=[('generate_customer_after_creating_in_lotus', 'Generate in Stripe after Lotus'), ('gen_cust_in_braintree_after_lotus', 'Generate in Braintree after Lotus'), ('subscription_filter_keys', 'Subscription Filter Keys'), ('payment_grace_period', 'Payment Grace Period'), ('crm_customer_source', 'CRM Customer Source')], max_length=64),
        ),
        migrations.AlterField(
            model_name='organizationsetting',
            name='setting_group',
            field=models.CharField(blank=True, choices=[('stripe', 'Stripe'), ('braintree', 'Braintree'), ('billing', 'Billing'), ('crm', 'CRM')], max_length=64, null=True),
        ),
        migrations.AlterField(
            model_name='organizationsetting',
            name='setting_name',
            field=models.CharField(choices=[('generate_customer_after_creating_in_lotus', 'Generate in Stripe after Lotus'), ('gen_cust_in_braintree_after_lotus', 'Generate in Braintree after Lotus'), ('subscription_filter_keys', 'Subscription Filter Keys'), ('payment_grace_period', 'Payment Grace Period'), ('crm_customer_source', 'CRM Customer Source')], max_length=64),
        ),
        migrations.AlterField(
            model_name='webhooktrigger',
            name='trigger_name',
            field=models.CharField(choices=[('customer.created', 'customer.created'), ('invoice.created', 'invoice.created'), ('invoice.paid', 'invoice.paid'), ('invoice.past_due', 'invoice.past_due'), ('subscription.created', 'subscription.created'), ('usage_alert.triggered', 'usage_alert.triggered'), ('subscription.cancelled', 'subscription.cancelled'), ('subscription.renewed', 'subscription.renewed')], max_length=40),
        ),
        migrations.CreateModel(
            name='UnifiedCRMOrganizationIntegration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('crm_provider', models.IntegerField(choices=[(1, 'salesforce')])),
                ('access_token', models.TextField()),
                ('native_org_url', models.TextField()),
                ('native_org_id', models.TextField()),
                ('connection_id', models.TextField()),
                ('created', models.DateTimeField(default=metering_billing.utils.utils.now_utc)),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='unified_crm_organization_links', to='metering_billing.organization')),
            ],
        ),
        migrations.CreateModel(
            name='UnifiedCRMInvoiceIntegration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('crm_provider', models.IntegerField(choices=[(1, 'salesforce')])),
                ('native_invoice_id', models.TextField(null=True)),
                ('unified_note_id', models.TextField()),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='unified_crm_invoice_links', to='metering_billing.organization')),
            ],
        ),
        migrations.CreateModel(
            name='UnifiedCRMCustomerIntegration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('crm_provider', models.IntegerField(choices=[(1, 'salesforce')])),
                ('native_customer_id', models.TextField(null=True)),
                ('unified_account_id', models.TextField()),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='unified_crm_customer_links', to='metering_billing.organization')),
            ],
        ),
        migrations.AddField(
            model_name='customer',
            name='salesforce_integration',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='customer', to='metering_billing.unifiedcrmcustomerintegration'),
        ),
        migrations.AddField(
            model_name='historicalcustomer',
            name='salesforce_integration',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='metering_billing.unifiedcrmcustomerintegration'),
        ),
        migrations.AddField(
            model_name='historicalinvoice',
            name='salesforce_integration',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='metering_billing.unifiedcrminvoiceintegration'),
        ),
        migrations.AddField(
            model_name='invoice',
            name='salesforce_integration',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='metering_billing.unifiedcrminvoiceintegration'),
        ),
        migrations.AddConstraint(
            model_name='unifiedcrmorganizationintegration',
            constraint=models.UniqueConstraint(fields=('organization', 'crm_provider'), name='unique_crm_provider'),
        ),
        migrations.AddConstraint(
            model_name='unifiedcrmcustomerintegration',
            constraint=models.UniqueConstraint(condition=models.Q(('native_customer_id__isnull', False)), fields=('organization', 'crm_provider', 'native_customer_id'), name='unique_crm_customer_id_per_type'),
        ),
    ]
