# Generated by Django 4.0.5 on 2023-02-24 22:59

from django.db import migrations


def copy_addon_spec(apps, schema_editor):
    Plan = apps.get_model("metering_billing", "Plan")
    AddOnSpecification = apps.get_model("metering_billing", "AddOnSpecification")
    for plan_template in Plan.objects.filter(addon_spec__isnull=False):
        plan_template.is_addon = True
        plan_template.save()
        addon_spec = plan_template.addon_spec
        for plan_version in plan_template.versions.all():
            addon_spec_copy = AddOnSpecification.objects.create(
                organization=addon_spec.organization,
                billing_frequency=addon_spec.billing_frequency,
                flat_fee_invoicing_behavior_on_attach=addon_spec.flat_fee_invoicing_behavior_on_attach,
            )
            plan_version.addon_spec = addon_spec_copy
            plan_version.save()
        addon_spec.delete()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0207_historicalplan_is_addon_plan_is_addon_and_more"),
    ]

    operations = [
        migrations.RunPython(copy_addon_spec),
    ]
