# Generated by Django 4.0.5 on 2023-02-16 20:23

from django.db import migrations


def transfer_data(apps, schema_editor):
    Organization = apps.get_model("metering_billing", "Organization")
    Customer = apps.get_model("metering_billing", "Customer")
    StripeCustomerIntegration = apps.get_model(
        "metering_billing", "StripeCustomerIntegration"
    )
    BraintreeCustomerIntegration = apps.get_model(
        "metering_billing", "BraintreeCustomerIntegration"
    )
    StripeOrganizationIntegration = apps.get_model(
        "metering_billing", "StripeOrganizationIntegration"
    )
    BraintreeOrganizationIntegration = apps.get_model(
        "metering_billing", "BraintreeOrganizationIntegration"
    )

    # Transfer data from Customer to Stripe/Braintree Customer Integration
    stripe_customers = Customer.objects.filter(
        integrations__has_key="stripe", integrations__stripe__has_key="id"
    ).select_related("organization")
    for customer in stripe_customers:
        integration = StripeCustomerIntegration.objects.create(
            organization=customer.organization,
            stripe_customer_id=customer.integrations["stripe"]["id"],
        )
        customer.stripe_integration = integration
        customer.save()

    braintree_customers = Customer.objects.filter(
        integrations__has_key="braintree", integrations__braintree__has_key="id"
    ).select_related("organization")
    for customer in braintree_customers:
        integration = BraintreeCustomerIntegration.objects.create(
            organization=customer.organization,
            braintree_customer_id=customer.integrations["braintree"]["id"],
        )
        customer.braintree_integration = integration
        customer.save()

    # Transfer data from Organization to Stripe/Braintree Organization Integration
    stripe_organizations = Organization.objects.filter(
        payment_provider_ids__has_key="stripe",
        payment_provider_ids__stripe__has_key="id",
    )
    for organization in stripe_organizations:
        integration = StripeOrganizationIntegration.objects.create(
            organization=organization,
            stripe_account_id=organization.payment_provider_ids["stripe"]["id"],
        )
        organization.stripe_integration = integration
        organization.save()

    braintree_organizations = Organization.objects.filter(
        payment_provider_ids__has_key="braintree",
        payment_provider_ids__braintree__has_key="id",
    )
    for organization in braintree_organizations:
        integration = BraintreeOrganizationIntegration.objects.create(
            organization=organization,
            braintree_merchant_id=organization.payment_provider_ids["braintree"]["id"],
        )
        organization.braintree_integration = integration
        organization.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0183_customer_tax_provider_and_more"),
    ]

    operations = [
        migrations.RunPython(transfer_data, reverse_code=migrations.RunPython.noop),
    ]
