# Generated by Django 4.0.5 on 2023-02-14 06:35

from django.db import migrations
from django.db.models import Count, Max


def remove_duplicates(apps, schema_editor):
    Event = apps.get_model("metering_billing", "Event")
    unique_fields = ["organization_id", "idempotency_id"]

    duplicates = (
        Event.objects.values(*unique_fields)
        .order_by()
        .annotate(
            max_time_created=Max("time_created"),
            cnt=Count("*"),
        )
        .filter(cnt__gt=1)
    )

    for duplicate in duplicates:
        (
            Event.objects.filter(
                organization_id=duplicate["organization_id"],
                idempotency_id=duplicate["idempotency_id"],
            )
            .exclude(time_created=duplicate["max_time_created"])
            .delete()
        )


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0180_transfer_data"),
    ]

    operations = []
