# Generated by Django 4.0.5 on 2022-12-19 20:04

import uuid

from django.db import migrations
from django.db.models import Q


def make_all_emails_nonnull(apps, schema_editor):
    Customer = apps.get_model("metering_billing", "Customer")
    c_list = Customer.objects.filter(Q(email="") | Q(email__isnull=True))
    for c in c_list:
        c.email = f"{str(uuid.uuid4().hex)}@example.com"
        c.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0128_merge_20221215_2207"),
    ]

    operations = [
        migrations.RunPython(make_all_emails_nonnull),
    ]
