# Generated by Django 4.0.5 on 2022-12-10 04:10

from django.db import migrations


def delete_dups(apps, schema_editor):
    Customer = apps.get_model("metering_billing", "Customer")
    for row in Customer.objects.all().order_by("pk"):
        org = row.organization
        email = row.email
        pk = row.pk
        others = Customer.objects.filter(organization=org, email=email).exclude(pk=pk)
        others.delete()


class Migration(migrations.Migration):
    dependencies = [
        (
            "metering_billing",
            "0107_rename_unadjusted_duration_days_historicalsubscriptionrecord_unadjusted_duration_seconds_and_more",
        ),
    ]

    operations = [
        migrations.RunPython(delete_dups, reverse_code=migrations.RunPython.noop),
    ]
