# Generated by Django 4.0.5 on 2022-11-23 06:06

from django.db import migrations


def prepopulate(apps, schema_editor):
    apps.get_model("metering_billing", "PlanComponent")
    apps.get_model("metering_billing", "PriceTier")
    apps.get_model("metering_billing", "PlanVersion")
    PricingUnit = apps.get_model("metering_billing", "PricingUnit")
    Invoice = apps.get_model("metering_billing", "Invoice")
    Customer = apps.get_model("metering_billing", "Customer")
    Organization = apps.get_model("metering_billing", "Organization")

    supported_currencies = [
        ("US Dollar", "USD", "$"),
        ("Euro", "EUR", "€"),
        ("Pound", "GBP", "£"),
    ]
    for name, code, symbol in supported_currencies:
        PricingUnit.objects.get_or_create(name=name, code=code, symbol=symbol)
    usd = PricingUnit.objects.get(code="USD")
    for inv in Invoice.objects.all():
        inv.pricing_unit = usd
        inv.save()
    for cust in Customer.objects.all():
        cust.default_currency = usd
        cust.save()
    for org in Organization.objects.all():
        org.default_currency = usd
        org.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0083_alter_customerbalanceadjustment_options_and_more"),
    ]

    operations = [
        migrations.RunPython(prepopulate),
    ]
