# Generated by Django 4.0.5 on 2022-09-04 19:33

from decimal import Decimal

import django.contrib.auth.models
import django.contrib.auth.validators
import django.contrib.postgres.fields
import django.db.models.deletion
import django.utils.timezone
import djmoney.models.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="BillableMetric",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("event_name", models.CharField(max_length=200)),
                (
                    "property_name",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                (
                    "aggregation_type",
                    models.CharField(
                        choices=[("count", "Count"), ("sum", "Sum"), ("max", "Max")],
                        default="count",
                        max_length=10,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="BillingPlan",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("time_created", models.DateTimeField(auto_now=True)),
                ("currency", models.CharField(default="USD", max_length=30)),
                (
                    "interval",
                    models.CharField(
                        choices=[
                            ("week", "Week"),
                            ("month", "Month"),
                            ("year", "Year"),
                        ],
                        default="month",
                        max_length=5,
                    ),
                ),
                (
                    "flat_rate_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "flat_rate",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10,
                        default=Decimal("0.0"),
                        default_currency="USD",
                        max_digits=20,
                    ),
                ),
                ("pay_in_advance", models.BooleanField(default=False)),
                ("name", models.CharField(default=" ", max_length=200)),
                (
                    "description",
                    models.CharField(blank=True, default=" ", max_length=256),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Customer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("customer_id", models.CharField(max_length=40, unique=True)),
                (
                    "balance_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "balance",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10,
                        default=Decimal("0.0"),
                        default_currency="USD",
                        max_digits=20,
                    ),
                ),
                ("currency", models.CharField(default="USD", max_length=3)),
                (
                    "payment_provider_id",
                    models.CharField(blank=True, max_length=50, null=True),
                ),
                ("properties", models.JSONField(blank=True, default=dict, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("company_name", models.CharField(default=" ", max_length=100)),
                (
                    "stripe_id",
                    models.CharField(blank=True, default="", max_length=110, null=True),
                ),
                ("created", models.DateField(auto_now=True)),
                (
                    "payment_plan",
                    models.CharField(
                        choices=[
                            ("self_hosted_free", "Self-Hosted Free"),
                            ("cloud", "Cloud"),
                            ("self_hosted_enterprise", "Self-Hosted Enterprise"),
                        ],
                        default="self_hosted_free",
                        max_length=40,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start_date", models.DateField()),
                ("end_date", models.DateField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("ended", "Ended"),
                            ("not_started", "Not Started"),
                        ],
                        default="not_started",
                        max_length=20,
                    ),
                ),
                ("auto_renew", models.BooleanField(default=True)),
                ("is_new", models.BooleanField(default=True)),
                (
                    "billing_plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="current_plan",
                        to="metering_billing.billingplan",
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.customer",
                    ),
                ),
                (
                    "next_plan",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="next_plan",
                        to="metering_billing.billingplan",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.organization",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PlanComponent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "free_metric_quantity",
                    models.DecimalField(decimal_places=10, default=0.0, max_digits=20),
                ),
                (
                    "cost_per_metric_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "cost_per_metric",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10, default_currency="USD", max_digits=20
                    ),
                ),
                (
                    "metric_amount_per_cost",
                    models.DecimalField(decimal_places=10, default=1.0, max_digits=20),
                ),
                (
                    "billable_metric",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.billablemetric",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "cost_due_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "cost_due",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10,
                        default=Decimal("0.0"),
                        default_currency="USD",
                        max_digits=20,
                    ),
                ),
                ("issue_date", models.DateTimeField(auto_now=True, max_length=100)),
                (
                    "invoice_pdf",
                    models.FileField(blank=True, null=True, upload_to="invoices/"),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("issued", "Issued"),
                            ("fulfilled", "Fullfilled"),
                            ("not_sent", "Not Sent"),
                        ],
                        default="not_sent",
                        max_length=20,
                    ),
                ),
                (
                    "line_items",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.JSONField(), blank=True, null=True, size=None
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.customer",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "subscription",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="metering_billing.subscription",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("event_name", models.CharField(max_length=200)),
                ("time_created", models.DateTimeField()),
                ("properties", models.JSONField(blank=True, default=dict, null=True)),
                ("idempotency_id", models.CharField(max_length=255, unique=True)),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.customer",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "ordering": ["time_created", "idempotency_id"],
            },
        ),
        migrations.AddField(
            model_name="customer",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="metering_billing.organization",
            ),
        ),
        migrations.AddField(
            model_name="billingplan",
            name="components",
            field=models.ManyToManyField(to="metering_billing.plancomponent"),
        ),
        migrations.AddField(
            model_name="billingplan",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="metering_billing.organization",
            ),
        ),
        migrations.AddField(
            model_name="billablemetric",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="metering_billing.organization",
            ),
        ),
        migrations.CreateModel(
            name="APIToken",
            fields=[
                (
                    "id",
                    models.CharField(
                        editable=False,
                        max_length=150,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("prefix", models.CharField(editable=False, max_length=8, unique=True)),
                ("hashed_key", models.CharField(editable=False, max_length=150)),
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "revoked",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If the API key is revoked, clients cannot use it anymore. (This cannot be undone.)",
                    ),
                ),
                (
                    "expiry_date",
                    models.DateTimeField(
                        blank=True,
                        help_text="Once API key expires, clients cannot use it anymore.",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                ("name", models.CharField(default="latest_token", max_length=200)),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_keys",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "API Token",
                "verbose_name_plural": "API Tokens",
                "ordering": ("-created",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that username already exists."
                        },
                        help_text="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "user",
                "verbose_name_plural": "users",
                "abstract": False,
            },
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.AlterUniqueTogether(
            name="billablemetric",
            unique_together={
                ("organization", "event_name", "property_name", "aggregation_type")
            },
        ),
    ]
