# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from lndmanage.grpc_compiled import signer_pb2 as signer__pb2
from lndmanage.grpc_compiled import walletkit_pb2 as walletkit__pb2


class WalletKitStub(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ListUnspent = channel.unary_unary(
                '/walletrpc.WalletKit/ListUnspent',
                request_serializer=walletkit__pb2.ListUnspentRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ListUnspentResponse.FromString,
                )
        self.LeaseOutput = channel.unary_unary(
                '/walletrpc.WalletKit/LeaseOutput',
                request_serializer=walletkit__pb2.LeaseOutputRequest.SerializeToString,
                response_deserializer=walletkit__pb2.LeaseOutputResponse.FromString,
                )
        self.ReleaseOutput = channel.unary_unary(
                '/walletrpc.WalletKit/ReleaseOutput',
                request_serializer=walletkit__pb2.ReleaseOutputRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ReleaseOutputResponse.FromString,
                )
        self.ListLeases = channel.unary_unary(
                '/walletrpc.WalletKit/ListLeases',
                request_serializer=walletkit__pb2.ListLeasesRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ListLeasesResponse.FromString,
                )
        self.DeriveNextKey = channel.unary_unary(
                '/walletrpc.WalletKit/DeriveNextKey',
                request_serializer=walletkit__pb2.KeyReq.SerializeToString,
                response_deserializer=signer__pb2.KeyDescriptor.FromString,
                )
        self.DeriveKey = channel.unary_unary(
                '/walletrpc.WalletKit/DeriveKey',
                request_serializer=signer__pb2.KeyLocator.SerializeToString,
                response_deserializer=signer__pb2.KeyDescriptor.FromString,
                )
        self.NextAddr = channel.unary_unary(
                '/walletrpc.WalletKit/NextAddr',
                request_serializer=walletkit__pb2.AddrRequest.SerializeToString,
                response_deserializer=walletkit__pb2.AddrResponse.FromString,
                )
        self.ListAccounts = channel.unary_unary(
                '/walletrpc.WalletKit/ListAccounts',
                request_serializer=walletkit__pb2.ListAccountsRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ListAccountsResponse.FromString,
                )
        self.RequiredReserve = channel.unary_unary(
                '/walletrpc.WalletKit/RequiredReserve',
                request_serializer=walletkit__pb2.RequiredReserveRequest.SerializeToString,
                response_deserializer=walletkit__pb2.RequiredReserveResponse.FromString,
                )
        self.ListAddresses = channel.unary_unary(
                '/walletrpc.WalletKit/ListAddresses',
                request_serializer=walletkit__pb2.ListAddressesRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ListAddressesResponse.FromString,
                )
        self.SignMessageWithAddr = channel.unary_unary(
                '/walletrpc.WalletKit/SignMessageWithAddr',
                request_serializer=walletkit__pb2.SignMessageWithAddrRequest.SerializeToString,
                response_deserializer=walletkit__pb2.SignMessageWithAddrResponse.FromString,
                )
        self.VerifyMessageWithAddr = channel.unary_unary(
                '/walletrpc.WalletKit/VerifyMessageWithAddr',
                request_serializer=walletkit__pb2.VerifyMessageWithAddrRequest.SerializeToString,
                response_deserializer=walletkit__pb2.VerifyMessageWithAddrResponse.FromString,
                )
        self.ImportAccount = channel.unary_unary(
                '/walletrpc.WalletKit/ImportAccount',
                request_serializer=walletkit__pb2.ImportAccountRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ImportAccountResponse.FromString,
                )
        self.ImportPublicKey = channel.unary_unary(
                '/walletrpc.WalletKit/ImportPublicKey',
                request_serializer=walletkit__pb2.ImportPublicKeyRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ImportPublicKeyResponse.FromString,
                )
        self.ImportTapscript = channel.unary_unary(
                '/walletrpc.WalletKit/ImportTapscript',
                request_serializer=walletkit__pb2.ImportTapscriptRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ImportTapscriptResponse.FromString,
                )
        self.PublishTransaction = channel.unary_unary(
                '/walletrpc.WalletKit/PublishTransaction',
                request_serializer=walletkit__pb2.Transaction.SerializeToString,
                response_deserializer=walletkit__pb2.PublishResponse.FromString,
                )
        self.SendOutputs = channel.unary_unary(
                '/walletrpc.WalletKit/SendOutputs',
                request_serializer=walletkit__pb2.SendOutputsRequest.SerializeToString,
                response_deserializer=walletkit__pb2.SendOutputsResponse.FromString,
                )
        self.EstimateFee = channel.unary_unary(
                '/walletrpc.WalletKit/EstimateFee',
                request_serializer=walletkit__pb2.EstimateFeeRequest.SerializeToString,
                response_deserializer=walletkit__pb2.EstimateFeeResponse.FromString,
                )
        self.PendingSweeps = channel.unary_unary(
                '/walletrpc.WalletKit/PendingSweeps',
                request_serializer=walletkit__pb2.PendingSweepsRequest.SerializeToString,
                response_deserializer=walletkit__pb2.PendingSweepsResponse.FromString,
                )
        self.BumpFee = channel.unary_unary(
                '/walletrpc.WalletKit/BumpFee',
                request_serializer=walletkit__pb2.BumpFeeRequest.SerializeToString,
                response_deserializer=walletkit__pb2.BumpFeeResponse.FromString,
                )
        self.ListSweeps = channel.unary_unary(
                '/walletrpc.WalletKit/ListSweeps',
                request_serializer=walletkit__pb2.ListSweepsRequest.SerializeToString,
                response_deserializer=walletkit__pb2.ListSweepsResponse.FromString,
                )
        self.LabelTransaction = channel.unary_unary(
                '/walletrpc.WalletKit/LabelTransaction',
                request_serializer=walletkit__pb2.LabelTransactionRequest.SerializeToString,
                response_deserializer=walletkit__pb2.LabelTransactionResponse.FromString,
                )
        self.FundPsbt = channel.unary_unary(
                '/walletrpc.WalletKit/FundPsbt',
                request_serializer=walletkit__pb2.FundPsbtRequest.SerializeToString,
                response_deserializer=walletkit__pb2.FundPsbtResponse.FromString,
                )
        self.SignPsbt = channel.unary_unary(
                '/walletrpc.WalletKit/SignPsbt',
                request_serializer=walletkit__pb2.SignPsbtRequest.SerializeToString,
                response_deserializer=walletkit__pb2.SignPsbtResponse.FromString,
                )
        self.FinalizePsbt = channel.unary_unary(
                '/walletrpc.WalletKit/FinalizePsbt',
                request_serializer=walletkit__pb2.FinalizePsbtRequest.SerializeToString,
                response_deserializer=walletkit__pb2.FinalizePsbtResponse.FromString,
                )


class WalletKitServicer(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    def ListUnspent(self, request, context):
        """
        ListUnspent returns a list of all utxos spendable by the wallet with a
        number of confirmations between the specified minimum and maximum. By
        default, all utxos are listed. To list only the unconfirmed utxos, set
        the unconfirmed_only to true.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LeaseOutput(self, request, context):
        """
        LeaseOutput locks an output to the given ID, preventing it from being
        available for any future coin selection attempts. The absolute time of the
        lock's expiration is returned. The expiration of the lock can be extended by
        successive invocations of this RPC. Outputs can be unlocked before their
        expiration through `ReleaseOutput`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReleaseOutput(self, request, context):
        """
        ReleaseOutput unlocks an output, allowing it to be available for coin
        selection if it remains unspent. The ID should match the one used to
        originally lock the output.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListLeases(self, request, context):
        """
        ListLeases lists all currently locked utxos.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeriveNextKey(self, request, context):
        """
        DeriveNextKey attempts to derive the *next* key within the key family
        (account in BIP43) specified. This method should return the next external
        child within this branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeriveKey(self, request, context):
        """
        DeriveKey attempts to derive an arbitrary key specified by the passed
        KeyLocator.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def NextAddr(self, request, context):
        """
        NextAddr returns the next unused address within the wallet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAccounts(self, request, context):
        """
        ListAccounts retrieves all accounts belonging to the wallet by default. A
        name and key scope filter can be provided to filter through all of the
        wallet accounts and return only those matching.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RequiredReserve(self, request, context):
        """
        RequiredReserve returns the minimum amount of satoshis that should be kept
        in the wallet in order to fee bump anchor channels if necessary. The value
        scales with the number of public anchor channels but is capped at a maximum.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAddresses(self, request, context):
        """
        ListAddresses retrieves all the addresses along with their balance. An
        account name filter can be provided to filter through all of the
        wallet accounts and return the addresses of only those matching.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SignMessageWithAddr(self, request, context):
        """
        SignMessageWithAddr returns the compact signature (base64 encoded) created
        with the private key of the provided address. This requires the address
        to be solely based on a public key lock (no scripts). Obviously the internal
        lnd wallet has to possess the private key of the address otherwise
        an error is returned.

        This method aims to provide full compatibility with the bitcoin-core and
        btcd implementation. Bitcoin-core's algorithm is not specified in a
        BIP and only applicable for legacy addresses. This method enhances the
        signing for additional address types: P2WKH, NP2WKH, P2TR.
        For P2TR addresses this represents a special case. ECDSA is used to create
        a compact signature which makes the public key of the signature recoverable.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def VerifyMessageWithAddr(self, request, context):
        """
        VerifyMessageWithAddr returns the validity and the recovered public key of
        the provided compact signature (base64 encoded). The verification is
        twofold. First the validity of the signature itself is checked and then
        it is verified that the recovered public key of the signature equals
        the public key of the provided address. There is no dependence on the
        private key of the address therefore also external addresses are allowed
        to verify signatures.
        Supported address types are P2PKH, P2WKH, NP2WKH, P2TR.

        This method is the counterpart of the related signing method
        (SignMessageWithAddr) and aims to provide full compatibility to
        bitcoin-core's implementation. Although bitcoin-core/btcd only provide
        this functionality for legacy addresses this function enhances it to
        the address types: P2PKH, P2WKH, NP2WKH, P2TR.

        The verification for P2TR addresses is a special case and requires the
        ECDSA compact signature to compare the reovered public key to the internal
        taproot key. The compact ECDSA signature format was used because there
        are still no known compact signature schemes for schnorr signatures.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportAccount(self, request, context):
        """
        ImportAccount imports an account backed by an account extended public key.
        The master key fingerprint denotes the fingerprint of the root key
        corresponding to the account public key (also known as the key with
        derivation path m/). This may be required by some hardware wallets for
        proper identification and signing.

        The address type can usually be inferred from the key's version, but may be
        required for certain keys to map them into the proper scope.

        For BIP-0044 keys, an address type must be specified as we intend to not
        support importing BIP-0044 keys into the wallet using the legacy
        pay-to-pubkey-hash (P2PKH) scheme. A nested witness address type will force
        the standard BIP-0049 derivation scheme, while a witness address type will
        force the standard BIP-0084 derivation scheme.

        For BIP-0049 keys, an address type must also be specified to make a
        distinction between the standard BIP-0049 address schema (nested witness
        pubkeys everywhere) and our own BIP-0049Plus address schema (nested pubkeys
        externally, witness pubkeys internally).

        NOTE: Events (deposits/spends) for keys derived from an account will only be
        detected by lnd if they happen after the import. Rescans to detect past
        events will be supported later on.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportPublicKey(self, request, context):
        """
        ImportPublicKey imports a public key as watch-only into the wallet. The
        public key is converted into a simple address of the given type and that
        address script is watched on chain. For Taproot keys, this will only watch
        the BIP-0086 style output script. Use ImportTapscript for more advanced key
        spend or script spend outputs.

        NOTE: Events (deposits/spends) for a key will only be detected by lnd if
        they happen after the import. Rescans to detect past events will be
        supported later on.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportTapscript(self, request, context):
        """
        ImportTapscript imports a Taproot script and internal key and adds the
        resulting Taproot output key as a watch-only output script into the wallet.
        For BIP-0086 style Taproot keys (no root hash commitment and no script spend
        path) use ImportPublicKey.

        NOTE: Events (deposits/spends) for a key will only be detected by lnd if
        they happen after the import. Rescans to detect past events will be
        supported later on.

        NOTE: Taproot keys imported through this RPC currently _cannot_ be used for
        funding PSBTs. Only tracking the balance and UTXOs is currently supported.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PublishTransaction(self, request, context):
        """
        PublishTransaction attempts to publish the passed transaction to the
        network. Once this returns without an error, the wallet will continually
        attempt to re-broadcast the transaction on start up, until it enters the
        chain.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SendOutputs(self, request, context):
        """
        SendOutputs is similar to the existing sendmany call in Bitcoind, and
        allows the caller to create a transaction that sends to several outputs at
        once. This is ideal when wanting to batch create a set of transactions.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EstimateFee(self, request, context):
        """
        EstimateFee attempts to query the internal fee estimator of the wallet to
        determine the fee (in sat/kw) to attach to a transaction in order to
        achieve the confirmation target.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PendingSweeps(self, request, context):
        """
        PendingSweeps returns lists of on-chain outputs that lnd is currently
        attempting to sweep within its central batching engine. Outputs with similar
        fee rates are batched together in order to sweep them within a single
        transaction.

        NOTE: Some of the fields within PendingSweepsRequest are not guaranteed to
        remain supported. This is an advanced API that depends on the internals of
        the UtxoSweeper, so things may change.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BumpFee(self, request, context):
        """
        BumpFee bumps the fee of an arbitrary input within a transaction. This RPC
        takes a different approach than bitcoind's bumpfee command. lnd has a
        central batching engine in which inputs with similar fee rates are batched
        together to save on transaction fees. Due to this, we cannot rely on
        bumping the fee on a specific transaction, since transactions can change at
        any point with the addition of new inputs. The list of inputs that
        currently exist within lnd's central batching engine can be retrieved
        through the PendingSweeps RPC.

        When bumping the fee of an input that currently exists within lnd's central
        batching engine, a higher fee transaction will be created that replaces the
        lower fee transaction through the Replace-By-Fee (RBF) policy. If it

        This RPC also serves useful when wanting to perform a Child-Pays-For-Parent
        (CPFP), where the child transaction pays for its parent's fee. This can be
        done by specifying an outpoint within the low fee transaction that is under
        the control of the wallet.

        The fee preference can be expressed either as a specific fee rate or a delta
        of blocks in which the output should be swept on-chain within. If a fee
        preference is not explicitly specified, then an error is returned.

        Note that this RPC currently doesn't perform any validation checks on the
        fee preference being provided. For now, the responsibility of ensuring that
        the new fee preference is sufficient is delegated to the user.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListSweeps(self, request, context):
        """
        ListSweeps returns a list of the sweep transactions our node has produced.
        Note that these sweeps may not be confirmed yet, as we record sweeps on
        broadcast, not confirmation.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LabelTransaction(self, request, context):
        """
        LabelTransaction adds a label to a transaction. If the transaction already
        has a label the call will fail unless the overwrite bool is set. This will
        overwrite the exiting transaction label. Labels must not be empty, and
        cannot exceed 500 characters.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FundPsbt(self, request, context):
        """
        FundPsbt creates a fully populated PSBT that contains enough inputs to fund
        the outputs specified in the template. There are two ways of specifying a
        template: Either by passing in a PSBT with at least one output declared or
        by passing in a raw TxTemplate message.

        If there are no inputs specified in the template, coin selection is
        performed automatically. If the template does contain any inputs, it is
        assumed that full coin selection happened externally and no additional
        inputs are added. If the specified inputs aren't enough to fund the outputs
        with the given fee rate, an error is returned.

        After either selecting or verifying the inputs, all input UTXOs are locked
        with an internal app ID.

        NOTE: If this method returns without an error, it is the caller's
        responsibility to either spend the locked UTXOs (by finalizing and then
        publishing the transaction) or to unlock/release the locked UTXOs in case of
        an error on the caller's side.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SignPsbt(self, request, context):
        """
        SignPsbt expects a partial transaction with all inputs and outputs fully
        declared and tries to sign all unsigned inputs that have all required fields
        (UTXO information, BIP32 derivation information, witness or sig scripts)
        set.
        If no error is returned, the PSBT is ready to be given to the next signer or
        to be finalized if lnd was the last signer.

        NOTE: This RPC only signs inputs (and only those it can sign), it does not
        perform any other tasks (such as coin selection, UTXO locking or
        input/output/fee value validation, PSBT finalization). Any input that is
        incomplete will be skipped.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FinalizePsbt(self, request, context):
        """
        FinalizePsbt expects a partial transaction with all inputs and outputs fully
        declared and tries to sign all inputs that belong to the wallet. Lnd must be
        the last signer of the transaction. That means, if there are any unsigned
        non-witness inputs or inputs without UTXO information attached or inputs
        without witness data that do not belong to lnd's wallet, this method will
        fail. If no error is returned, the PSBT is ready to be extracted and the
        final TX within to be broadcast.

        NOTE: This method does NOT publish the transaction once finalized. It is the
        caller's responsibility to either publish the transaction on success or
        unlock/release any locked UTXOs in case of an error in this method.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_WalletKitServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ListUnspent': grpc.unary_unary_rpc_method_handler(
                    servicer.ListUnspent,
                    request_deserializer=walletkit__pb2.ListUnspentRequest.FromString,
                    response_serializer=walletkit__pb2.ListUnspentResponse.SerializeToString,
            ),
            'LeaseOutput': grpc.unary_unary_rpc_method_handler(
                    servicer.LeaseOutput,
                    request_deserializer=walletkit__pb2.LeaseOutputRequest.FromString,
                    response_serializer=walletkit__pb2.LeaseOutputResponse.SerializeToString,
            ),
            'ReleaseOutput': grpc.unary_unary_rpc_method_handler(
                    servicer.ReleaseOutput,
                    request_deserializer=walletkit__pb2.ReleaseOutputRequest.FromString,
                    response_serializer=walletkit__pb2.ReleaseOutputResponse.SerializeToString,
            ),
            'ListLeases': grpc.unary_unary_rpc_method_handler(
                    servicer.ListLeases,
                    request_deserializer=walletkit__pb2.ListLeasesRequest.FromString,
                    response_serializer=walletkit__pb2.ListLeasesResponse.SerializeToString,
            ),
            'DeriveNextKey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeriveNextKey,
                    request_deserializer=walletkit__pb2.KeyReq.FromString,
                    response_serializer=signer__pb2.KeyDescriptor.SerializeToString,
            ),
            'DeriveKey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeriveKey,
                    request_deserializer=signer__pb2.KeyLocator.FromString,
                    response_serializer=signer__pb2.KeyDescriptor.SerializeToString,
            ),
            'NextAddr': grpc.unary_unary_rpc_method_handler(
                    servicer.NextAddr,
                    request_deserializer=walletkit__pb2.AddrRequest.FromString,
                    response_serializer=walletkit__pb2.AddrResponse.SerializeToString,
            ),
            'ListAccounts': grpc.unary_unary_rpc_method_handler(
                    servicer.ListAccounts,
                    request_deserializer=walletkit__pb2.ListAccountsRequest.FromString,
                    response_serializer=walletkit__pb2.ListAccountsResponse.SerializeToString,
            ),
            'RequiredReserve': grpc.unary_unary_rpc_method_handler(
                    servicer.RequiredReserve,
                    request_deserializer=walletkit__pb2.RequiredReserveRequest.FromString,
                    response_serializer=walletkit__pb2.RequiredReserveResponse.SerializeToString,
            ),
            'ListAddresses': grpc.unary_unary_rpc_method_handler(
                    servicer.ListAddresses,
                    request_deserializer=walletkit__pb2.ListAddressesRequest.FromString,
                    response_serializer=walletkit__pb2.ListAddressesResponse.SerializeToString,
            ),
            'SignMessageWithAddr': grpc.unary_unary_rpc_method_handler(
                    servicer.SignMessageWithAddr,
                    request_deserializer=walletkit__pb2.SignMessageWithAddrRequest.FromString,
                    response_serializer=walletkit__pb2.SignMessageWithAddrResponse.SerializeToString,
            ),
            'VerifyMessageWithAddr': grpc.unary_unary_rpc_method_handler(
                    servicer.VerifyMessageWithAddr,
                    request_deserializer=walletkit__pb2.VerifyMessageWithAddrRequest.FromString,
                    response_serializer=walletkit__pb2.VerifyMessageWithAddrResponse.SerializeToString,
            ),
            'ImportAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportAccount,
                    request_deserializer=walletkit__pb2.ImportAccountRequest.FromString,
                    response_serializer=walletkit__pb2.ImportAccountResponse.SerializeToString,
            ),
            'ImportPublicKey': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportPublicKey,
                    request_deserializer=walletkit__pb2.ImportPublicKeyRequest.FromString,
                    response_serializer=walletkit__pb2.ImportPublicKeyResponse.SerializeToString,
            ),
            'ImportTapscript': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportTapscript,
                    request_deserializer=walletkit__pb2.ImportTapscriptRequest.FromString,
                    response_serializer=walletkit__pb2.ImportTapscriptResponse.SerializeToString,
            ),
            'PublishTransaction': grpc.unary_unary_rpc_method_handler(
                    servicer.PublishTransaction,
                    request_deserializer=walletkit__pb2.Transaction.FromString,
                    response_serializer=walletkit__pb2.PublishResponse.SerializeToString,
            ),
            'SendOutputs': grpc.unary_unary_rpc_method_handler(
                    servicer.SendOutputs,
                    request_deserializer=walletkit__pb2.SendOutputsRequest.FromString,
                    response_serializer=walletkit__pb2.SendOutputsResponse.SerializeToString,
            ),
            'EstimateFee': grpc.unary_unary_rpc_method_handler(
                    servicer.EstimateFee,
                    request_deserializer=walletkit__pb2.EstimateFeeRequest.FromString,
                    response_serializer=walletkit__pb2.EstimateFeeResponse.SerializeToString,
            ),
            'PendingSweeps': grpc.unary_unary_rpc_method_handler(
                    servicer.PendingSweeps,
                    request_deserializer=walletkit__pb2.PendingSweepsRequest.FromString,
                    response_serializer=walletkit__pb2.PendingSweepsResponse.SerializeToString,
            ),
            'BumpFee': grpc.unary_unary_rpc_method_handler(
                    servicer.BumpFee,
                    request_deserializer=walletkit__pb2.BumpFeeRequest.FromString,
                    response_serializer=walletkit__pb2.BumpFeeResponse.SerializeToString,
            ),
            'ListSweeps': grpc.unary_unary_rpc_method_handler(
                    servicer.ListSweeps,
                    request_deserializer=walletkit__pb2.ListSweepsRequest.FromString,
                    response_serializer=walletkit__pb2.ListSweepsResponse.SerializeToString,
            ),
            'LabelTransaction': grpc.unary_unary_rpc_method_handler(
                    servicer.LabelTransaction,
                    request_deserializer=walletkit__pb2.LabelTransactionRequest.FromString,
                    response_serializer=walletkit__pb2.LabelTransactionResponse.SerializeToString,
            ),
            'FundPsbt': grpc.unary_unary_rpc_method_handler(
                    servicer.FundPsbt,
                    request_deserializer=walletkit__pb2.FundPsbtRequest.FromString,
                    response_serializer=walletkit__pb2.FundPsbtResponse.SerializeToString,
            ),
            'SignPsbt': grpc.unary_unary_rpc_method_handler(
                    servicer.SignPsbt,
                    request_deserializer=walletkit__pb2.SignPsbtRequest.FromString,
                    response_serializer=walletkit__pb2.SignPsbtResponse.SerializeToString,
            ),
            'FinalizePsbt': grpc.unary_unary_rpc_method_handler(
                    servicer.FinalizePsbt,
                    request_deserializer=walletkit__pb2.FinalizePsbtRequest.FromString,
                    response_serializer=walletkit__pb2.FinalizePsbtResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'walletrpc.WalletKit', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class WalletKit(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    @staticmethod
    def ListUnspent(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListUnspent',
            walletkit__pb2.ListUnspentRequest.SerializeToString,
            walletkit__pb2.ListUnspentResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LeaseOutput(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/LeaseOutput',
            walletkit__pb2.LeaseOutputRequest.SerializeToString,
            walletkit__pb2.LeaseOutputResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ReleaseOutput(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ReleaseOutput',
            walletkit__pb2.ReleaseOutputRequest.SerializeToString,
            walletkit__pb2.ReleaseOutputResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListLeases(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListLeases',
            walletkit__pb2.ListLeasesRequest.SerializeToString,
            walletkit__pb2.ListLeasesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeriveNextKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/DeriveNextKey',
            walletkit__pb2.KeyReq.SerializeToString,
            signer__pb2.KeyDescriptor.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeriveKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/DeriveKey',
            signer__pb2.KeyLocator.SerializeToString,
            signer__pb2.KeyDescriptor.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def NextAddr(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/NextAddr',
            walletkit__pb2.AddrRequest.SerializeToString,
            walletkit__pb2.AddrResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListAccounts(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListAccounts',
            walletkit__pb2.ListAccountsRequest.SerializeToString,
            walletkit__pb2.ListAccountsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def RequiredReserve(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/RequiredReserve',
            walletkit__pb2.RequiredReserveRequest.SerializeToString,
            walletkit__pb2.RequiredReserveResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListAddresses(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListAddresses',
            walletkit__pb2.ListAddressesRequest.SerializeToString,
            walletkit__pb2.ListAddressesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SignMessageWithAddr(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/SignMessageWithAddr',
            walletkit__pb2.SignMessageWithAddrRequest.SerializeToString,
            walletkit__pb2.SignMessageWithAddrResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def VerifyMessageWithAddr(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/VerifyMessageWithAddr',
            walletkit__pb2.VerifyMessageWithAddrRequest.SerializeToString,
            walletkit__pb2.VerifyMessageWithAddrResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ImportAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ImportAccount',
            walletkit__pb2.ImportAccountRequest.SerializeToString,
            walletkit__pb2.ImportAccountResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ImportPublicKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ImportPublicKey',
            walletkit__pb2.ImportPublicKeyRequest.SerializeToString,
            walletkit__pb2.ImportPublicKeyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ImportTapscript(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ImportTapscript',
            walletkit__pb2.ImportTapscriptRequest.SerializeToString,
            walletkit__pb2.ImportTapscriptResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def PublishTransaction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/PublishTransaction',
            walletkit__pb2.Transaction.SerializeToString,
            walletkit__pb2.PublishResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SendOutputs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/SendOutputs',
            walletkit__pb2.SendOutputsRequest.SerializeToString,
            walletkit__pb2.SendOutputsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EstimateFee(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/EstimateFee',
            walletkit__pb2.EstimateFeeRequest.SerializeToString,
            walletkit__pb2.EstimateFeeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def PendingSweeps(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/PendingSweeps',
            walletkit__pb2.PendingSweepsRequest.SerializeToString,
            walletkit__pb2.PendingSweepsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def BumpFee(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/BumpFee',
            walletkit__pb2.BumpFeeRequest.SerializeToString,
            walletkit__pb2.BumpFeeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListSweeps(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListSweeps',
            walletkit__pb2.ListSweepsRequest.SerializeToString,
            walletkit__pb2.ListSweepsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LabelTransaction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/LabelTransaction',
            walletkit__pb2.LabelTransactionRequest.SerializeToString,
            walletkit__pb2.LabelTransactionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def FundPsbt(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/FundPsbt',
            walletkit__pb2.FundPsbtRequest.SerializeToString,
            walletkit__pb2.FundPsbtResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SignPsbt(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/SignPsbt',
            walletkit__pb2.SignPsbtRequest.SerializeToString,
            walletkit__pb2.SignPsbtResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def FinalizePsbt(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/FinalizePsbt',
            walletkit__pb2.FinalizePsbtRequest.SerializeToString,
            walletkit__pb2.FinalizePsbtResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
