import unittestimport numpy as npfrom diffusers import LMSDiscreteScheduler, OnnxStableDiffusionInpaintPipelinefrom diffusers.utils.testing_utils import is_onnx_available, load_image, require_onnxruntime, require_torch_gpu, slowfrom ...test_pipelines_onnx_common import OnnxPipelineTesterMixinif is_onnx_available():    import onnxruntime as ortclass OnnxStableDiffusionPipelineFastTests(OnnxPipelineTesterMixin, unittest.TestCase):    # FIXME: add fast tests    pass@slow@require_onnxruntime@require_torch_gpuclass OnnxStableDiffusionInpaintPipelineIntegrationTests(unittest.TestCase):    @property    def gpu_provider(self):        return (            "CUDAExecutionProvider",            {                "gpu_mem_limit": "15000000000",  # 15GB                "arena_extend_strategy": "kSameAsRequested",            },        )    @property    def gpu_options(self):        options = ort.SessionOptions()        options.enable_mem_pattern = False        return options    def test_inference_default_pndm(self):        init_image = load_image(            "https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main"            "/in_paint/overture-creations-5sI6fQgYIuo.png"        )        mask_image = load_image(            "https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main"            "/in_paint/overture-creations-5sI6fQgYIuo_mask.png"        )        pipe = OnnxStableDiffusionInpaintPipeline.from_pretrained(            "runwayml/stable-diffusion-inpainting",            revision="onnx",            provider=self.gpu_provider,            sess_options=self.gpu_options,        )        pipe.set_progress_bar_config(disable=None)        prompt = "A red cat sitting on a park bench"        generator = np.random.RandomState(0)        output = pipe(            prompt=prompt,            image=init_image,            mask_image=mask_image,            guidance_scale=7.5,            num_inference_steps=10,            generator=generator,            output_type="np",        )        images = output.images        image_slice = images[0, 255:258, 255:258, -1]        assert images.shape == (1, 512, 512, 3)        expected_slice = np.array([0.2514, 0.3007, 0.3517, 0.1790, 0.2382, 0.3167, 0.1944, 0.2273, 0.2464])        assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-3    def test_inference_k_lms(self):        init_image = load_image(            "https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main"            "/in_paint/overture-creations-5sI6fQgYIuo.png"        )        mask_image = load_image(            "https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main"            "/in_paint/overture-creations-5sI6fQgYIuo_mask.png"        )        lms_scheduler = LMSDiscreteScheduler.from_pretrained(            "runwayml/stable-diffusion-inpainting", subfolder="scheduler", revision="onnx"        )        pipe = OnnxStableDiffusionInpaintPipeline.from_pretrained(            "runwayml/stable-diffusion-inpainting",            revision="onnx",            scheduler=lms_scheduler,            provider=self.gpu_provider,            sess_options=self.gpu_options,        )        pipe.set_progress_bar_config(disable=None)        prompt = "A red cat sitting on a park bench"        generator = np.random.RandomState(0)        output = pipe(            prompt=prompt,            image=init_image,            mask_image=mask_image,            guidance_scale=7.5,            num_inference_steps=10,            generator=generator,            output_type="np",        )        images = output.images        image_slice = images[0, 255:258, 255:258, -1]        assert images.shape == (1, 512, 512, 3)        expected_slice = np.array([0.2520, 0.2743, 0.2643, 0.2641, 0.2517, 0.2650, 0.2498, 0.2688, 0.2529])        assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-3