import unittestimport numpy as npimport torchfrom diffusers import ScoreSdeVePipeline, ScoreSdeVeScheduler, UNet2DModelfrom diffusers.utils.testing_utils import require_torch, slow, torch_devicefrom ...test_pipelines_common import PipelineTesterMixintorch.backends.cuda.matmul.allow_tf32 = Falseclass ScoreSdeVeipelineFastTests(PipelineTesterMixin, unittest.TestCase):    @property    def dummy_uncond_unet(self):        torch.manual_seed(0)        model = UNet2DModel(            block_out_channels=(32, 64),            layers_per_block=2,            sample_size=32,            in_channels=3,            out_channels=3,            down_block_types=("DownBlock2D", "AttnDownBlock2D"),            up_block_types=("AttnUpBlock2D", "UpBlock2D"),        )        return model    def test_inference(self):        unet = self.dummy_uncond_unet        scheduler = ScoreSdeVeScheduler()        sde_ve = ScoreSdeVePipeline(unet=unet, scheduler=scheduler)        sde_ve.to(torch_device)        sde_ve.set_progress_bar_config(disable=None)        generator = torch.manual_seed(0)        image = sde_ve(num_inference_steps=2, output_type="numpy", generator=generator).images        generator = torch.manual_seed(0)        image_from_tuple = sde_ve(num_inference_steps=2, output_type="numpy", generator=generator, return_dict=False)[            0        ]        image_slice = image[0, -3:, -3:, -1]        image_from_tuple_slice = image_from_tuple[0, -3:, -3:, -1]        assert image.shape == (1, 32, 32, 3)        expected_slice = np.array([0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0])        assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-2        assert np.abs(image_from_tuple_slice.flatten() - expected_slice).max() < 1e-2@slow@require_torchclass ScoreSdeVePipelineIntegrationTests(unittest.TestCase):    def test_inference(self):        model_id = "google/ncsnpp-church-256"        model = UNet2DModel.from_pretrained(model_id)        scheduler = ScoreSdeVeScheduler.from_pretrained(model_id)        sde_ve = ScoreSdeVePipeline(unet=model, scheduler=scheduler)        sde_ve.to(torch_device)        sde_ve.set_progress_bar_config(disable=None)        generator = torch.manual_seed(0)        image = sde_ve(num_inference_steps=10, output_type="numpy", generator=generator).images        image_slice = image[0, -3:, -3:, -1]        assert image.shape == (1, 256, 256, 3)        expected_slice = np.array([0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0])        assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-2