import unittestfrom transformers import is_torch_availablefrom transformers.testing_utils import require_torchif is_torch_available():    import torch    from transformers.activations import gelu_new, gelu_python, get_activation@require_torchclass TestActivations(unittest.TestCase):    def test_gelu_versions(self):        x = torch.tensor([-100, -1, -0.1, 0, 0.1, 1.0, 100])        torch_builtin = get_activation("gelu")        self.assertTrue(torch.allclose(gelu_python(x), torch_builtin(x)))        self.assertFalse(torch.allclose(gelu_python(x), gelu_new(x)))    def test_gelu_10(self):        x = torch.tensor([-100, -1, -0.1, 0, 0.1, 1.0, 100])        torch_builtin = get_activation("gelu")        gelu10 = get_activation("gelu_10")        y_gelu = torch_builtin(x)        y_gelu_10 = gelu10(x)        clipped_mask = torch.where(y_gelu_10 < 10.0, 1, 0)        self.assertTrue(torch.max(y_gelu_10).item() == 10.0)        self.assertTrue(torch.allclose(y_gelu * clipped_mask, y_gelu_10 * clipped_mask))    def test_get_activation(self):        get_activation("gelu")        get_activation("gelu_10")        get_activation("gelu_fast")        get_activation("gelu_new")        get_activation("gelu_python")        get_activation("gelu_pytorch_tanh")        get_activation("linear")        get_activation("mish")        get_activation("quick_gelu")        get_activation("relu")        get_activation("sigmoid")        get_activation("silu")        get_activation("swish")        get_activation("tanh")        with self.assertRaises(KeyError):            get_activation("bogus")        with self.assertRaises(KeyError):            get_activation(None)    def test_activations_are_distinct_objects(self):        act1 = get_activation("gelu")        act1.a = 1        act2 = get_activation("gelu")        self.assertEqual(act1.a, 1)        with self.assertRaises(AttributeError):            _ = act2.a