import jsonimport osimport shutilimport tempfileimport unittestimport numpy as npfrom transformers import BertTokenizerFastfrom transformers.models.bert.tokenization_bert import VOCAB_FILES_NAMES, BertTokenizerfrom transformers.testing_utils import require_tokenizers, require_visionfrom transformers.utils import IMAGE_PROCESSOR_NAME, is_vision_availableif is_vision_available():    from PIL import Image    from transformers import VisionTextDualEncoderProcessor, ViTImageProcessor@require_tokenizers@require_visionclass VisionTextDualEncoderProcessorTest(unittest.TestCase):    def setUp(self):        self.tmpdirname = tempfile.mkdtemp()        # fmt: off        vocab_tokens = ["[UNK]", "[CLS]", "[SEP]", "[PAD]", "[MASK]", "want", "##want", "##ed", "wa", "un", "runn", "##ing", ",", "low", "lowest"]        # fmt: on        self.vocab_file = os.path.join(self.tmpdirname, VOCAB_FILES_NAMES["vocab_file"])        with open(self.vocab_file, "w", encoding="utf-8") as vocab_writer:            vocab_writer.write("".join([x + "\n" for x in vocab_tokens]))        image_processor_map = {            "do_resize": True,            "size": {"height": 18, "width": 18},            "do_normalize": True,            "image_mean": [0.5, 0.5, 0.5],            "image_std": [0.5, 0.5, 0.5],        }        self.image_processor_file = os.path.join(self.tmpdirname, IMAGE_PROCESSOR_NAME)        with open(self.image_processor_file, "w", encoding="utf-8") as fp:            json.dump(image_processor_map, fp)    def get_tokenizer(self, **kwargs):        return BertTokenizer.from_pretrained(self.tmpdirname, **kwargs)    def get_image_processor(self, **kwargs):        return ViTImageProcessor.from_pretrained(self.tmpdirname, **kwargs)    def tearDown(self):        shutil.rmtree(self.tmpdirname)    def prepare_image_inputs(self):        """This function prepares a list of PIL images, or a list of numpy arrays if one specifies numpify=True,        or a list of PyTorch tensors if one specifies torchify=True.        """        image_inputs = [np.random.randint(255, size=(3, 30, 400), dtype=np.uint8)]        image_inputs = [Image.fromarray(np.moveaxis(x, 0, -1)) for x in image_inputs]        return image_inputs    def test_save_load_pretrained_default(self):        tokenizer = self.get_tokenizer()        image_processor = self.get_image_processor()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        processor.save_pretrained(self.tmpdirname)        processor = VisionTextDualEncoderProcessor.from_pretrained(self.tmpdirname)        self.assertEqual(processor.tokenizer.get_vocab(), tokenizer.get_vocab())        self.assertIsInstance(processor.tokenizer, (BertTokenizer, BertTokenizerFast))        self.assertEqual(processor.image_processor.to_json_string(), image_processor.to_json_string())        self.assertIsInstance(processor.image_processor, ViTImageProcessor)    def test_save_load_pretrained_additional_features(self):        processor = VisionTextDualEncoderProcessor(            tokenizer=self.get_tokenizer(), image_processor=self.get_image_processor()        )        processor.save_pretrained(self.tmpdirname)        tokenizer_add_kwargs = self.get_tokenizer(bos_token="(BOS)", eos_token="(EOS)")        image_processor_add_kwargs = self.get_image_processor(do_normalize=False, padding_value=1.0)        processor = VisionTextDualEncoderProcessor.from_pretrained(            self.tmpdirname, bos_token="(BOS)", eos_token="(EOS)", do_normalize=False, padding_value=1.0        )        self.assertEqual(processor.tokenizer.get_vocab(), tokenizer_add_kwargs.get_vocab())        self.assertIsInstance(processor.tokenizer, (BertTokenizer, BertTokenizerFast))        self.assertEqual(processor.image_processor.to_json_string(), image_processor_add_kwargs.to_json_string())        self.assertIsInstance(processor.image_processor, ViTImageProcessor)    def test_image_processor(self):        image_processor = self.get_image_processor()        tokenizer = self.get_tokenizer()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        image_input = self.prepare_image_inputs()        input_feat_extract = image_processor(image_input, return_tensors="np")        input_processor = processor(images=image_input, return_tensors="np")        for key in input_feat_extract.keys():            self.assertAlmostEqual(input_feat_extract[key].sum(), input_processor[key].sum(), delta=1e-2)    def test_tokenizer(self):        image_processor = self.get_image_processor()        tokenizer = self.get_tokenizer()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        input_str = "lower newer"        encoded_processor = processor(text=input_str)        encoded_tok = tokenizer(input_str)        for key in encoded_tok.keys():            self.assertListEqual(encoded_tok[key], encoded_processor[key])    def test_processor(self):        image_processor = self.get_image_processor()        tokenizer = self.get_tokenizer()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        input_str = "lower newer"        image_input = self.prepare_image_inputs()        inputs = processor(text=input_str, images=image_input)        self.assertListEqual(list(inputs.keys()), ["input_ids", "token_type_ids", "attention_mask", "pixel_values"])        # test if it raises when no input is passed        with self.assertRaises(ValueError):            processor()    def test_tokenizer_decode(self):        image_processor = self.get_image_processor()        tokenizer = self.get_tokenizer()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        predicted_ids = [[1, 4, 5, 8, 1, 0, 8], [3, 4, 3, 1, 1, 8, 9]]        decoded_processor = processor.batch_decode(predicted_ids)        decoded_tok = tokenizer.batch_decode(predicted_ids)        self.assertListEqual(decoded_tok, decoded_processor)    def test_model_input_names(self):        image_processor = self.get_image_processor()        tokenizer = self.get_tokenizer()        processor = VisionTextDualEncoderProcessor(tokenizer=tokenizer, image_processor=image_processor)        input_str = "lower newer"        image_input = self.prepare_image_inputs()        inputs = processor(text=input_str, images=image_input)        self.assertListEqual(list(inputs.keys()), processor.model_input_names)