""" Testing suite for the PyTorch Mistral model. """import gcimport tempfileimport unittestimport pytestfrom transformers import AutoTokenizer, MistralConfig, is_torch_availablefrom transformers.testing_utils import (    backend_empty_cache,    require_flash_attn,    require_torch,    require_torch_gpu,    slow,    torch_device,)from ...generation.test_utils import GenerationTesterMixinfrom ...test_configuration_common import ConfigTesterfrom ...test_modeling_common import ModelTesterMixin, ids_tensor, random_attention_maskfrom ...test_pipeline_mixin import PipelineTesterMixinif is_torch_available():    import torch    from transformers import (        MistralForCausalLM,        MistralForSequenceClassification,        MistralModel,    )class MistralModelTester:    def __init__(        self,        parent,        batch_size=13,        seq_length=7,        is_training=True,        use_input_mask=True,        use_token_type_ids=False,        use_labels=True,        vocab_size=99,        hidden_size=32,        num_hidden_layers=2,        num_attention_heads=4,        num_key_value_heads=2,        intermediate_size=37,        hidden_act="gelu",        hidden_dropout_prob=0.1,        attention_probs_dropout_prob=0.1,        max_position_embeddings=512,        type_vocab_size=16,        type_sequence_label_size=2,        initializer_range=0.02,        num_labels=3,        num_choices=4,        pad_token_id=0,        scope=None,    ):        self.parent = parent        self.batch_size = batch_size        self.seq_length = seq_length        self.is_training = is_training        self.use_input_mask = use_input_mask        self.use_token_type_ids = use_token_type_ids        self.use_labels = use_labels        self.vocab_size = vocab_size        self.hidden_size = hidden_size        self.num_hidden_layers = num_hidden_layers        self.num_attention_heads = num_attention_heads        self.num_key_value_heads = num_key_value_heads        self.intermediate_size = intermediate_size        self.hidden_act = hidden_act        self.hidden_dropout_prob = hidden_dropout_prob        self.attention_probs_dropout_prob = attention_probs_dropout_prob        self.max_position_embeddings = max_position_embeddings        self.type_vocab_size = type_vocab_size        self.type_sequence_label_size = type_sequence_label_size        self.initializer_range = initializer_range        self.num_labels = num_labels        self.num_choices = num_choices        self.pad_token_id = pad_token_id        self.scope = scope    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.prepare_config_and_inputs    def prepare_config_and_inputs(self):        input_ids = ids_tensor([self.batch_size, self.seq_length], self.vocab_size)        input_mask = None        if self.use_input_mask:            input_mask = random_attention_mask([self.batch_size, self.seq_length])        token_type_ids = None        if self.use_token_type_ids:            token_type_ids = ids_tensor([self.batch_size, self.seq_length], self.type_vocab_size)        sequence_labels = None        token_labels = None        choice_labels = None        if self.use_labels:            sequence_labels = ids_tensor([self.batch_size], self.type_sequence_label_size)            token_labels = ids_tensor([self.batch_size, self.seq_length], self.num_labels)            choice_labels = ids_tensor([self.batch_size], self.num_choices)        config = self.get_config()        return config, input_ids, token_type_ids, input_mask, sequence_labels, token_labels, choice_labels    def get_config(self):        return MistralConfig(            vocab_size=self.vocab_size,            hidden_size=self.hidden_size,            num_hidden_layers=self.num_hidden_layers,            num_attention_heads=self.num_attention_heads,            num_key_value_heads=self.num_key_value_heads,            intermediate_size=self.intermediate_size,            hidden_act=self.hidden_act,            hidden_dropout_prob=self.hidden_dropout_prob,            attention_probs_dropout_prob=self.attention_probs_dropout_prob,            max_position_embeddings=self.max_position_embeddings,            type_vocab_size=self.type_vocab_size,            is_decoder=False,            initializer_range=self.initializer_range,            pad_token_id=self.pad_token_id,        )    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.create_and_check_model with Llama->Mistral    def create_and_check_model(        self, config, input_ids, token_type_ids, input_mask, sequence_labels, token_labels, choice_labels    ):        model = MistralModel(config=config)        model.to(torch_device)        model.eval()        result = model(input_ids, attention_mask=input_mask)        result = model(input_ids)        self.parent.assertEqual(result.last_hidden_state.shape, (self.batch_size, self.seq_length, self.hidden_size))    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.create_and_check_model_as_decoder with Llama->Mistral    def create_and_check_model_as_decoder(        self,        config,        input_ids,        token_type_ids,        input_mask,        sequence_labels,        token_labels,        choice_labels,        encoder_hidden_states,        encoder_attention_mask,    ):        config.add_cross_attention = True        model = MistralModel(config)        model.to(torch_device)        model.eval()        result = model(            input_ids,            attention_mask=input_mask,            encoder_hidden_states=encoder_hidden_states,            encoder_attention_mask=encoder_attention_mask,        )        result = model(            input_ids,            attention_mask=input_mask,            encoder_hidden_states=encoder_hidden_states,        )        result = model(input_ids, attention_mask=input_mask)        self.parent.assertEqual(result.last_hidden_state.shape, (self.batch_size, self.seq_length, self.hidden_size))    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.create_and_check_for_causal_lm with Llama->Mistral    def create_and_check_for_causal_lm(        self,        config,        input_ids,        token_type_ids,        input_mask,        sequence_labels,        token_labels,        choice_labels,        encoder_hidden_states,        encoder_attention_mask,    ):        model = MistralForCausalLM(config=config)        model.to(torch_device)        model.eval()        result = model(input_ids, attention_mask=input_mask, labels=token_labels)        self.parent.assertEqual(result.logits.shape, (self.batch_size, self.seq_length, self.vocab_size))    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.create_and_check_decoder_model_past_large_inputs with Llama->Mistral    def create_and_check_decoder_model_past_large_inputs(        self,        config,        input_ids,        token_type_ids,        input_mask,        sequence_labels,        token_labels,        choice_labels,        encoder_hidden_states,        encoder_attention_mask,    ):        config.is_decoder = True        config.add_cross_attention = True        model = MistralForCausalLM(config=config)        model.to(torch_device)        model.eval()        # first forward pass        outputs = model(            input_ids,            attention_mask=input_mask,            encoder_hidden_states=encoder_hidden_states,            encoder_attention_mask=encoder_attention_mask,            use_cache=True,        )        past_key_values = outputs.past_key_values        # create hypothetical multiple next token and extent to next_input_ids        next_tokens = ids_tensor((self.batch_size, 3), config.vocab_size)        next_mask = ids_tensor((self.batch_size, 3), vocab_size=2)        # append to next input_ids and        next_input_ids = torch.cat([input_ids, next_tokens], dim=-1)        next_attention_mask = torch.cat([input_mask, next_mask], dim=-1)        output_from_no_past = model(            next_input_ids,            attention_mask=next_attention_mask,            encoder_hidden_states=encoder_hidden_states,            encoder_attention_mask=encoder_attention_mask,            output_hidden_states=True,        )["hidden_states"][0]        output_from_past = model(            next_tokens,            attention_mask=next_attention_mask,            encoder_hidden_states=encoder_hidden_states,            encoder_attention_mask=encoder_attention_mask,            past_key_values=past_key_values,            output_hidden_states=True,        )["hidden_states"][0]        # select random slice        random_slice_idx = ids_tensor((1,), output_from_past.shape[-1]).item()        output_from_no_past_slice = output_from_no_past[:, -3:, random_slice_idx].detach()        output_from_past_slice = output_from_past[:, :, random_slice_idx].detach()        self.parent.assertTrue(output_from_past_slice.shape[1] == next_tokens.shape[1])        # test that outputs are equal for slice        self.parent.assertTrue(torch.allclose(output_from_past_slice, output_from_no_past_slice, atol=1e-3))    # Copied from tests.models.llama.test_modeling_llama.LlamaModelTester.prepare_config_and_inputs_for_common    def prepare_config_and_inputs_for_common(self):        config_and_inputs = self.prepare_config_and_inputs()        (            config,            input_ids,            token_type_ids,            input_mask,            sequence_labels,            token_labels,            choice_labels,        ) = config_and_inputs        inputs_dict = {"input_ids": input_ids, "attention_mask": input_mask}        return config, inputs_dict@require_torchclass MistralModelTest(ModelTesterMixin, GenerationTesterMixin, PipelineTesterMixin, unittest.TestCase):    all_model_classes = (        (MistralModel, MistralForCausalLM, MistralForSequenceClassification) if is_torch_available() else ()    )    all_generative_model_classes = (MistralForCausalLM,) if is_torch_available() else ()    pipeline_model_mapping = (        {            "feature-extraction": MistralModel,            "text-classification": MistralForSequenceClassification,            "text-generation": MistralForCausalLM,            "zero-shot": MistralForSequenceClassification,        }        if is_torch_available()        else {}    )    test_headmasking = False    test_pruning = False    def setUp(self):        self.model_tester = MistralModelTester(self)        self.config_tester = ConfigTester(self, config_class=MistralConfig, hidden_size=37)    def test_config(self):        self.config_tester.run_common_tests()    def test_model(self):        config_and_inputs = self.model_tester.prepare_config_and_inputs()        self.model_tester.create_and_check_model(*config_and_inputs)    def test_model_various_embeddings(self):        config_and_inputs = self.model_tester.prepare_config_and_inputs()        for type in ["absolute", "relative_key", "relative_key_query"]:            config_and_inputs[0].position_embedding_type = type            self.model_tester.create_and_check_model(*config_and_inputs)    def test_Mistral_sequence_classification_model(self):        config, input_dict = self.model_tester.prepare_config_and_inputs_for_common()        print(config)        config.num_labels = 3        input_ids = input_dict["input_ids"]        attention_mask = input_ids.ne(1).to(torch_device)        sequence_labels = ids_tensor([self.model_tester.batch_size], self.model_tester.type_sequence_label_size)        model = MistralForSequenceClassification(config)        model.to(torch_device)        model.eval()        result = model(input_ids, attention_mask=attention_mask, labels=sequence_labels)        self.assertEqual(result.logits.shape, (self.model_tester.batch_size, self.model_tester.num_labels))    def test_Mistral_sequence_classification_model_for_single_label(self):        config, input_dict = self.model_tester.prepare_config_and_inputs_for_common()        config.num_labels = 3        config.problem_type = "single_label_classification"        input_ids = input_dict["input_ids"]        attention_mask = input_ids.ne(1).to(torch_device)        sequence_labels = ids_tensor([self.model_tester.batch_size], self.model_tester.type_sequence_label_size)        model = MistralForSequenceClassification(config)        model.to(torch_device)        model.eval()        result = model(input_ids, attention_mask=attention_mask, labels=sequence_labels)        self.assertEqual(result.logits.shape, (self.model_tester.batch_size, self.model_tester.num_labels))    def test_Mistral_sequence_classification_model_for_multi_label(self):        config, input_dict = self.model_tester.prepare_config_and_inputs_for_common()        config.num_labels = 3        config.problem_type = "multi_label_classification"        input_ids = input_dict["input_ids"]        attention_mask = input_ids.ne(1).to(torch_device)        sequence_labels = ids_tensor(            [self.model_tester.batch_size, config.num_labels], self.model_tester.type_sequence_label_size        ).to(torch.float)        model = MistralForSequenceClassification(config)        model.to(torch_device)        model.eval()        result = model(input_ids, attention_mask=attention_mask, labels=sequence_labels)        self.assertEqual(result.logits.shape, (self.model_tester.batch_size, self.model_tester.num_labels))    @unittest.skip("Mistral buffers include complex numbers, which breaks this test")    def test_save_load_fast_init_from_base(self):        pass    @unittest.skip("Mistral uses GQA on all models so the KV cache is a non standard format")    def test_past_key_values_format(self):        pass    @require_flash_attn    @require_torch_gpu    @pytest.mark.flash_attn_test    @slow    def test_flash_attn_2_generate_padding_right(self):        import torch        for model_class in self.all_generative_model_classes:            if not model_class._supports_flash_attn_2:                return            config, _ = self.model_tester.prepare_config_and_inputs_for_common()            model = model_class(config)            with tempfile.TemporaryDirectory() as tmpdirname:                model.save_pretrained(tmpdirname)                model = model_class.from_pretrained(                    tmpdirname, torch_dtype=torch.float16, use_flash_attention_2=False, low_cpu_mem_usage=True                ).to(torch_device)                dummy_input = torch.LongTensor([[0, 2, 3, 4], [0, 2, 3, 4]]).to(torch_device)                dummy_attention_mask = torch.LongTensor([[1, 1, 1, 1], [1, 1, 1, 0]]).to(torch_device)                model.generate(dummy_input, attention_mask=dummy_attention_mask, max_new_tokens=1, do_sample=False)                model = model_class.from_pretrained(                    tmpdirname, torch_dtype=torch.float16, use_flash_attention_2=True, low_cpu_mem_usage=True                ).to(torch_device)                with self.assertRaises(ValueError):                    _ = model.generate(                        dummy_input, attention_mask=dummy_attention_mask, max_new_tokens=1, do_sample=False                    )    @require_flash_attn    @require_torch_gpu    @pytest.mark.flash_attn_test    @slow    def test_flash_attn_2_inference_padding_right(self):        import torch        for model_class in self.all_model_classes:            if not model_class._supports_flash_attn_2:                return            config, _ = self.model_tester.prepare_config_and_inputs_for_common()            model = model_class(config)            with tempfile.TemporaryDirectory() as tmpdirname:                model.save_pretrained(tmpdirname)                model_fa = model_class.from_pretrained(                    tmpdirname, torch_dtype=torch.bfloat16, use_flash_attention_2=True                )                model_fa.to(torch_device)                model = model_class.from_pretrained(                    tmpdirname, torch_dtype=torch.bfloat16, use_flash_attention_2=False                )                model.to(torch_device)                dummy_input = torch.LongTensor([[1, 2, 3, 4, 5]]).to(torch_device)                dummy_attention_mask = torch.LongTensor([[1, 1, 1, 1, 0]]).to(torch_device)                _ = model(dummy_input, output_hidden_states=True).hidden_states[-1]                with self.assertRaises(ValueError):                    _ = model_fa(                        dummy_input, attention_mask=dummy_attention_mask, output_hidden_states=True                    ).hidden_states[-1]@require_torchclass MistralIntegrationTest(unittest.TestCase):    @slow    def test_model_7b_logits(self):        input_ids = [1, 306, 4658, 278, 6593, 310, 2834, 338]        model = MistralForCausalLM.from_pretrained("mistralai/Mistral-7B-v0.1", device_map="auto")        input_ids = torch.tensor([input_ids]).to(model.model.embed_tokens.weight.device)        with torch.no_grad():            out = model(input_ids).logits.cpu()        # Expected mean on dim = -1        EXPECTED_MEAN = torch.tensor([[-2.5548, -2.5737, -3.0600, -2.5906, -2.8478, -2.8118, -2.9325, -2.7694]])        torch.testing.assert_close(out.mean(-1), EXPECTED_MEAN, atol=1e-2, rtol=1e-2)        # slicing logits[0, 0, 0:30]        # fmt: off        EXPECTED_SLICE = torch.tensor([-5.8781, -5.8616, -0.1052, -4.7200, -5.8781, -5.8774, -5.8773, -5.8777, -5.8781, -5.8780, -5.8781, -5.8779, -1.0787,  1.7583, -5.8779, -5.8780, -5.8783, -5.8778, -5.8776, -5.8781, -5.8784, -5.8778, -5.8778, -5.8777, -5.8779, -5.8778, -5.8776, -5.8780, -5.8779, -5.8781])        # fmt: on        print(out[0, 0, :30])        torch.testing.assert_close(out[0, 0, :30], EXPECTED_SLICE, atol=1e-4, rtol=1e-4)        del model        backend_empty_cache(torch_device)        gc.collect()    @slow    def test_model_7b_generation(self):        EXPECTED_TEXT_COMPLETION = """My favourite condiment is 100% ketchup. I love it on everything. I’m not a big"""        prompt = "My favourite condiment is "        tokenizer = AutoTokenizer.from_pretrained("mistralai/Mistral-7B-v0.1", use_fast=False)        model = MistralForCausalLM.from_pretrained("mistralai/Mistral-7B-v0.1", device_map="auto")        input_ids = tokenizer.encode(prompt, return_tensors="pt").to(model.model.embed_tokens.weight.device)        # greedy generation outputs        generated_ids = model.generate(input_ids, max_new_tokens=20, temperature=0)        text = tokenizer.decode(generated_ids[0], skip_special_tokens=True)        self.assertEqual(EXPECTED_TEXT_COMPLETION, text)        del model        backend_empty_cache(torch_device)        gc.collect()