""" Testing suite for the TensorFlow ConvNext model. """from __future__ import annotationsimport inspectimport unittestfrom typing import List, Tupleimport numpy as npfrom transformers import ConvNextV2Configfrom transformers.testing_utils import require_tf, require_vision, slowfrom transformers.utils import cached_property, is_tf_available, is_vision_availablefrom ...test_configuration_common import ConfigTesterfrom ...test_modeling_tf_common import TFModelTesterMixin, floats_tensor, ids_tensorfrom ...test_pipeline_mixin import PipelineTesterMixinif is_tf_available():    import tensorflow as tf    from transformers import TFConvNextV2ForImageClassification, TFConvNextV2Modelif is_vision_available():    from PIL import Image    from transformers import ConvNextImageProcessorclass TFConvNextV2ModelTester:    def __init__(        self,        parent,        batch_size=13,        image_size=32,        num_channels=3,        num_stages=4,        hidden_sizes=[10, 20, 30, 40],        depths=[2, 2, 3, 2],        is_training=True,        use_labels=True,        intermediate_size=37,        hidden_act="gelu",        type_sequence_label_size=10,        initializer_range=0.02,        num_labels=3,        scope=None,    ):        self.parent = parent        self.batch_size = batch_size        self.image_size = image_size        self.num_channels = num_channels        self.num_stages = num_stages        self.hidden_sizes = hidden_sizes        self.depths = depths        self.is_training = is_training        self.use_labels = use_labels        self.intermediate_size = intermediate_size        self.hidden_act = hidden_act        self.type_sequence_label_size = type_sequence_label_size        self.initializer_range = initializer_range        self.scope = scope    def prepare_config_and_inputs(self):        pixel_values = floats_tensor([self.batch_size, self.num_channels, self.image_size, self.image_size])        labels = None        if self.use_labels:            labels = ids_tensor([self.batch_size], self.type_sequence_label_size)        config = self.get_config()        return config, pixel_values, labels    def get_config(self):        return ConvNextV2Config(            num_channels=self.num_channels,            hidden_sizes=self.hidden_sizes,            depths=self.depths,            num_stages=self.num_stages,            hidden_act=self.hidden_act,            is_decoder=False,            initializer_range=self.initializer_range,        )    def create_and_check_model(self, config, pixel_values, labels):        model = TFConvNextV2Model(config=config)        result = model(pixel_values, training=False)        # expected last hidden states: batch_size, channels, height // 32, width // 32        self.parent.assertEqual(            result.last_hidden_state.shape,            (self.batch_size, self.hidden_sizes[-1], self.image_size // 32, self.image_size // 32),        )    def create_and_check_for_image_classification(self, config, pixel_values, labels):        config.num_labels = self.type_sequence_label_size        model = TFConvNextV2ForImageClassification(config)        result = model(pixel_values, labels=labels, training=False)        self.parent.assertEqual(result.logits.shape, (self.batch_size, self.type_sequence_label_size))    def prepare_config_and_inputs_for_common(self):        config_and_inputs = self.prepare_config_and_inputs()        config, pixel_values, labels = config_and_inputs        inputs_dict = {"pixel_values": pixel_values}        return config, inputs_dict@require_tfclass TFConvNextV2ModelTest(TFModelTesterMixin, PipelineTesterMixin, unittest.TestCase):    """    Here we also overwrite some of the tests of test_modeling_common.py, as ConvNext does not use input_ids, inputs_embeds,    attention_mask and seq_length.    """    all_model_classes = (TFConvNextV2Model, TFConvNextV2ForImageClassification) if is_tf_available() else ()    pipeline_model_mapping = (        {"feature-extraction": TFConvNextV2Model, "image-classification": TFConvNextV2ForImageClassification}        if is_tf_available()        else {}    )    test_pruning = False    test_onnx = False    test_resize_embeddings = False    test_head_masking = False    has_attentions = False    def setUp(self):        self.model_tester = TFConvNextV2ModelTester(self)        self.config_tester = ConfigTester(            self,            config_class=ConvNextV2Config,            has_text_modality=False,            hidden_size=37,        )    @unittest.skip(reason="ConvNext does not use inputs_embeds")    def test_inputs_embeds(self):        pass    @unittest.skipIf(        not is_tf_available() or len(tf.config.list_physical_devices("GPU")) == 0,        reason="TF does not support backprop for grouped convolutions on CPU.",    )    @slow    def test_keras_fit(self):        super().test_keras_fit()    @unittest.skip(reason="ConvNext does not support input and output embeddings")    def test_model_common_attributes(self):        pass    def test_forward_signature(self):        config, _ = self.model_tester.prepare_config_and_inputs_for_common()        for model_class in self.all_model_classes:            model = model_class(config)            signature = inspect.signature(model.call)            # signature.parameters is an OrderedDict => so arg_names order is deterministic            arg_names = [*signature.parameters.keys()]            expected_arg_names = ["pixel_values"]            self.assertListEqual(arg_names[:1], expected_arg_names)    def test_model(self):        config_and_inputs = self.model_tester.prepare_config_and_inputs()        self.model_tester.create_and_check_model(*config_and_inputs)    @unittest.skipIf(        not is_tf_available() or len(tf.config.list_physical_devices("GPU")) == 0,        reason="TF does not support backprop for grouped convolutions on CPU.",    )    def test_dataset_conversion(self):        super().test_dataset_conversion()    def test_hidden_states_output(self):        def check_hidden_states_output(inputs_dict, config, model_class):            model = model_class(config)            outputs = model(**self._prepare_for_class(inputs_dict, model_class))            hidden_states = outputs.encoder_hidden_states if config.is_encoder_decoder else outputs.hidden_states            expected_num_stages = self.model_tester.num_stages            self.assertEqual(len(hidden_states), expected_num_stages + 1)            # ConvNext's feature maps are of shape (batch_size, num_channels, height, width)            self.assertListEqual(                list(hidden_states[0].shape[-2:]),                [self.model_tester.image_size // 4, self.model_tester.image_size // 4],            )        config, inputs_dict = self.model_tester.prepare_config_and_inputs_for_common()        for model_class in self.all_model_classes:            inputs_dict["output_hidden_states"] = True            check_hidden_states_output(inputs_dict, config, model_class)            # check that output_hidden_states also work using config            del inputs_dict["output_hidden_states"]            config.output_hidden_states = True            check_hidden_states_output(inputs_dict, config, model_class)    # Since ConvNext does not have any attention we need to rewrite this test.    def test_model_outputs_equivalence(self):        config, inputs_dict = self.model_tester.prepare_config_and_inputs_for_common()        def check_equivalence(model, tuple_inputs, dict_inputs, additional_kwargs={}):            tuple_output = model(tuple_inputs, return_dict=False, **additional_kwargs)            dict_output = model(dict_inputs, return_dict=True, **additional_kwargs).to_tuple()            def recursive_check(tuple_object, dict_object):                if isinstance(tuple_object, (List, Tuple)):                    for tuple_iterable_value, dict_iterable_value in zip(tuple_object, dict_object):                        recursive_check(tuple_iterable_value, dict_iterable_value)                elif tuple_object is None:                    return                else:                    self.assertTrue(                        all(tf.equal(tuple_object, dict_object)),                        msg=(                            "Tuple and dict output are not equal. Difference:"                            f" {tf.math.reduce_max(tf.abs(tuple_object - dict_object))}"                        ),                    )                recursive_check(tuple_output, dict_output)        for model_class in self.all_model_classes:            model = model_class(config)            tuple_inputs = self._prepare_for_class(inputs_dict, model_class)            dict_inputs = self._prepare_for_class(inputs_dict, model_class)            check_equivalence(model, tuple_inputs, dict_inputs)            tuple_inputs = self._prepare_for_class(inputs_dict, model_class, return_labels=True)            dict_inputs = self._prepare_for_class(inputs_dict, model_class, return_labels=True)            check_equivalence(model, tuple_inputs, dict_inputs)            tuple_inputs = self._prepare_for_class(inputs_dict, model_class)            dict_inputs = self._prepare_for_class(inputs_dict, model_class)            check_equivalence(model, tuple_inputs, dict_inputs, {"output_hidden_states": True})            tuple_inputs = self._prepare_for_class(inputs_dict, model_class, return_labels=True)            dict_inputs = self._prepare_for_class(inputs_dict, model_class, return_labels=True)            check_equivalence(model, tuple_inputs, dict_inputs, {"output_hidden_states": True})    def test_for_image_classification(self):        config_and_inputs = self.model_tester.prepare_config_and_inputs()        self.model_tester.create_and_check_for_image_classification(*config_and_inputs)    @slow    def test_model_from_pretrained(self):        model = TFConvNextV2Model.from_pretrained("facebook/convnextv2-tiny-1k-224")        self.assertIsNotNone(model)# We will verify our results on an image of cute catsdef prepare_img():    image = Image.open("./tests/fixtures/tests_samples/COCO/000000039769.png")    return image@require_tf@require_visionclass TFConvNextV2ModelIntegrationTest(unittest.TestCase):    @cached_property    def default_image_processor(self):        return (            ConvNextImageProcessor.from_pretrained("facebook/convnextv2-tiny-1k-224")            if is_vision_available()            else None        )    @slow    def test_inference_image_classification_head(self):        model = TFConvNextV2ForImageClassification.from_pretrained("facebook/convnextv2-tiny-1k-224")        image_processor = self.default_image_processor        image = prepare_img()        inputs = image_processor(images=image, return_tensors="tf")        # forward pass        outputs = model(**inputs)        # verify the logits        expected_shape = tf.TensorShape((1, 1000))        self.assertEqual(outputs.logits.shape, expected_shape)        expected_slice = np.array([0.9996, 0.1966, -0.4386])        self.assertTrue(np.allclose(outputs.logits[0, :3].numpy(), expected_slice, atol=1e-4))