""" PyTorch LayoutLMv2 model."""import mathfrom typing import Optional, Tuple, Unionimport torchimport torch.utils.checkpointfrom torch import nnfrom torch.nn import BCEWithLogitsLoss, CrossEntropyLoss, MSELossfrom ...activations import ACT2FNfrom ...modeling_outputs import (    BaseModelOutput,    BaseModelOutputWithPooling,    QuestionAnsweringModelOutput,    SequenceClassifierOutput,    TokenClassifierOutput,)from ...modeling_utils import PreTrainedModelfrom ...pytorch_utils import apply_chunking_to_forwardfrom ...utils import (    add_start_docstrings,    add_start_docstrings_to_model_forward,    is_detectron2_available,    logging,    replace_return_docstrings,    requires_backends,)from .configuration_layoutlmv2 import LayoutLMv2Config# soft dependencyif is_detectron2_available():    import detectron2    from detectron2.modeling import META_ARCH_REGISTRYlogger = logging.get_logger(__name__)_CHECKPOINT_FOR_DOC = "microsoft/layoutlmv2-base-uncased"_CONFIG_FOR_DOC = "LayoutLMv2Config"LAYOUTLMV2_PRETRAINED_MODEL_ARCHIVE_LIST = [    "microsoft/layoutlmv2-base-uncased",    "microsoft/layoutlmv2-large-uncased",    # See all LayoutLMv2 models at https://huggingface.co/models?filter=layoutlmv2]class LayoutLMv2Embeddings(nn.Module):    """Construct the embeddings from word, position and token_type embeddings."""    def __init__(self, config):        super(LayoutLMv2Embeddings, self).__init__()        self.word_embeddings = nn.Embedding(config.vocab_size, config.hidden_size, padding_idx=config.pad_token_id)        self.position_embeddings = nn.Embedding(config.max_position_embeddings, config.hidden_size)        self.x_position_embeddings = nn.Embedding(config.max_2d_position_embeddings, config.coordinate_size)        self.y_position_embeddings = nn.Embedding(config.max_2d_position_embeddings, config.coordinate_size)        self.h_position_embeddings = nn.Embedding(config.max_2d_position_embeddings, config.shape_size)        self.w_position_embeddings = nn.Embedding(config.max_2d_position_embeddings, config.shape_size)        self.token_type_embeddings = nn.Embedding(config.type_vocab_size, config.hidden_size)        self.LayerNorm = nn.LayerNorm(config.hidden_size, eps=config.layer_norm_eps)        self.dropout = nn.Dropout(config.hidden_dropout_prob)        self.register_buffer(            "position_ids", torch.arange(config.max_position_embeddings).expand((1, -1)), persistent=False        )    def _calc_spatial_position_embeddings(self, bbox):        try:            left_position_embeddings = self.x_position_embeddings(bbox[:, :, 0])            upper_position_embeddings = self.y_position_embeddings(bbox[:, :, 1])            right_position_embeddings = self.x_position_embeddings(bbox[:, :, 2])            lower_position_embeddings = self.y_position_embeddings(bbox[:, :, 3])        except IndexError as e:            raise IndexError("The `bbox` coordinate values should be within 0-1000 range.") from e        h_position_embeddings = self.h_position_embeddings(bbox[:, :, 3] - bbox[:, :, 1])        w_position_embeddings = self.w_position_embeddings(bbox[:, :, 2] - bbox[:, :, 0])        spatial_position_embeddings = torch.cat(            [                left_position_embeddings,                upper_position_embeddings,                right_position_embeddings,                lower_position_embeddings,                h_position_embeddings,                w_position_embeddings,            ],            dim=-1,        )        return spatial_position_embeddingsclass LayoutLMv2SelfAttention(nn.Module):    def __init__(self, config):        super().__init__()        if config.hidden_size % config.num_attention_heads != 0 and not hasattr(config, "embedding_size"):            raise ValueError(                f"The hidden size ({config.hidden_size}) is not a multiple of the number of attention "                f"heads ({config.num_attention_heads})"            )        self.fast_qkv = config.fast_qkv        self.num_attention_heads = config.num_attention_heads        self.attention_head_size = int(config.hidden_size / config.num_attention_heads)        self.all_head_size = self.num_attention_heads * self.attention_head_size        self.has_relative_attention_bias = config.has_relative_attention_bias        self.has_spatial_attention_bias = config.has_spatial_attention_bias        if config.fast_qkv:            self.qkv_linear = nn.Linear(config.hidden_size, 3 * self.all_head_size, bias=False)            self.q_bias = nn.Parameter(torch.zeros(1, 1, self.all_head_size))            self.v_bias = nn.Parameter(torch.zeros(1, 1, self.all_head_size))        else:            self.query = nn.Linear(config.hidden_size, self.all_head_size)            self.key = nn.Linear(config.hidden_size, self.all_head_size)            self.value = nn.Linear(config.hidden_size, self.all_head_size)        self.dropout = nn.Dropout(config.attention_probs_dropout_prob)    def transpose_for_scores(self, x):        new_x_shape = x.size()[:-1] + (self.num_attention_heads, self.attention_head_size)        x = x.view(*new_x_shape)        return x.permute(0, 2, 1, 3)    def compute_qkv(self, hidden_states):        if self.fast_qkv:            qkv = self.qkv_linear(hidden_states)            q, k, v = torch.chunk(qkv, 3, dim=-1)            if q.ndimension() == self.q_bias.ndimension():                q = q + self.q_bias                v = v + self.v_bias            else:                _sz = (1,) * (q.ndimension() - 1) + (-1,)                q = q + self.q_bias.view(*_sz)                v = v + self.v_bias.view(*_sz)        else:            q = self.query(hidden_states)            k = self.key(hidden_states)            v = self.value(hidden_states)        return q, k, v    def forward(        self,        hidden_states,        attention_mask=None,        head_mask=None,        output_attentions=False,        rel_pos=None,        rel_2d_pos=None,    ):        q, k, v = self.compute_qkv(hidden_states)        # (B, L, H*D) -> (B, H, L, D)        query_layer = self.transpose_for_scores(q)        key_layer = self.transpose_for_scores(k)        value_layer = self.transpose_for_scores(v)        query_layer = query_layer / math.sqrt(self.attention_head_size)        # [BSZ, NAT, L, L]        attention_scores = torch.matmul(query_layer, key_layer.transpose(-1, -2))        if self.has_relative_attention_bias:            attention_scores += rel_pos        if self.has_spatial_attention_bias:            attention_scores += rel_2d_pos        attention_scores = attention_scores.float().masked_fill_(            attention_mask.to(torch.bool), torch.finfo(attention_scores.dtype).min        )        attention_probs = nn.functional.softmax(attention_scores, dim=-1, dtype=torch.float32).type_as(value_layer)        # This is actually dropping out entire tokens to attend to, which might        # seem a bit unusual, but is taken from the original Transformer paper.        attention_probs = self.dropout(attention_probs)        # Mask heads if we want to        if head_mask is not None:            attention_probs = attention_probs * head_mask        context_layer = torch.matmul(attention_probs, value_layer)        context_layer = context_layer.permute(0, 2, 1, 3).contiguous()        new_context_layer_shape = context_layer.size()[:-2] + (self.all_head_size,)        context_layer = context_layer.view(*new_context_layer_shape)        outputs = (context_layer, attention_probs) if output_attentions else (context_layer,)        return outputsclass LayoutLMv2Attention(nn.Module):    def __init__(self, config):        super().__init__()        self.self = LayoutLMv2SelfAttention(config)        self.output = LayoutLMv2SelfOutput(config)    def forward(        self,        hidden_states,        attention_mask=None,        head_mask=None,        output_attentions=False,        rel_pos=None,        rel_2d_pos=None,    ):        self_outputs = self.self(            hidden_states,            attention_mask,            head_mask,            output_attentions,            rel_pos=rel_pos,            rel_2d_pos=rel_2d_pos,        )        attention_output = self.output(self_outputs[0], hidden_states)        outputs = (attention_output,) + self_outputs[1:]  # add attentions if we output them        return outputsclass LayoutLMv2SelfOutput(nn.Module):    def __init__(self, config):        super().__init__()        self.dense = nn.Linear(config.hidden_size, config.hidden_size)        self.LayerNorm = nn.LayerNorm(config.hidden_size, eps=config.layer_norm_eps)        self.dropout = nn.Dropout(config.hidden_dropout_prob)    def forward(self, hidden_states, input_tensor):        hidden_states = self.dense(hidden_states)        hidden_states = self.dropout(hidden_states)        hidden_states = self.LayerNorm(hidden_states + input_tensor)        return hidden_states# Copied from transformers.models.bert.modeling_bert.BertIntermediate with Bert->LayoutLMv2class LayoutLMv2Intermediate(nn.Module):    def __init__(self, config):        super().__init__()        self.dense = nn.Linear(config.hidden_size, config.intermediate_size)        if isinstance(config.hidden_act, str):            self.intermediate_act_fn = ACT2FN[config.hidden_act]        else:            self.intermediate_act_fn = config.hidden_act    def forward(self, hidden_states: torch.Tensor) -> torch.Tensor:        hidden_states = self.dense(hidden_states)        hidden_states = self.intermediate_act_fn(hidden_states)        return hidden_states# Copied from transformers.models.bert.modeling_bert.BertOutput with Bert->LayoutLMclass LayoutLMv2Output(nn.Module):    def __init__(self, config):        super().__init__()        self.dense = nn.Linear(config.intermediate_size, config.hidden_size)        self.LayerNorm = nn.LayerNorm(config.hidden_size, eps=config.layer_norm_eps)        self.dropout = nn.Dropout(config.hidden_dropout_prob)    def forward(self, hidden_states: torch.Tensor, input_tensor: torch.Tensor) -> torch.Tensor:        hidden_states = self.dense(hidden_states)        hidden_states = self.dropout(hidden_states)        hidden_states = self.LayerNorm(hidden_states + input_tensor)        return hidden_statesclass LayoutLMv2Layer(nn.Module):    def __init__(self, config):        super().__init__()        self.chunk_size_feed_forward = config.chunk_size_feed_forward        self.seq_len_dim = 1        self.attention = LayoutLMv2Attention(config)        self.intermediate = LayoutLMv2Intermediate(config)        self.output = LayoutLMv2Output(config)    def forward(        self,        hidden_states,        attention_mask=None,        head_mask=None,        output_attentions=False,        rel_pos=None,        rel_2d_pos=None,    ):        self_attention_outputs = self.attention(            hidden_states,            attention_mask,            head_mask,            output_attentions=output_attentions,            rel_pos=rel_pos,            rel_2d_pos=rel_2d_pos,        )        attention_output = self_attention_outputs[0]        outputs = self_attention_outputs[1:]  # add self attentions if we output attention weights        layer_output = apply_chunking_to_forward(            self.feed_forward_chunk, self.chunk_size_feed_forward, self.seq_len_dim, attention_output        )        outputs = (layer_output,) + outputs        return outputs    def feed_forward_chunk(self, attention_output):        intermediate_output = self.intermediate(attention_output)        layer_output = self.output(intermediate_output, attention_output)        return layer_outputdef relative_position_bucket(relative_position, bidirectional=True, num_buckets=32, max_distance=128):    """    Adapted from Mesh Tensorflow:    https://github.com/tensorflow/mesh/blob/0cb87fe07da627bf0b7e60475d59f95ed6b5be3d/mesh_tensorflow/transformer/transformer_layers.py#L593    Translate relative position to a bucket number for relative attention. The relative position is defined as    memory_position - query_position, i.e. the distance in tokens from the attending position to the attended-to    position. If bidirectional=False, then positive relative positions are invalid. We use smaller buckets for small    absolute relative_position and larger buckets for larger absolute relative_positions. All relative positions    >=max_distance map to the same bucket. All relative positions <=-max_distance map to the same bucket. This should    allow for more graceful generalization to longer sequences than the model has been trained on.    Args:        relative_position: an int32 Tensor        bidirectional: a boolean - whether the attention is bidirectional        num_buckets: an integer        max_distance: an integer    Returns:        a Tensor with the same shape as relative_position, containing int32 values in the range [0, num_buckets)    """    ret = 0    if bidirectional:        num_buckets //= 2        ret += (relative_position > 0).long() * num_buckets        n = torch.abs(relative_position)    else:        n = torch.max(-relative_position, torch.zeros_like(relative_position))    # now n is in the range [0, inf)    # half of the buckets are for exact increments in positions    max_exact = num_buckets // 2    is_small = n < max_exact    # The other half of the buckets are for logarithmically bigger bins in positions up to max_distance    val_if_large = max_exact + (        torch.log(n.float() / max_exact) / math.log(max_distance / max_exact) * (num_buckets - max_exact)    ).to(torch.long)    val_if_large = torch.min(val_if_large, torch.full_like(val_if_large, num_buckets - 1))    ret += torch.where(is_small, n, val_if_large)    return retclass LayoutLMv2Encoder(nn.Module):    def __init__(self, config):        super().__init__()        self.config = config        self.layer = nn.ModuleList([LayoutLMv2Layer(config) for _ in range(config.num_hidden_layers)])        self.has_relative_attention_bias = config.has_relative_attention_bias        self.has_spatial_attention_bias = config.has_spatial_attention_bias        if self.has_relative_attention_bias:            self.rel_pos_bins = config.rel_pos_bins            self.max_rel_pos = config.max_rel_pos            self.rel_pos_bias = nn.Linear(self.rel_pos_bins, config.num_attention_heads, bias=False)        if self.has_spatial_attention_bias:            self.max_rel_2d_pos = config.max_rel_2d_pos            self.rel_2d_pos_bins = config.rel_2d_pos_bins            self.rel_pos_x_bias = nn.Linear(self.rel_2d_pos_bins, config.num_attention_heads, bias=False)            self.rel_pos_y_bias = nn.Linear(self.rel_2d_pos_bins, config.num_attention_heads, bias=False)        self.gradient_checkpointing = False    def _calculate_1d_position_embeddings(self, position_ids):        rel_pos_mat = position_ids.unsqueeze(-2) - position_ids.unsqueeze(-1)        rel_pos = relative_position_bucket(            rel_pos_mat,            num_buckets=self.rel_pos_bins,            max_distance=self.max_rel_pos,        )        rel_pos = self.rel_pos_bias.weight.t()[rel_pos].permute(0, 3, 1, 2)        rel_pos = rel_pos.contiguous()        return rel_pos    def _calculate_2d_position_embeddings(self, bbox):        position_coord_x = bbox[:, :, 0]        position_coord_y = bbox[:, :, 3]        rel_pos_x_2d_mat = position_coord_x.unsqueeze(-2) - position_coord_x.unsqueeze(-1)        rel_pos_y_2d_mat = position_coord_y.unsqueeze(-2) - position_coord_y.unsqueeze(-1)        rel_pos_x = relative_position_bucket(            rel_pos_x_2d_mat,            num_buckets=self.rel_2d_pos_bins,            max_distance=self.max_rel_2d_pos,        )        rel_pos_y = relative_position_bucket(            rel_pos_y_2d_mat,            num_buckets=self.rel_2d_pos_bins,            max_distance=self.max_rel_2d_pos,        )        rel_pos_x = self.rel_pos_x_bias.weight.t()[rel_pos_x].permute(0, 3, 1, 2)        rel_pos_y = self.rel_pos_y_bias.weight.t()[rel_pos_y].permute(0, 3, 1, 2)        rel_pos_x = rel_pos_x.contiguous()        rel_pos_y = rel_pos_y.contiguous()        rel_2d_pos = rel_pos_x + rel_pos_y        return rel_2d_pos    def forward(        self,        hidden_states,        attention_mask=None,        head_mask=None,        output_attentions=False,        output_hidden_states=False,        return_dict=True,        bbox=None,        position_ids=None,    ):        all_hidden_states = () if output_hidden_states else None        all_self_attentions = () if output_attentions else None        rel_pos = self._calculate_1d_position_embeddings(position_ids) if self.has_relative_attention_bias else None        rel_2d_pos = self._calculate_2d_position_embeddings(bbox) if self.has_spatial_attention_bias else None        for i, layer_module in enumerate(self.layer):            if output_hidden_states:                all_hidden_states = all_hidden_states + (hidden_states,)            layer_head_mask = head_mask[i] if head_mask is not None else None            if self.gradient_checkpointing and self.training:                layer_outputs = self._gradient_checkpointing_func(                    layer_module.__call__,                    hidden_states,                    attention_mask,                    layer_head_mask,                    output_attentions,                    rel_pos=rel_pos,                    rel_2d_pos=rel_2d_pos,                )            else:                layer_outputs = layer_module(                    hidden_states,                    attention_mask,                    layer_head_mask,                    output_attentions,                    rel_pos=rel_pos,                    rel_2d_pos=rel_2d_pos,                )            hidden_states = layer_outputs[0]            if output_attentions:                all_self_attentions = all_self_attentions + (layer_outputs[1],)        if output_hidden_states:            all_hidden_states = all_hidden_states + (hidden_states,)        if not return_dict:            return tuple(                v                for v in [                    hidden_states,                    all_hidden_states,                    all_self_attentions,                ]                if v is not None            )        return BaseModelOutput(            last_hidden_state=hidden_states,            hidden_states=all_hidden_states,            attentions=all_self_attentions,        )class LayoutLMv2PreTrainedModel(PreTrainedModel):    """    An abstract class to handle weights initialization and a simple interface for downloading and loading pretrained    models.    """    config_class = LayoutLMv2Config    pretrained_model_archive_map = LAYOUTLMV2_PRETRAINED_MODEL_ARCHIVE_LIST    base_model_prefix = "layoutlmv2"    def _init_weights(self, module):        """Initialize the weights"""        if isinstance(module, nn.Linear):            # Slightly different from the TF version which uses truncated_normal for initialization            # cf https://github.com/pytorch/pytorch/pull/5617            module.weight.data.normal_(mean=0.0, std=self.config.initializer_range)            if module.bias is not None:                module.bias.data.zero_()        elif isinstance(module, nn.Embedding):            module.weight.data.normal_(mean=0.0, std=self.config.initializer_range)            if module.padding_idx is not None:                module.weight.data[module.padding_idx].zero_()        elif isinstance(module, nn.LayerNorm):            module.bias.data.zero_()            module.weight.data.fill_(1.0)def my_convert_sync_batchnorm(module, process_group=None):    # same as `nn.modules.SyncBatchNorm.convert_sync_batchnorm` but allowing converting from `detectron2.layers.FrozenBatchNorm2d`    if isinstance(module, torch.nn.modules.batchnorm._BatchNorm):        return nn.modules.SyncBatchNorm.convert_sync_batchnorm(module, process_group)    module_output = module    if isinstance(module, detectron2.layers.FrozenBatchNorm2d):        module_output = torch.nn.SyncBatchNorm(            num_features=module.num_features,            eps=module.eps,            affine=True,            track_running_stats=True,            process_group=process_group,        )        module_output.weight = torch.nn.Parameter(module.weight)        module_output.bias = torch.nn.Parameter(module.bias)        module_output.running_mean = module.running_mean        module_output.running_var = module.running_var        module_output.num_batches_tracked = torch.tensor(0, dtype=torch.long, device=module.running_mean.device)    for name, child in module.named_children():        module_output.add_module(name, my_convert_sync_batchnorm(child, process_group))    del module    return module_outputclass LayoutLMv2VisualBackbone(nn.Module):    def __init__(self, config):        super().__init__()        self.cfg = config.get_detectron2_config()        meta_arch = self.cfg.MODEL.META_ARCHITECTURE        model = META_ARCH_REGISTRY.get(meta_arch)(self.cfg)        assert isinstance(model.backbone, detectron2.modeling.backbone.FPN)        self.backbone = model.backbone        assert len(self.cfg.MODEL.PIXEL_MEAN) == len(self.cfg.MODEL.PIXEL_STD)        num_channels = len(self.cfg.MODEL.PIXEL_MEAN)        self.register_buffer(            "pixel_mean",            torch.Tensor(self.cfg.MODEL.PIXEL_MEAN).view(num_channels, 1, 1),            persistent=False,        )        self.register_buffer(            "pixel_std", torch.Tensor(self.cfg.MODEL.PIXEL_STD).view(num_channels, 1, 1), persistent=False        )        self.out_feature_key = "p2"        if torch.are_deterministic_algorithms_enabled():            logger.warning("using `AvgPool2d` instead of `AdaptiveAvgPool2d`")            input_shape = (224, 224)            backbone_stride = self.backbone.output_shape()[self.out_feature_key].stride            self.pool = nn.AvgPool2d(                (                    math.ceil(math.ceil(input_shape[0] / backbone_stride) / config.image_feature_pool_shape[0]),                    math.ceil(math.ceil(input_shape[1] / backbone_stride) / config.image_feature_pool_shape[1]),                )            )        else:            self.pool = nn.AdaptiveAvgPool2d(config.image_feature_pool_shape[:2])        if len(config.image_feature_pool_shape) == 2:            config.image_feature_pool_shape.append(self.backbone.output_shape()[self.out_feature_key].channels)        assert self.backbone.output_shape()[self.out_feature_key].channels == config.image_feature_pool_shape[2]    def forward(self, images):        images_input = ((images if torch.is_tensor(images) else images.tensor) - self.pixel_mean) / self.pixel_std        features = self.backbone(images_input)        features = features[self.out_feature_key]        features = self.pool(features).flatten(start_dim=2).transpose(1, 2).contiguous()        return features    def synchronize_batch_norm(self):        if not (            torch.distributed.is_available()            and torch.distributed.is_initialized()            and torch.distributed.get_rank() > -1        ):            raise RuntimeError("Make sure torch.distributed is set up properly.")        self_rank = torch.distributed.get_rank()        node_size = torch.cuda.device_count()        world_size = torch.distributed.get_world_size()        if not (world_size % node_size == 0):            raise RuntimeError("Make sure the number of processes can be divided by the number of nodes")        node_global_ranks = [list(range(i * node_size, (i + 1) * node_size)) for i in range(world_size // node_size)]        sync_bn_groups = [            torch.distributed.new_group(ranks=node_global_ranks[i]) for i in range(world_size // node_size)        ]        node_rank = self_rank // node_size        self.backbone = my_convert_sync_batchnorm(self.backbone, process_group=sync_bn_groups[node_rank])LAYOUTLMV2_START_DOCSTRING = r"""    This model is a PyTorch [torch.nn.Module](https://pytorch.org/docs/stable/nn.html#torch.nn.Module) sub-class. Use    it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and    behavior.    Parameters:        config ([`LayoutLMv2Config`]): Model configuration class with all the parameters of the model.            Initializing with a config file does not load the weights associated with the model, only the            configuration. Check out the [`~PreTrainedModel.from_pretrained`] method to load the model weights."""LAYOUTLMV2_INPUTS_DOCSTRING = r"""    Args:        input_ids (`torch.LongTensor` of shape `{0}`):            Indices of input sequence tokens in the vocabulary.            Indices can be obtained using [`AutoTokenizer`]. See [`PreTrainedTokenizer.encode`] and            [`PreTrainedTokenizer.__call__`] for details.            [What are input IDs?](../glossary#input-ids)        bbox (`torch.LongTensor` of shape `({0}, 4)`, *optional*):            Bounding boxes of each input sequence tokens. Selected in the range `[0,            config.max_2d_position_embeddings-1]`. Each bounding box should be a normalized version in (x0, y0, x1, y1)            format, where (x0, y0) corresponds to the position of the upper left corner in the bounding box, and (x1,            y1) represents the position of the lower right corner.        image (`torch.FloatTensor` of shape `(batch_size, num_channels, height, width)` or `detectron.structures.ImageList` whose `tensors` is of shape `(batch_size, num_channels, height, width)`):            Batch of document images.        attention_mask (`torch.FloatTensor` of shape `{0}`, *optional*):            Mask to avoid performing attention on padding token indices. Mask values selected in `[0, 1]`:            - 1 for tokens that are **not masked**,            - 0 for tokens that are **masked**.            [What are attention masks?](../glossary#attention-mask)        token_type_ids (`torch.LongTensor` of shape `{0}`, *optional*):            Segment token indices to indicate first and second portions of the inputs. Indices are selected in `[0,            1]`:            - 0 corresponds to a *sentence A* token,            - 1 corresponds to a *sentence B* token.            [What are token type IDs?](../glossary#token-type-ids)        position_ids (`torch.LongTensor` of shape `{0}`, *optional*):            Indices of positions of each input sequence tokens in the position embeddings. Selected in the range `[0,            config.max_position_embeddings - 1]`.            [What are position IDs?](../glossary#position-ids)        head_mask (`torch.FloatTensor` of shape `(num_heads,)` or `(num_layers, num_heads)`, *optional*):            Mask to nullify selected heads of the self-attention modules. Mask values selected in `[0, 1]`:            - 1 indicates the head is **not masked**,            - 0 indicates the head is **masked**.        inputs_embeds (`torch.FloatTensor` of shape `(batch_size, sequence_length, hidden_size)`, *optional*):            Optionally, instead of passing `input_ids` you can choose to directly pass an embedded representation. This            is useful if you want more control over how to convert *input_ids* indices into associated vectors than the            model's internal embedding lookup matrix.        output_attentions (`bool`, *optional*):            Whether or not to return the attentions tensors of all attention layers. See `attentions` under returned            tensors for more detail.        output_hidden_states (`bool`, *optional*):            Whether or not to return the hidden states of all layers. See `hidden_states` under returned tensors for            more detail.        return_dict (`bool`, *optional*):            Whether or not to return a [`~utils.ModelOutput`] instead of a plain tuple."""class LayoutLMv2Pooler(nn.Module):    def __init__(self, config):        super().__init__()        self.dense = nn.Linear(config.hidden_size, config.hidden_size)        self.activation = nn.Tanh()    def forward(self, hidden_states):        # We "pool" the model by simply taking the hidden state corresponding        # to the first token.        first_token_tensor = hidden_states[:, 0]        pooled_output = self.dense(first_token_tensor)        pooled_output = self.activation(pooled_output)        return pooled_output@add_start_docstrings(    "The bare LayoutLMv2 Model transformer outputting raw hidden-states without any specific head on top.",    LAYOUTLMV2_START_DOCSTRING,)class LayoutLMv2Model(LayoutLMv2PreTrainedModel):    def __init__(self, config):        requires_backends(self, "detectron2")        super().__init__(config)        self.config = config        self.has_visual_segment_embedding = config.has_visual_segment_embedding        self.embeddings = LayoutLMv2Embeddings(config)        self.visual = LayoutLMv2VisualBackbone(config)        self.visual_proj = nn.Linear(config.image_feature_pool_shape[-1], config.hidden_size)        if self.has_visual_segment_embedding:            self.visual_segment_embedding = nn.Parameter(nn.Embedding(1, config.hidden_size).weight[0])        self.visual_LayerNorm = nn.LayerNorm(config.hidden_size, eps=config.layer_norm_eps)        self.visual_dropout = nn.Dropout(config.hidden_dropout_prob)        self.encoder = LayoutLMv2Encoder(config)        self.pooler = LayoutLMv2Pooler(config)        # Initialize weights and apply final processing        self.post_init()    def get_input_embeddings(self):        return self.embeddings.word_embeddings    def set_input_embeddings(self, value):        self.embeddings.word_embeddings = value    def _calc_text_embeddings(self, input_ids, bbox, position_ids, token_type_ids, inputs_embeds=None):        if input_ids is not None:            input_shape = input_ids.size()        else:            input_shape = inputs_embeds.size()[:-1]        seq_length = input_shape[1]        if position_ids is None:            position_ids = torch.arange(seq_length, dtype=torch.long, device=input_ids.device)            position_ids = position_ids.unsqueeze(0).expand_as(input_ids)        if token_type_ids is None:            token_type_ids = torch.zeros_like(input_ids)        if inputs_embeds is None:            inputs_embeds = self.embeddings.word_embeddings(input_ids)        position_embeddings = self.embeddings.position_embeddings(position_ids)        spatial_position_embeddings = self.embeddings._calc_spatial_position_embeddings(bbox)        token_type_embeddings = self.embeddings.token_type_embeddings(token_type_ids)        embeddings = inputs_embeds + position_embeddings + spatial_position_embeddings + token_type_embeddings        embeddings = self.embeddings.LayerNorm(embeddings)        embeddings = self.embeddings.dropout(embeddings)        return embeddings    def _calc_img_embeddings(self, image, bbox, position_ids):        visual_embeddings = self.visual_proj(self.visual(image))        position_embeddings = self.embeddings.position_embeddings(position_ids)        spatial_position_embeddings = self.embeddings._calc_spatial_position_embeddings(bbox)        embeddings = visual_embeddings + position_embeddings + spatial_position_embeddings        if self.has_visual_segment_embedding:            embeddings += self.visual_segment_embedding        embeddings = self.visual_LayerNorm(embeddings)        embeddings = self.visual_dropout(embeddings)        return embeddings    def _calc_visual_bbox(self, image_feature_pool_shape, bbox, device, final_shape):        visual_bbox_x = torch.div(            torch.arange(                0,                1000 * (image_feature_pool_shape[1] + 1),                1000,                device=device,                dtype=bbox.dtype,            ),            self.config.image_feature_pool_shape[1],            rounding_mode="floor",        )        visual_bbox_y = torch.div(            torch.arange(                0,                1000 * (self.config.image_feature_pool_shape[0] + 1),                1000,                device=device,                dtype=bbox.dtype,            ),            self.config.image_feature_pool_shape[0],            rounding_mode="floor",        )        visual_bbox = torch.stack(            [                visual_bbox_x[:-1].repeat(image_feature_pool_shape[0], 1),                visual_bbox_y[:-1].repeat(image_feature_pool_shape[1], 1).transpose(0, 1),                visual_bbox_x[1:].repeat(image_feature_pool_shape[0], 1),                visual_bbox_y[1:].repeat(image_feature_pool_shape[1], 1).transpose(0, 1),            ],            dim=-1,        ).view(-1, bbox.size(-1))        visual_bbox = visual_bbox.repeat(final_shape[0], 1, 1)        return visual_bbox    def _get_input_shape(self, input_ids=None, inputs_embeds=None):        if input_ids is not None and inputs_embeds is not None:            raise ValueError("You cannot specify both input_ids and inputs_embeds at the same time")        elif input_ids is not None:            return input_ids.size()        elif inputs_embeds is not None:            return inputs_embeds.size()[:-1]        else:            raise ValueError("You have to specify either input_ids or inputs_embeds")    @add_start_docstrings_to_model_forward(LAYOUTLMV2_INPUTS_DOCSTRING.format("(batch_size, sequence_length)"))    @replace_return_docstrings(output_type=BaseModelOutput, config_class=_CONFIG_FOR_DOC)    def forward(        self,        input_ids: Optional[torch.LongTensor] = None,        bbox: Optional[torch.LongTensor] = None,        image: Optional[torch.FloatTensor] = None,        attention_mask: Optional[torch.FloatTensor] = None,        token_type_ids: Optional[torch.LongTensor] = None,        position_ids: Optional[torch.LongTensor] = None,        head_mask: Optional[torch.FloatTensor] = None,        inputs_embeds: Optional[torch.FloatTensor] = None,        output_attentions: Optional[bool] = None,        output_hidden_states: Optional[bool] = None,        return_dict: Optional[bool] = None,    ) -> Union[Tuple, BaseModelOutputWithPooling]:        r"""        Return:        Examples:        ```python        >>> from transformers import AutoProcessor, LayoutLMv2Model, set_seed        >>> from PIL import Image        >>> import torch        >>> from datasets import load_dataset        >>> set_seed(88)        >>> processor = AutoProcessor.from_pretrained("microsoft/layoutlmv2-base-uncased")        >>> model = LayoutLMv2Model.from_pretrained("microsoft/layoutlmv2-base-uncased")        >>> dataset = load_dataset("hf-internal-testing/fixtures_docvqa")        >>> image_path = dataset["test"][0]["file"]        >>> image = Image.open(image_path).convert("RGB")        >>> encoding = processor(image, return_tensors="pt")        >>> outputs = model(**encoding)        >>> last_hidden_states = outputs.last_hidden_state        >>> last_hidden_states.shape        torch.Size([1, 342, 768])        ```        """        output_attentions = output_attentions if output_attentions is not None else self.config.output_attentions        output_hidden_states = (            output_hidden_states if output_hidden_states is not None else self.config.output_hidden_states        )        return_dict = return_dict if return_dict is not None else self.config.use_return_dict        input_shape = self._get_input_shape(input_ids, inputs_embeds)        device = input_ids.device if input_ids is not None else inputs_embeds.device        visual_shape = list(input_shape)        visual_shape[1] = self.config.image_feature_pool_shape[0] * self.config.image_feature_pool_shape[1]        visual_shape = torch.Size(visual_shape)        # needs a new copy of input_shape for tracing. Otherwise wrong dimensions will occur        final_shape = list(self._get_input_shape(input_ids, inputs_embeds))        final_shape[1] += visual_shape[1]        final_shape = torch.Size(final_shape)        visual_bbox = self._calc_visual_bbox(self.config.image_feature_pool_shape, bbox, device, final_shape)        final_bbox = torch.cat([bbox, visual_bbox], dim=1)        if attention_mask is None:            attention_mask = torch.ones(input_shape, device=device)        visual_attention_mask = torch.ones(visual_shape, device=device)        final_attention_mask = torch.cat([attention_mask, visual_attention_mask], dim=1)        if token_type_ids is None:            token_type_ids = torch.zeros(input_shape, dtype=torch.long, device=device)        if position_ids is None:            seq_length = input_shape[1]            position_ids = self.embeddings.position_ids[:, :seq_length]            position_ids = position_ids.expand(input_shape)        visual_position_ids = torch.arange(0, visual_shape[1], dtype=torch.long, device=device).repeat(            input_shape[0], 1        )        final_position_ids = torch.cat([position_ids, visual_position_ids], dim=1)        if bbox is None:            bbox = torch.zeros(tuple(list(input_shape) + [4]), dtype=torch.long, device=device)        text_layout_emb = self._calc_text_embeddings(            input_ids=input_ids,            bbox=bbox,            token_type_ids=token_type_ids,            position_ids=position_ids,            inputs_embeds=inputs_embeds,        )        visual_emb = self._calc_img_embeddings(            image=image,            bbox=visual_bbox,            position_ids=visual_position_ids,        )        final_emb = torch.cat([text_layout_emb, visual_emb], dim=1)        extended_attention_mask = final_attention_mask.unsqueeze(1).unsqueeze(2)        extended_attention_mask = extended_attention_mask.to(dtype=self.dtype)        extended_attention_mask = (1.0 - extended_attention_mask) * torch.finfo(self.dtype).min        if head_mask is not None:            if head_mask.dim() == 1:                head_mask = head_mask.unsqueeze(0).unsqueeze(0).unsqueeze(-1).unsqueeze(-1)                head_mask = head_mask.expand(self.config.num_hidden_layers, -1, -1, -1, -1)            elif head_mask.dim() == 2:                head_mask = head_mask.unsqueeze(1).unsqueeze(-1).unsqueeze(-1)            head_mask = head_mask.to(dtype=next(self.parameters()).dtype)        else:            head_mask = [None] * self.config.num_hidden_layers        encoder_outputs = self.encoder(            final_emb,            extended_attention_mask,            bbox=final_bbox,            position_ids=final_position_ids,            head_mask=head_mask,            output_attentions=output_attentions,            output_hidden_states=output_hidden_states,            return_dict=return_dict,        )        sequence_output = encoder_outputs[0]        pooled_output = self.pooler(sequence_output)        if not return_dict:            return (sequence_output, pooled_output) + encoder_outputs[1:]        return BaseModelOutputWithPooling(            last_hidden_state=sequence_output,            pooler_output=pooled_output,            hidden_states=encoder_outputs.hidden_states,            attentions=encoder_outputs.attentions,        )@add_start_docstrings(    """    LayoutLMv2 Model with a sequence classification head on top (a linear layer on top of the concatenation of the    final hidden state of the [CLS] token, average-pooled initial visual embeddings and average-pooled final visual    embeddings, e.g. for document image classification tasks such as the    [RVL-CDIP](https://www.cs.cmu.edu/~aharley/rvl-cdip/) dataset.    """,    LAYOUTLMV2_START_DOCSTRING,)class LayoutLMv2ForSequenceClassification(LayoutLMv2PreTrainedModel):    def __init__(self, config):        super().__init__(config)        self.num_labels = config.num_labels        self.layoutlmv2 = LayoutLMv2Model(config)        self.dropout = nn.Dropout(config.hidden_dropout_prob)        self.classifier = nn.Linear(config.hidden_size * 3, config.num_labels)        # Initialize weights and apply final processing        self.post_init()    def get_input_embeddings(self):        return self.layoutlmv2.embeddings.word_embeddings    @add_start_docstrings_to_model_forward(LAYOUTLMV2_INPUTS_DOCSTRING.format("batch_size, sequence_length"))    @replace_return_docstrings(output_type=SequenceClassifierOutput, config_class=_CONFIG_FOR_DOC)    def forward(        self,        input_ids: Optional[torch.LongTensor] = None,        bbox: Optional[torch.LongTensor] = None,        image: Optional[torch.FloatTensor] = None,        attention_mask: Optional[torch.FloatTensor] = None,        token_type_ids: Optional[torch.LongTensor] = None,        position_ids: Optional[torch.LongTensor] = None,        head_mask: Optional[torch.FloatTensor] = None,        inputs_embeds: Optional[torch.FloatTensor] = None,        labels: Optional[torch.LongTensor] = None,        output_attentions: Optional[bool] = None,        output_hidden_states: Optional[bool] = None,        return_dict: Optional[bool] = None,    ) -> Union[Tuple, SequenceClassifierOutput]:        r"""        labels (`torch.LongTensor` of shape `(batch_size,)`, *optional*):            Labels for computing the sequence classification/regression loss. Indices should be in `[0, ...,            config.num_labels - 1]`. If `config.num_labels == 1` a regression loss is computed (Mean-Square loss), If            `config.num_labels > 1` a classification loss is computed (Cross-Entropy).        Returns:        Example:        ```python        >>> from transformers import AutoProcessor, LayoutLMv2ForSequenceClassification, set_seed        >>> from PIL import Image        >>> import torch        >>> from datasets import load_dataset        >>> set_seed(88)        >>> dataset = load_dataset("rvl_cdip", split="train", streaming=True)        >>> data = next(iter(dataset))        >>> image = data["image"].convert("RGB")        >>> processor = AutoProcessor.from_pretrained("microsoft/layoutlmv2-base-uncased")        >>> model = LayoutLMv2ForSequenceClassification.from_pretrained(        ...     "microsoft/layoutlmv2-base-uncased", num_labels=dataset.info.features["label"].num_classes        ... )        >>> encoding = processor(image, return_tensors="pt")        >>> sequence_label = torch.tensor([data["label"]])        >>> outputs = model(**encoding, labels=sequence_label)        >>> loss, logits = outputs.loss, outputs.logits        >>> predicted_idx = logits.argmax(dim=-1).item()        >>> predicted_answer = dataset.info.features["label"].names[4]        >>> predicted_idx, predicted_answer        (4, 'advertisement')        ```        """        return_dict = return_dict if return_dict is not None else self.config.use_return_dict        if input_ids is not None and inputs_embeds is not None:            raise ValueError("You cannot specify both input_ids and inputs_embeds at the same time")        elif input_ids is not None:            self.warn_if_padding_and_no_attention_mask(input_ids, attention_mask)            input_shape = input_ids.size()        elif inputs_embeds is not None:            input_shape = inputs_embeds.size()[:-1]        else:            raise ValueError("You have to specify either input_ids or inputs_embeds")        device = input_ids.device if input_ids is not None else inputs_embeds.device        visual_shape = list(input_shape)        visual_shape[1] = self.config.image_feature_pool_shape[0] * self.config.image_feature_pool_shape[1]        visual_shape = torch.Size(visual_shape)        final_shape = list(input_shape)        final_shape[1] += visual_shape[1]        final_shape = torch.Size(final_shape)        visual_bbox = self.layoutlmv2._calc_visual_bbox(            self.config.image_feature_pool_shape, bbox, device, final_shape        )        visual_position_ids = torch.arange(0, visual_shape[1], dtype=torch.long, device=device).repeat(            input_shape[0], 1        )        initial_image_embeddings = self.layoutlmv2._calc_img_embeddings(            image=image,            bbox=visual_bbox,            position_ids=visual_position_ids,        )        outputs = self.layoutlmv2(            input_ids=input_ids,            bbox=bbox,            image=image,            attention_mask=attention_mask,            token_type_ids=token_type_ids,            position_ids=position_ids,            head_mask=head_mask,            inputs_embeds=inputs_embeds,            output_attentions=output_attentions,            output_hidden_states=output_hidden_states,            return_dict=return_dict,        )        if input_ids is not None:            input_shape = input_ids.size()        else:            input_shape = inputs_embeds.size()[:-1]        seq_length = input_shape[1]        sequence_output, final_image_embeddings = outputs[0][:, :seq_length], outputs[0][:, seq_length:]        cls_final_output = sequence_output[:, 0, :]        # average-pool the visual embeddings        pooled_initial_image_embeddings = initial_image_embeddings.mean(dim=1)        pooled_final_image_embeddings = final_image_embeddings.mean(dim=1)        # concatenate with cls_final_output        sequence_output = torch.cat(            [cls_final_output, pooled_initial_image_embeddings, pooled_final_image_embeddings], dim=1        )        sequence_output = self.dropout(sequence_output)        logits = self.classifier(sequence_output)        loss = None        if labels is not None:            if self.config.problem_type is None:                if self.num_labels == 1:                    self.config.problem_type = "regression"                elif self.num_labels > 1 and (labels.dtype == torch.long or labels.dtype == torch.int):                    self.config.problem_type = "single_label_classification"                else:                    self.config.problem_type = "multi_label_classification"            if self.config.problem_type == "regression":                loss_fct = MSELoss()                if self.num_labels == 1:                    loss = loss_fct(logits.squeeze(), labels.squeeze())                else:                    loss = loss_fct(logits, labels)            elif self.config.problem_type == "single_label_classification":                loss_fct = CrossEntropyLoss()                loss = loss_fct(logits.view(-1, self.num_labels), labels.view(-1))            elif self.config.problem_type == "multi_label_classification":                loss_fct = BCEWithLogitsLoss()                loss = loss_fct(logits, labels)        if not return_dict:            output = (logits,) + outputs[2:]            return ((loss,) + output) if loss is not None else output        return SequenceClassifierOutput(            loss=loss,            logits=logits,            hidden_states=outputs.hidden_states,            attentions=outputs.attentions,        )@add_start_docstrings(    """    LayoutLMv2 Model with a token classification head on top (a linear layer on top of the text part of the hidden    states) e.g. for sequence labeling (information extraction) tasks such as    [FUNSD](https://guillaumejaume.github.io/FUNSD/), [SROIE](https://rrc.cvc.uab.es/?ch=13),    [CORD](https://github.com/clovaai/cord) and [Kleister-NDA](https://github.com/applicaai/kleister-nda).    """,    LAYOUTLMV2_START_DOCSTRING,)class LayoutLMv2ForTokenClassification(LayoutLMv2PreTrainedModel):    def __init__(self, config):        super().__init__(config)        self.num_labels = config.num_labels        self.layoutlmv2 = LayoutLMv2Model(config)        self.dropout = nn.Dropout(config.hidden_dropout_prob)        self.classifier = nn.Linear(config.hidden_size, config.num_labels)        # Initialize weights and apply final processing        self.post_init()    def get_input_embeddings(self):        return self.layoutlmv2.embeddings.word_embeddings    @add_start_docstrings_to_model_forward(LAYOUTLMV2_INPUTS_DOCSTRING.format("batch_size, sequence_length"))    @replace_return_docstrings(output_type=TokenClassifierOutput, config_class=_CONFIG_FOR_DOC)    def forward(        self,        input_ids: Optional[torch.LongTensor] = None,        bbox: Optional[torch.LongTensor] = None,        image: Optional[torch.FloatTensor] = None,        attention_mask: Optional[torch.FloatTensor] = None,        token_type_ids: Optional[torch.LongTensor] = None,        position_ids: Optional[torch.LongTensor] = None,        head_mask: Optional[torch.FloatTensor] = None,        inputs_embeds: Optional[torch.FloatTensor] = None,        labels: Optional[torch.LongTensor] = None,        output_attentions: Optional[bool] = None,        output_hidden_states: Optional[bool] = None,        return_dict: Optional[bool] = None,    ) -> Union[Tuple, TokenClassifierOutput]:        r"""        labels (`torch.LongTensor` of shape `(batch_size, sequence_length)`, *optional*):            Labels for computing the token classification loss. Indices should be in `[0, ..., config.num_labels - 1]`.        Returns:        Example:        ```python        >>> from transformers import AutoProcessor, LayoutLMv2ForTokenClassification, set_seed        >>> from PIL import Image        >>> from datasets import load_dataset        >>> set_seed(88)        >>> datasets = load_dataset("nielsr/funsd", split="test")        >>> labels = datasets.features["ner_tags"].feature.names        >>> id2label = {v: k for v, k in enumerate(labels)}        >>> processor = AutoProcessor.from_pretrained("microsoft/layoutlmv2-base-uncased", revision="no_ocr")        >>> model = LayoutLMv2ForTokenClassification.from_pretrained(        ...     "microsoft/layoutlmv2-base-uncased", num_labels=len(labels)        ... )        >>> data = datasets[0]        >>> image = Image.open(data["image_path"]).convert("RGB")        >>> words = data["words"]        >>> boxes = data["bboxes"]  # make sure to normalize your bounding boxes        >>> word_labels = data["ner_tags"]        >>> encoding = processor(        ...     image,        ...     words,        ...     boxes=boxes,        ...     word_labels=word_labels,        ...     padding="max_length",        ...     truncation=True,        ...     return_tensors="pt",        ... )        >>> outputs = model(**encoding)        >>> logits, loss = outputs.logits, outputs.loss        >>> predicted_token_class_ids = logits.argmax(-1)        >>> predicted_tokens_classes = [id2label[t.item()] for t in predicted_token_class_ids[0]]        >>> predicted_tokens_classes[:5]        ['B-ANSWER', 'B-HEADER', 'B-HEADER', 'B-HEADER', 'B-HEADER']        ```        """        return_dict = return_dict if return_dict is not None else self.config.use_return_dict        outputs = self.layoutlmv2(            input_ids=input_ids,            bbox=bbox,            image=image,            attention_mask=attention_mask,            token_type_ids=token_type_ids,            position_ids=position_ids,            head_mask=head_mask,            inputs_embeds=inputs_embeds,            output_attentions=output_attentions,            output_hidden_states=output_hidden_states,            return_dict=return_dict,        )        if input_ids is not None:            input_shape = input_ids.size()        else:            input_shape = inputs_embeds.size()[:-1]        seq_length = input_shape[1]        # only take the text part of the output representations        sequence_output = outputs[0][:, :seq_length]        sequence_output = self.dropout(sequence_output)        logits = self.classifier(sequence_output)        loss = None        if labels is not None:            loss_fct = CrossEntropyLoss()            loss = loss_fct(logits.view(-1, self.num_labels), labels.view(-1))        if not return_dict:            output = (logits,) + outputs[2:]            return ((loss,) + output) if loss is not None else output        return TokenClassifierOutput(            loss=loss,            logits=logits,            hidden_states=outputs.hidden_states,            attentions=outputs.attentions,        )@add_start_docstrings(    """    LayoutLMv2 Model with a span classification head on top for extractive question-answering tasks such as    [DocVQA](https://rrc.cvc.uab.es/?ch=17) (a linear layer on top of the text part of the hidden-states output to    compute `span start logits` and `span end logits`).    """,    LAYOUTLMV2_START_DOCSTRING,)class LayoutLMv2ForQuestionAnswering(LayoutLMv2PreTrainedModel):    def __init__(self, config, has_visual_segment_embedding=True):        super().__init__(config)        self.num_labels = config.num_labels        config.has_visual_segment_embedding = has_visual_segment_embedding        self.layoutlmv2 = LayoutLMv2Model(config)        self.qa_outputs = nn.Linear(config.hidden_size, config.num_labels)        # Initialize weights and apply final processing        self.post_init()    def get_input_embeddings(self):        return self.layoutlmv2.embeddings.word_embeddings    @add_start_docstrings_to_model_forward(LAYOUTLMV2_INPUTS_DOCSTRING.format("batch_size, sequence_length"))    @replace_return_docstrings(output_type=QuestionAnsweringModelOutput, config_class=_CONFIG_FOR_DOC)    def forward(        self,        input_ids: Optional[torch.LongTensor] = None,        bbox: Optional[torch.LongTensor] = None,        image: Optional[torch.FloatTensor] = None,        attention_mask: Optional[torch.FloatTensor] = None,        token_type_ids: Optional[torch.LongTensor] = None,        position_ids: Optional[torch.LongTensor] = None,        head_mask: Optional[torch.FloatTensor] = None,        inputs_embeds: Optional[torch.FloatTensor] = None,        start_positions: Optional[torch.LongTensor] = None,        end_positions: Optional[torch.LongTensor] = None,        output_attentions: Optional[bool] = None,        output_hidden_states: Optional[bool] = None,        return_dict: Optional[bool] = None,    ) -> Union[Tuple, QuestionAnsweringModelOutput]:        r"""        start_positions (`torch.LongTensor` of shape `(batch_size,)`, *optional*):            Labels for position (index) of the start of the labelled span for computing the token classification loss.            Positions are clamped to the length of the sequence (`sequence_length`). Position outside of the sequence            are not taken into account for computing the loss.        end_positions (`torch.LongTensor` of shape `(batch_size,)`, *optional*):            Labels for position (index) of the end of the labelled span for computing the token classification loss.            Positions are clamped to the length of the sequence (`sequence_length`). Position outside of the sequence            are not taken into account for computing the loss.        Returns:        Example:        In this example below, we give the LayoutLMv2 model an image (of texts) and ask it a question. It will give us        a prediction of what it thinks the answer is (the span of the answer within the texts parsed from the image).        ```python        >>> from transformers import AutoProcessor, LayoutLMv2ForQuestionAnswering, set_seed        >>> import torch        >>> from PIL import Image        >>> from datasets import load_dataset        >>> set_seed(88)        >>> processor = AutoProcessor.from_pretrained("microsoft/layoutlmv2-base-uncased")        >>> model = LayoutLMv2ForQuestionAnswering.from_pretrained("microsoft/layoutlmv2-base-uncased")        >>> dataset = load_dataset("hf-internal-testing/fixtures_docvqa")        >>> image_path = dataset["test"][0]["file"]        >>> image = Image.open(image_path).convert("RGB")        >>> question = "When is coffee break?"        >>> encoding = processor(image, question, return_tensors="pt")        >>> outputs = model(**encoding)        >>> predicted_start_idx = outputs.start_logits.argmax(-1).item()        >>> predicted_end_idx = outputs.end_logits.argmax(-1).item()        >>> predicted_start_idx, predicted_end_idx        (154, 287)        >>> predicted_answer_tokens = encoding.input_ids.squeeze()[predicted_start_idx : predicted_end_idx + 1]        >>> predicted_answer = processor.tokenizer.decode(predicted_answer_tokens)        >>> predicted_answer  # results are not very good without further fine-tuning        'council mem - bers conducted by trrf treasurer philip g. kuehn to get answers which the public ...        ```        ```python        >>> target_start_index = torch.tensor([7])        >>> target_end_index = torch.tensor([14])        >>> outputs = model(**encoding, start_positions=target_start_index, end_positions=target_end_index)        >>> predicted_answer_span_start = outputs.start_logits.argmax(-1).item()        >>> predicted_answer_span_end = outputs.end_logits.argmax(-1).item()        >>> predicted_answer_span_start, predicted_answer_span_end        (154, 287)        ```        """        return_dict = return_dict if return_dict is not None else self.config.use_return_dict        outputs = self.layoutlmv2(            input_ids=input_ids,            bbox=bbox,            image=image,            attention_mask=attention_mask,            token_type_ids=token_type_ids,            position_ids=position_ids,            head_mask=head_mask,            inputs_embeds=inputs_embeds,            output_attentions=output_attentions,            output_hidden_states=output_hidden_states,            return_dict=return_dict,        )        if input_ids is not None:            input_shape = input_ids.size()        else:            input_shape = inputs_embeds.size()[:-1]        seq_length = input_shape[1]        # only take the text part of the output representations        sequence_output = outputs[0][:, :seq_length]        logits = self.qa_outputs(sequence_output)        start_logits, end_logits = logits.split(1, dim=-1)        start_logits = start_logits.squeeze(-1).contiguous()        end_logits = end_logits.squeeze(-1).contiguous()        total_loss = None        if start_positions is not None and end_positions is not None:            # If we are on multi-GPU, split add a dimension            if len(start_positions.size()) > 1:                start_positions = start_positions.squeeze(-1)            if len(end_positions.size()) > 1:                end_positions = end_positions.squeeze(-1)            # sometimes the start/end positions are outside our model inputs, we ignore these terms            ignored_index = start_logits.size(1)            start_positions = start_positions.clamp(0, ignored_index)            end_positions = end_positions.clamp(0, ignored_index)            loss_fct = CrossEntropyLoss(ignore_index=ignored_index)            start_loss = loss_fct(start_logits, start_positions)            end_loss = loss_fct(end_logits, end_positions)            total_loss = (start_loss + end_loss) / 2        if not return_dict:            output = (start_logits, end_logits) + outputs[2:]            return ((total_loss,) + output) if total_loss is not None else output        return QuestionAnsweringModelOutput(            loss=total_loss,            start_logits=start_logits,            end_logits=end_logits,            hidden_states=outputs.hidden_states,            attentions=outputs.attentions,        )