"""Tokenization classes for GPTNeoX."""import jsonfrom typing import Optional, Tuplefrom tokenizers import pre_tokenizersfrom ...tokenization_utils_fast import PreTrainedTokenizerFastfrom ...utils import logginglogger = logging.get_logger(__name__)VOCAB_FILES_NAMES = {"vocab_file": "vocab.json", "merges_file": "merges.txt", "tokenizer_file": "tokenizer.json"}PRETRAINED_VOCAB_FILES_MAP = {    "tokenizer_file": {        "EleutherAI/gpt-neox-20b": "https://huggingface.co/EleutherAI/gpt-neox-20b/resolve/main/tokenizer.json",    },}PRETRAINED_POSITIONAL_EMBEDDINGS_SIZES = {    "gpt-neox-20b": 2048,}class GPTNeoXTokenizerFast(PreTrainedTokenizerFast):    """    Construct a "fast" GPT-NeoX-20B tokenizer (backed by HuggingFace's *tokenizers* library). Based on byte-level    Byte-Pair-Encoding.    This tokenizer has been trained to treat spaces like parts of the tokens (a bit like sentencepiece) so a word will    be encoded differently whether it is at the beginning of the sentence (without space) or not:    ```python    >>> from transformers import GPTNeoXTokenizerFast    >>> tokenizer = GPTNeoXTokenizerFast.from_pretrained("gpt2")    >>> tokenizer("Hello world")["input_ids"]    [15496, 995]    >>> tokenizer(" Hello world")["input_ids"]    [18435, 995]    ```    You can get around that behavior by passing `add_prefix_space=True` when instantiating this tokenizer, but since    the model was not pretrained this way, it might yield a decrease in performance.    <Tip>    When used with `is_split_into_words=True`, this tokenizer needs to be instantiated with `add_prefix_space=True`.    </Tip>    This tokenizer inherits from [`PreTrainedTokenizerFast`] which contains most of the main methods. Users should    refer to this superclass for more information regarding those methods.    Args:        vocab_file (`str`):            Path to the vocabulary file.        merges_file (`str`):            Path to the merges file.        errors (`str`, *optional*, defaults to `"replace"`):            Paradigm to follow when decoding bytes to UTF-8. See            [bytes.decode](https://docs.python.org/3/library/stdtypes.html#bytes.decode) for more information.        unk_token (`str`, *optional*, defaults to `<|endoftext|>`):            The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this            token instead.        bos_token (`str`, *optional*, defaults to `<|endoftext|>`):            The beginning of sequence token.        eos_token (`str`, *optional*, defaults to `<|endoftext|>`):            The end of sequence token.        add_prefix_space (`bool`, *optional*, defaults to `False`):            Whether or not to add an initial space to the input. This allows to treat the leading word just as any            other word. (GPTNeoX tokenizer detect beginning of words by the preceding space).        trim_offsets (`bool`, *optional*, defaults to `True`):            Whether or not the post-processing step should trim offsets to avoid including whitespaces.    """    vocab_files_names = VOCAB_FILES_NAMES    pretrained_vocab_files_map = PRETRAINED_VOCAB_FILES_MAP    max_model_input_sizes = PRETRAINED_POSITIONAL_EMBEDDINGS_SIZES    model_input_names = ["input_ids", "attention_mask"]    def __init__(        self,        vocab_file=None,        merges_file=None,        tokenizer_file=None,        unk_token="<|endoftext|>",        bos_token="<|endoftext|>",        eos_token="<|endoftext|>",        add_prefix_space=False,        **kwargs,    ):        super().__init__(            vocab_file,            merges_file,            tokenizer_file=tokenizer_file,            unk_token=unk_token,            bos_token=bos_token,            eos_token=eos_token,            add_prefix_space=add_prefix_space,            **kwargs,        )        pre_tok_state = json.loads(self.backend_tokenizer.pre_tokenizer.__getstate__())        if pre_tok_state.get("add_prefix_space", add_prefix_space) != add_prefix_space:            pre_tok_class = getattr(pre_tokenizers, pre_tok_state.pop("type"))            pre_tok_state["add_prefix_space"] = add_prefix_space            self.backend_tokenizer.pre_tokenizer = pre_tok_class(**pre_tok_state)        self.add_prefix_space = add_prefix_space    def save_vocabulary(self, save_directory: str, filename_prefix: Optional[str] = None) -> Tuple[str]:        files = self._tokenizer.model.save(save_directory, name=filename_prefix)        return tuple(files)    @property    # Copied from transformers.models.gpt2.tokenization_gpt2.GPT2Tokenizer.default_chat_template    def default_chat_template(self):        """        A simple chat template that ignores role information and just concatenates messages with EOS tokens.        """        logger.warning_once(            "\nNo chat template is defined for this tokenizer - using the default template "            f"for the {self.__class__.__name__} class. If the default is not appropriate for "            "your model, please set `tokenizer.chat_template` to an appropriate template. "            "See https://huggingface.co/docs/transformers/main/chat_templating for more information.\n"        )        return "{% for message in messages %}" "{{ message.content }}{{ eos_token }}" "{% endfor %}"