# tests directory-specific settings - this file is run automatically# by pytest before any tests are runimport doctestimport sysimport warningsfrom os.path import abspath, dirname, joinimport _pytestfrom transformers.testing_utils import HfDoctestModule, HfDocTestParser# allow having multiple repository checkouts and not needing to remember to rerun# 'pip install -e .[dev]' when switching between checkouts and running tests.git_repo_path = abspath(join(dirname(__file__), "src"))sys.path.insert(1, git_repo_path)# silence FutureWarning warnings in tests since often we can't act on them until# they become normal warnings - i.e. the tests still need to test the current functionalitywarnings.simplefilter(action="ignore", category=FutureWarning)def pytest_configure(config):    config.addinivalue_line(        "markers", "is_pt_tf_cross_test: mark test to run only when PT and TF interactions are tested"    )    config.addinivalue_line(        "markers", "is_pt_flax_cross_test: mark test to run only when PT and FLAX interactions are tested"    )    config.addinivalue_line("markers", "is_pipeline_test: mark test to run only when pipelines are tested")    config.addinivalue_line("markers", "is_staging_test: mark test to run only in the staging environment")    config.addinivalue_line("markers", "accelerate_tests: mark test that require accelerate")    config.addinivalue_line("markers", "tool_tests: mark the tool tests that are run on their specific schedule")def pytest_addoption(parser):    from transformers.testing_utils import pytest_addoption_shared    pytest_addoption_shared(parser)def pytest_terminal_summary(terminalreporter):    from transformers.testing_utils import pytest_terminal_summary_main    make_reports = terminalreporter.config.getoption("--make-reports")    if make_reports:        pytest_terminal_summary_main(terminalreporter, id=make_reports)def pytest_sessionfinish(session, exitstatus):    # If no tests are collected, pytest exists with code 5, which makes the CI fail.    if exitstatus == 5:        session.exitstatus = 0# Doctest custom flag to ignore output.IGNORE_RESULT = doctest.register_optionflag("IGNORE_RESULT")OutputChecker = doctest.OutputCheckerclass CustomOutputChecker(OutputChecker):    def check_output(self, want, got, optionflags):        if IGNORE_RESULT & optionflags:            return True        return OutputChecker.check_output(self, want, got, optionflags)doctest.OutputChecker = CustomOutputChecker_pytest.doctest.DoctestModule = HfDoctestModuledoctest.DocTestParser = HfDocTestParser