from collections import namedtupleimport littletable as lt# load catalog of productscatalog = lt.Table("ACME catalog")catalog.create_index("sku", unique=True)catalog_data = """\sku,descr,unitofmeas,unitpriceBRDSD-001,Bird seed,LB,3BBS-001,Steel BB's,LB,5MGNT-001,Magnet,EA,8MAGLS-001,Magnifying glass,EA,12ANVIL-001,1000lb anvil,EA,100ROPE-001,1 in. heavy rope,100FT,10ROBOT-001,Domestic robot,EA,5000"""catalog.csv_import(catalog_data, transforms={"unitprice": int})catalog.present()print(catalog.by.sku["ANVIL-001"].descr)catalog.create_index("unitofmeas")catalog.by.unitofmeas["EA"].present()# load table of customersCustomer = namedtuple("Customer", "id name")customers = lt.Table("customers")customers.create_index("id", unique=True)customer_data = """\id,name0010,George Jetson0020,Wile E. Coyote0030,Jonny Quest"""customers.csv_import(customer_data, row_class=Customer)customers.present()# load wishlist items for each customerwishitems = lt.Table("wishitems")wishitems.create_index("custid")wishitems.create_index("sku")# there is no user-defined type for these items, the default is SimpleNamespacewishlist_data = """\custid,sku0030,MAGLS-0010020,MAGLS-0010020,ANVIL-0010020,ROPE-0010020,BRDSD-0010020,BBS-0010020,MAGNT-0010030,MAGNT-0010030,ROBOT-0010010,ROBOT-001"""wishitems.csv_import(wishlist_data)# print a particular customer nameprint(customers.by.id["0030"].name)print()# print all items sold by the poundfor item in catalog.where(unitofmeas="LB"):    print(item.sku, item.descr)print()# if querying on an indexed item, use ".by.attribute-name[key]"catalog.create_index("unitofmeas")for item in catalog.by.unitofmeas["LB"]:    print(item.sku, item.descr)print()# print all items that cost more than 10for item in catalog.where(lambda ob: ob.unitprice > 10):    print(item.sku, item.descr, item.unitprice)print()# join tables to create queryable wishlists collection - the following are all equivalentwishlists = (customers.join_on("id") + wishitems.join_on("custid")).join_on("sku") + catalog.join_on("sku")wishlists = (customers.join_on("id") + wishitems.join_on("custid")).join_on("sku") + catalogwishlists = catalog + (customers.join_on("id") + wishitems.join_on("custid")).join_on("sku")wishlists = catalog.join_on("sku") + (customers.join_on("id") + wishitems.join_on("custid"))wishlists = customers.join_on("id") + wishitems.join_on("custid") + catalog.join_on("sku")print(wishlists().table_name)print(wishlists()("wishlists").table_name)# print all wishlist items with price > 10 (use Table.gt instead of lambda)# bigticketitems = wishlists().where(lambda ob : ob.unitprice > 10)bigticketitems = wishlists().where(unitprice=lt.Table.gt(10))for bti in bigticketitems:    print(bti)print()# list all wishlist items by customer, then in descending order by unit pricefor item in wishlists().sort("custid, unitprice desc"):    print(item)print()# display formatted tabular outputwishlists().sort("custid, unitprice desc")("Wishlists").select(    "custid name sku descr").present(groupby="custid name")# create simple pivot table, grouping wishlist data by customer namewishlistsdata = wishlists()wishlistsdata.create_index("name")pivot = wishlistsdata.pivot("name")pivot.dump(row_fn=lambda o: "%s %s" % (o.sku, o.descr))print()# pivot on both sku number and customer name, giving tabular outputpiv2 = wishlistsdata.pivot("sku name")piv2.dump_counts()print()# pivot on both sku number and customer name, giving tabular output# tabulate by sum(unitprice) for all items in each pivot table cellpiv2.dump_counts(count_fn=lambda recs: sum(r.unitprice for r in recs))print()