from __future__ import absolute_importfrom __future__ import divisionfrom __future__ import print_functionimport osimport loggingimport timefrom collections import namedtuplefrom pathlib import Pathfrom ptflops import get_model_complexity_infoimport torchimport torch.optim as optimimport torch.nn as nndef setup_logger(final_output_dir, rank, phase):    time_str = time.strftime('%Y-%m-%d-%H-%M')    log_file = '{}_{}_rank{}.log'.format(phase, time_str, rank)    final_log_file = os.path.join(final_output_dir, log_file)    head = '%(asctime)-15s %(message)s'    # logging.basicConfig(format=head)    logging.basicConfig(filename=str(final_log_file),                        format=head)    logger = logging.getLogger()    logger.setLevel(logging.INFO)    console = logging.StreamHandler()    logging.getLogger('').addHandler(console)    return logger, time_strdef create_logger(cfg, cfg_name, phase='train'):    root_output_dir = Path(cfg.OUTPUT_DIR)    # set up logger    if not root_output_dir.exists() and cfg.RANK == 0:        print('=> creating {}'.format(root_output_dir))        root_output_dir.mkdir()    else:        while not root_output_dir.exists():            print('=> wait for {} created'.format(root_output_dir))            time.sleep(30)    dataset = cfg.DATASET.DATASET    dataset = dataset.replace(':', '_')    model = cfg.MODEL.NAME    cfg_name = os.path.basename(cfg_name).split('.')[0]    final_output_dir = root_output_dir / dataset / model / cfg_name    if cfg.RANK == 0:        print('=> creating {}'.format(final_output_dir))        final_output_dir.mkdir(parents=True, exist_ok=True)    else:        while not final_output_dir.exists():            print('=> wait for {} created'.format(final_output_dir))            time.sleep(5)    logger, time_str = setup_logger(final_output_dir, cfg.RANK, phase)    tensorboard_log_dir = Path(cfg.LOG_DIR) / dataset / model / \        (cfg_name + '_' + time_str)    print('=> creating {}'.format(tensorboard_log_dir))    tensorboard_log_dir.mkdir(parents=True, exist_ok=True)    return logger, str(final_output_dir), str(tensorboard_log_dir)def get_optimizer(cfg, model):    optimizer = None    if cfg.TRAIN.OPTIMIZER == 'sgd':        optimizer = optim.SGD(            model.parameters(),            lr=cfg.TRAIN.LR,            momentum=cfg.TRAIN.MOMENTUM,            weight_decay=cfg.TRAIN.WD,            nesterov=cfg.TRAIN.NESTEROV        )    elif cfg.TRAIN.OPTIMIZER == 'adam':        optimizer = optim.Adam(            model.parameters(),            lr=cfg.TRAIN.LR        )    return optimizerdef save_checkpoint(states, is_best, output_dir,                    filename='checkpoint.pth.tar'):    torch.save(states, os.path.join(output_dir, filename))    if is_best and 'state_dict' in states:        torch.save(            states['best_state_dict'],            os.path.join(output_dir, 'model_best.pth.tar')        )def get_model_summary(input_size, model, *input_tensors, item_length=26, verbose=False):    """    :param model:    :param input_tensors:    :param item_length:    :return:    """    summary = []    ModuleDetails = namedtuple(        "Layer", ["name", "input_size", "output_size", "num_parameters", "multiply_adds"])    hooks = []    layer_instances = {}    model.eval()    space_len = item_length    details = ''    if verbose:        details = "Model Summary" + \            os.linesep + \            "Name{}Input Size{}Output Size{}Parameters{}Multiply Adds (Flops){}".format(                ' ' * (space_len - len("Name")),                ' ' * (space_len - len("Input Size")),                ' ' * (space_len - len("Output Size")),                ' ' * (space_len - len("Parameters")),                ' ' * (space_len - len("Multiply Adds (Flops)"))) \                + os.linesep + '-' * space_len * 5 + os.linesep    params_sum = 0    flops_sum = 0    for layer in summary:        params_sum += layer.num_parameters        if layer.multiply_adds != "Not Available":            flops_sum += layer.multiply_adds        if verbose:            details += "{}{}{}{}{}{}{}{}{}{}".format(                layer.name,                ' ' * (space_len - len(layer.name)),                layer.input_size,                ' ' * (space_len - len(str(layer.input_size))),                layer.output_size,                ' ' * (space_len - len(str(layer.output_size))),                layer.num_parameters,                ' ' * (space_len - len(str(layer.num_parameters))),                layer.multiply_adds,                ' ' * (space_len - len(str(layer.multiply_adds)))) \                + os.linesep + '-' * space_len * 5 + os.linesep    macs, params = get_model_complexity_info(model, (3,input_size,input_size), print_per_layer_stat=False, as_strings=True, verbose=True)    details += os.linesep + "Total Parameters: {}".format(params) + os.linesep + '-' * space_len * 5 + os.linesep    details += "Total Multiply Adds: {}".format(macs) + os.linesep + '-' * space_len * 5 + os.linesep    details += "Number of Layers" + os.linesep    for layer in layer_instances:        details += "{} : {} layers   ".format(layer, layer_instances[layer])    return detailsclass AverageMeter(object):    """Computes and stores the average and current value"""    def __init__(self):        self.reset()    def reset(self):        self.val = 0        self.avg = 0        self.sum = 0        self.count = 0    def update(self, val, n=1):        self.val = val        self.sum += val * n        self.count += n        self.avg = self.sum / self.count if self.count != 0 else 0