from __future__ import absolute_importfrom __future__ import divisionfrom __future__ import print_functionimport numpy as npimport cv2def flip_back(output_flipped, matched_parts):    '''    ouput_flipped: numpy.ndarray(batch_size, num_joints, height, width)    '''    assert output_flipped.ndim == 4,\        'output_flipped should be [batch_size, num_joints, height, width]'    output_flipped = output_flipped[:, :, :, ::-1]    for pair in matched_parts:        tmp = output_flipped[:, pair[0], :, :].copy()        output_flipped[:, pair[0], :, :] = output_flipped[:, pair[1], :, :]        output_flipped[:, pair[1], :, :] = tmp    return output_flippeddef fliplr_joints(joints, joints_vis, width, matched_parts):    """    flip coords    """    # Flip horizontal    joints[:, 0] = width - joints[:, 0] - 1    # Change left-right parts    for pair in matched_parts:        joints[pair[0], :], joints[pair[1], :] = \            joints[pair[1], :], joints[pair[0], :].copy()        joints_vis[pair[0], :], joints_vis[pair[1], :] = \            joints_vis[pair[1], :], joints_vis[pair[0], :].copy()    return joints*joints_vis, joints_visdef transform_preds(coords, center, scale, output_size):    # target_coords = np.zeros(coords.shape)    target_coords = coords.copy()    trans = get_affine_transform(center, scale, 0, output_size, inv=1)    for p in range(coords.shape[0]):        target_coords[p, 0:2] = affine_transform(coords[p, 0:2], trans)    return target_coordsdef get_affine_transform(center,                         scale,                         rot,                         output_size,                         shift=np.array([0, 0], dtype=np.float32),                         inv=0):    if not isinstance(scale, np.ndarray) and not isinstance(scale, list):        print(scale)        scale = np.array([scale, scale])    scale_tmp = scale * 200.0    src_w = scale_tmp[0]    dst_w = output_size[0]    dst_h = output_size[1]    rot_rad = np.pi * rot / 180    src_dir = get_dir([0, src_w * -0.5], rot_rad)    dst_dir = np.array([0, dst_w * -0.5], np.float32)    src = np.zeros((3, 2), dtype=np.float32)    dst = np.zeros((3, 2), dtype=np.float32)    src[0, :] = center + scale_tmp * shift    src[1, :] = center + src_dir + scale_tmp * shift    dst[0, :] = [dst_w * 0.5, dst_h * 0.5]    dst[1, :] = np.array([dst_w * 0.5, dst_h * 0.5]) + dst_dir    src[2:, :] = get_3rd_point(src[0, :], src[1, :])    dst[2:, :] = get_3rd_point(dst[0, :], dst[1, :])    if inv:        trans = cv2.getAffineTransform(np.float32(dst), np.float32(src))    else:        trans = cv2.getAffineTransform(np.float32(src), np.float32(dst))    return transdef affine_transform(pt, t):    new_pt = np.array([pt[0], pt[1], 1.]).T    new_pt = np.dot(t, new_pt)    return new_pt[:2]def get_3rd_point(a, b):    direct = a - b    return b + np.array([-direct[1], direct[0]], dtype=np.float32)def get_dir(src_point, rot_rad):    sn, cs = np.sin(rot_rad), np.cos(rot_rad)    src_result = [0, 0]    src_result[0] = src_point[0] * cs - src_point[1] * sn    src_result[1] = src_point[0] * sn + src_point[1] * cs    return src_resultdef crop(img, center, scale, output_size, rot=0):    trans = get_affine_transform(center, scale, rot, output_size)    dst_img = cv2.warpAffine(img,                             trans,                             (int(output_size[0]), int(output_size[1])),                             flags=cv2.INTER_LINEAR)    return dst_imgdef resize(image, input_size):    h, w, _ = image.shape    center = np.array([int(w/2.0+0.5), int(h/2.0+0.5)])    if w < h:        w_resized = input_size        h_resized = int((input_size / w * h + 63) // 64 * 64)        scale_w = w / 200.0        scale_h = h_resized / w_resized * w / 200.0    else:        h_resized = input_size        w_resized = int((input_size / h * w + 63) // 64 * 64)        scale_h = h / 200.0        scale_w = w_resized / h_resized * h / 200.0    scale = np.array([scale_w, scale_h])    trans = get_affine_transform(center, scale, 0, (w_resized, h_resized))    image_resized = cv2.warpAffine(        image,        trans,        (int(w_resized), int(h_resized))    )    return image_resized, center, scaledef get_multi_scale_size(image, input_size, current_scale, min_scale):    h, w, _ = image.shape    center = np.array([int(w / 2.0 + 0.5), int(h / 2.0 + 0.5)])    # calculate the size for min_scale    min_input_size = int((min_scale * input_size + 63)//64 * 64)    if w < h:        w_resized = int(min_input_size * current_scale / min_scale)        h_resized = int(            int((min_input_size/w*h+63)//64*64)*current_scale/min_scale        )        scale_w = w / 200.0        scale_h = h_resized / w_resized * w / 200.0    else:        h_resized = int(min_input_size * current_scale / min_scale)        w_resized = int(            int((min_input_size/h*w+63)//64*64)*current_scale/min_scale        )        scale_h = h / 200.0        scale_w = w_resized / h_resized * h / 200.0    return (w_resized, h_resized), center, np.array([scale_w, scale_h])def resize_align_multi_scale(image, input_size, current_scale, min_scale):    size_resized, center, scale = get_multi_scale_size(        image, input_size, current_scale, min_scale    )    trans = get_affine_transform(center, scale, 0, size_resized)    image_resized = cv2.warpAffine(        image,        trans,        size_resized        # (int(w_resized), int(h_resized))    )    return image_resized, center, scaledef get_final_preds(grouped_joints, center, scale, heatmap_size):    final_results = []    for person in grouped_joints[0]:        joints = np.zeros((person.shape[0], 3))        joints = transform_preds(person, center, scale, heatmap_size)        final_results.append(joints)    return final_results