from __future__ import absolute_importfrom __future__ import divisionfrom __future__ import print_functionimport torch.utils.datafrom .COCODataset import CocoDataset as cocofrom .COCOKeypoints import CocoKeypoints as coco_kptfrom .CrowdPoseDataset import CrowdPoseDataset as crowd_posefrom .CrowdPoseKeypoints import CrowdPoseKeypoints as crowd_pose_kptfrom .transforms import build_transformsfrom .target_generators import HeatmapGeneratorfrom .target_generators import ScaleAwareHeatmapGeneratorfrom .target_generators import JointsGenerator# from .random_resolution_dataloader import RandomResolutionDataLoaderdef build_dataset(cfg, is_train):    transforms = build_transforms(cfg, is_train)    if cfg.DATASET.SCALE_AWARE_SIGMA:        _HeatmapGenerator = ScaleAwareHeatmapGenerator    else:        _HeatmapGenerator = HeatmapGenerator    heatmap_generator = [        _HeatmapGenerator(            output_size, cfg.DATASET.NUM_JOINTS, cfg.DATASET.SIGMA        ) for output_size in cfg.DATASET.OUTPUT_SIZE    ]    joints_generator = [        JointsGenerator(            cfg.DATASET.MAX_NUM_PEOPLE,            cfg.DATASET.NUM_JOINTS,            output_size,            cfg.MODEL.TAG_PER_JOINT        ) for output_size in cfg.DATASET.OUTPUT_SIZE    ]    dataset_name = cfg.DATASET.TRAIN if is_train else cfg.DATASET.TEST    dataset = eval(cfg.DATASET.DATASET)(        cfg,        dataset_name,        is_train,        heatmap_generator,        joints_generator,        transforms    )    return datasetdef make_dataloader(cfg, is_train=True, distributed=False):    if is_train:        images_per_gpu = cfg.TRAIN.IMAGES_PER_GPU        shuffle = True    else:        images_per_gpu = cfg.TEST.IMAGES_PER_GPU        shuffle = False    images_per_batch = images_per_gpu * len(cfg.GPUS)    dataset = build_dataset(cfg, is_train)    if is_train and distributed:        train_sampler = torch.utils.data.distributed.DistributedSampler(            dataset        )        shuffle = False    else:        train_sampler = None    data_loader = torch.utils.data.DataLoader(    # data_loader = RandomResolutionDataLoader(        dataset,        batch_size=images_per_batch,        shuffle=shuffle,        num_workers=cfg.WORKERS,        pin_memory=cfg.PIN_MEMORY,        sampler=train_sampler    )    return data_loaderdef make_train_dataloader(cfg):    is_train = True    images_per_gpu = cfg.TRAIN.IMAGES_PER_GPU    images_per_batch = images_per_gpu * len(cfg.GPUS)    dataset = build_dataset(cfg, is_train)    data_loader = torch.utils.data.DataLoader(        dataset,        batch_size=images_per_batch,        shuffle=False,        num_workers=cfg.WORKERS,        pin_memory=False    )    return data_loader, datasetdef make_test_dataloader(cfg):    transforms = None    dataset = eval(cfg.DATASET.DATASET_TEST)(        cfg.DATASET.ROOT,        cfg.DATASET.TEST,        cfg.DATASET.DATA_FORMAT,        transforms    )    data_loader = torch.utils.data.DataLoader(        dataset,        batch_size=1,        shuffle=False,        num_workers=0,        pin_memory=False    )    return data_loader, dataset