from dataclasses import dataclass, fieldfrom typing import Any, Dict, List, Typeimport simpleeval  # type: ignorefrom dataclasses_json import dataclass_jsonfrom lisa import LisaException, schemafrom lisa.transformer import Transformer@dataclass_json()@dataclassclass ScriptEntry:    name: str = ""    variables: List[str] = field(default_factory=list)    script: str = ""@dataclass_json()@dataclassclass ScriptTransformerSchema(schema.Transformer):    scripts: List[ScriptEntry] = field(default_factory=list)class ScriptTransformer(Transformer):    """    It runs script on variables. below example will cover the "value" to    True/False with the script logic.    - name: skipped      value: $(skipped)      script: int(value) <= 0    """    @classmethod    def type_name(cls) -> str:        return "script"    @classmethod    def type_schema(cls) -> Type[schema.TypedSchema]:        return ScriptTransformerSchema    @property    def _output_names(self) -> List[str]:        runbook: ScriptTransformerSchema = self.runbook        return [item.name for item in runbook.scripts]    def _initialize(self, *args: Any, **kwargs: Any) -> None:        self._index: int = 0        self._items: List[Dict[str, Any]] = []    def _internal_run(self) -> Dict[str, Any]:        runbook: ScriptTransformerSchema = self.runbook        result: Dict[str, Any] = {}        for item in runbook.scripts:            variables: Dict[str, Any] = {                key: self._runbook_builder.variables[key].data for key in item.variables            }            evaluator = simpleeval.SimpleEval(                # Update ex: DEFAULT_OPERATORS | {ast.BitXor, operator.xor}                operators=simpleeval.DEFAULT_OPERATORS | {},                # Update ex: DEFAULT_FUNCTIONS | {'floor': math.floor}                functions=simpleeval.DEFAULT_FUNCTIONS | {},                names=simpleeval.DEFAULT_NAMES | variables,            )            try:                result[item.name] = evaluator.eval(item.script)            except simpleeval.InvalidExpression as e:                raise LisaException(                    f"'{item.script}' failed, variables: {variables}. {e}"                ) from e            self._log.debug(                "script: '%s', variables: %s, result: '%s'",                item.script,                variables,                result[item.name],            )        return result