from typing import castfrom lisa.executable import Toolfrom lisa.operating_system import Posixfrom lisa.tools import Wgetfrom lisa.util import MissingPackagesExceptionfrom .make import Makefrom .tar import Tarclass Texinfo(Tool):    version = "7.0.1.90"    source_link = f"http://alpha.gnu.org/gnu/texinfo/texinfo-{version}.tar.xz"    @property    def command(self) -> str:        return "makeinfo"    @property    def can_install(self) -> bool:        return True    def _install(self) -> bool:        posix_os: Posix = cast(Posix, self.node.os)        try:            posix_os.install_packages("texinfo", timeout=2000)        except MissingPackagesException:            posix_os.install_packages(["perl", "perl-Data-Dumper"])            self._install_from_src()        return self._check_exists()    def _install_from_src(self) -> None:        tool_path = self.get_tool_path()        wget = self.node.tools[Wget]        tar = self.node.tools[Tar]        download_path = wget.get(            url=self.source_link,            filename=f"texinfo-{self.version}.tar.xz",            file_path=str(tool_path),        )        tar.extract(download_path, dest_dir=str(tool_path))        code_path = tool_path.joinpath(f"texinfo-{self.version}")        make = self.node.tools[Make]        self.node.execute("./configure", cwd=code_path).assert_exit_code()        make.make_install(code_path)        self.node.execute(            "ln -s /usr/local/bin/makeinfo /usr/bin/makeinfo", sudo=True, cwd=code_path        ).assert_exit_code()