import refrom lisa.base_tools import Cat, Sed, Servicefrom lisa.executable import Toolfrom lisa.operating_system import Ubuntufrom lisa.util import LisaException, find_patterns_groups_in_linesfrom .echo import Echofrom .find import Findclass Ssh(Tool):    @property    def command(self) -> str:        return "ssh"    @property    def can_install(self) -> bool:        return False    def generate_key_pairs(self) -> str:        for file in [".ssh/id_rsa.pub", ".ssh/id_rsa"]:            file_path = self.node.get_pure_path(file)            if self.node.shell.exists(file_path):                self.node.shell.remove(file_path)        self.node.execute(            "echo | ssh-keygen -N ''",            shell=True,            expected_exit_code=0,            expected_exit_code_failure_message="error on generate key files.",        )        cat = self.node.tools[Cat]        public_key = cat.read(            str(self.node.get_pure_path("~/.ssh/id_rsa.pub")),            force_run=True,        )        return public_key    def enable_public_key(self, public_key: str) -> None:        self.node.tools[Echo].write_to_file(            public_key,            self.node.get_pure_path("~/.ssh/authorized_keys"),            append=True,        )    def add_known_host(self, ip: str) -> None:        self.node.execute(f"ssh-keyscan -H {ip} >> ~/.ssh/known_hosts", shell=True)    def get_default_sshd_config_path(self) -> str:        file_name = "sshd_config"        default_path = f"/etc/ssh/{file_name}"        if self.node.shell.exists(self.node.get_pure_path(default_path)):            return default_path        find = self.node.tools[Find]        result = find.find_files(self.node.get_pure_path("/"), file_name, sudo=True)        if result and result[0]:            return result[0]        else:            raise LisaException("not find sshd_config")    def set_max_session(self, count: int = 200) -> None:        config_path = self.get_default_sshd_config_path()        sed = self.node.tools[Sed]        sed.append(f"MaxSessions {count}", config_path, sudo=True)        service = self.node.tools[Service]        if service.check_service_exists("sshd"):            service.restart_service("sshd")        elif service.check_service_exists("ssh"):            service.restart_service("ssh")        else:            raise LisaException("could not find ssh or sshd service")        # The above changes take effect only for *new* connections. So,        # close the current connection.        self.node.close()    def get(self, setting: str) -> str:        config_path = self.get_default_sshd_config_path()        settings = self.node.tools[Cat].read(config_path, True, True)        if isinstance(self.node.os, Ubuntu):            extra_sshd_config = "/etc/ssh/sshd_config.d/50-cloudimg-settings.conf"            path_exist = self.node.execute(f"ls -lt {extra_sshd_config}", sudo=True)            if path_exist.exit_code == 0:                settings += self.node.tools[Cat].read(extra_sshd_config, True, True)        pattern = re.compile(rf"^{setting}\s+(?P<value>.*)", re.M)        matches = find_patterns_groups_in_lines(settings, [pattern])        if not matches[0]:            return ""        return (matches[0][-1])["value"]