from __future__ import annotationsimport refrom typing import List, Pattern, Typefrom lisa.base_tools import Cat, Systemctlfrom lisa.executable import Toolfrom lisa.operating_system import CBLMarinerfrom lisa.util import find_patterns_in_linesfrom .git import Gitfrom .ls import Lsfrom .make import Makeclass HibernationSetup(Tool):    _repo = "https://github.com/microsoft/hibernation-setup-tool"    # [  159.967060] PM: hibernation entry    _entry_pattern = re.compile(r"^(.*hibernation entry.*)$", re.MULTILINE)    # [   22.813227] PM: hibernation exit    _exit_pattern = re.compile(r"^(.*hibernation exit.*)$", re.MULTILINE)    # [  159.898723] hv_utils: Hibernation request received    _received_pattern = re.compile(        r"^(.*Hibernation request received.*)$", re.MULTILINE    )    # [  159.898806] hv_utils: Sent hibernation uevent    _uevent_pattern = re.compile(r"^(.*Sent hibernation uevent.*)$", re.MULTILINE)    @property    def command(self) -> str:        return "hibernation-setup-tool"    @property    def dependencies(self) -> List[Type[Tool]]:        return [Git, Make]    @property    def can_install(self) -> bool:        return True    def start(self) -> None:        self.run(            sudo=True,            expected_exit_code=0,            expected_exit_code_failure_message="fail to start",        )    def check_entry(self) -> int:        return self._check(self._entry_pattern)    def check_exit(self) -> int:        return self._check(self._exit_pattern)    def check_received(self) -> int:        return self._check(self._received_pattern)    def check_uevent(self) -> int:        return self._check(self._uevent_pattern)    def hibernate(self) -> None:        self.node.tools[Systemctl].hibernate()    def _install(self) -> bool:        if isinstance(self.node.os, CBLMariner):            self.node.os.install_packages(["glibc-devel", "kernel-headers", "binutils"])        tool_path = self.get_tool_path()        git = self.node.tools[Git]        git.clone(self._repo, tool_path)        code_path = tool_path.joinpath("hibernation-setup-tool")        make = self.node.tools[Make]        make.make_install(code_path)        return self._check_exists()    def _check(self, pattern: Pattern[str]) -> int:        cat = self.node.tools[Cat]        log_output = ""        ls = self.node.tools[Ls]        if ls.path_exists("/var/log/syslog", sudo=True):            log_output = cat.read("/var/log/syslog", force_run=True, sudo=True)        if ls.path_exists("/var/log/messages", sudo=True):            log_output = cat.read("/var/log/messages", force_run=True, sudo=True)        matched_lines = find_patterns_in_lines(log_output, [pattern])        if not matched_lines:            return 0        return len(matched_lines[0])