from pathlib import PurePathfrom typing import Optional, Typefrom assertpy.assertpy import assert_thatfrom lisa.executable import Toolclass Echo(Tool):    @property    def command(self) -> str:        return "echo"    @classmethod    def _windows_tool(cls) -> Optional[Type[Tool]]:        return WindowsEcho    def _check_exists(self) -> bool:        return True    def write_to_file(        self,        value: str,        file: PurePath,        sudo: bool = False,        timeout: int = 60,        append: bool = False,        ignore_error: bool = True,    ) -> None:        # Run `echo <value> > <file>`        operator = ">"        if append:            operator = ">>"        result = self.run(            f"'{value}' {operator} {file}",            force_run=True,            shell=True,            sudo=sudo,            timeout=timeout,        )        if not ignore_error:            result.assert_exit_code(                message=f"echo failed to write to {file}",            )            assert_that(result.stdout).does_not_contain("Permission denied")class WindowsEcho(Echo):    @property    def command(self) -> str:        return "cmd /c echo"    def write_to_file(        self,        value: str,        file: PurePath,        sudo: bool = False,        timeout: int = 60,        append: bool = False,        ignore_error: bool = True,    ) -> None:        from . import PowerShell        command = f'@"\n{value}\n"@ | Out-File -FilePath {file}'        if append:            command += " -Append"        ps = self.node.tools[PowerShell]        ps.run_cmdlet(            command,            force_run=True,            sudo=sudo,            timeout=timeout,            fail_on_error=not ignore_error,        )