import refrom typing import List, Typefrom lisa.environment import Environmentfrom lisa.feature import Featurefrom lisa.node import Nodefrom lisa.sut_orchestrator.libvirt.context import get_node_contextfrom lisa.sut_orchestrator.libvirt.platform import BaseLibvirtPlatformfrom lisa.tools import QemuImgfrom lisa.util.logger import Logger, filter_ansi_escapefrom .. import QEMUfrom .schema import QemuNodeSchemaQEMU_VERSION_PATTERN = re.compile(r"QEMU emulator version (?P<qemu_version>.+)\s")class QemuPlatform(BaseLibvirtPlatform):    @classmethod    def type_name(cls) -> str:        return QEMU    @classmethod    def supported_features(cls) -> List[Type[Feature]]:        return BaseLibvirtPlatform._supported_features    @classmethod    def node_runbook_type(cls) -> type:        return QemuNodeSchema    def _libvirt_uri_schema(self) -> str:        return "qemu"    # Create the OS disk.    def _create_node_os_disk(        self, environment: Environment, log: Logger, node: Node    ) -> None:        node_context = get_node_context(node)        self.host_node.tools[QemuImg].create_diff_qcow2(            node_context.os_disk_file_path, node_context.os_disk_base_file_path        )        if node_context.os_disk_img_resize_gib:            self.host_node.tools[QemuImg].resize(                src_file=node_context.os_disk_file_path,                size_gib=node_context.os_disk_img_resize_gib,            )    def _get_vmm_version(self) -> str:        result = "Unknown"        if self.host_node:            output = self.host_node.execute(                "qemu-system-x86_64 --version",                shell=True,            ).stdout            output = filter_ansi_escape(output)            match = re.search(QEMU_VERSION_PATTERN, output.strip())            if match:                result = match.group("qemu_version")        return result