from dataclasses import dataclass, fieldfrom typing import Any, List, Optionalfrom dataclasses_json import dataclass_jsonfrom lisa import schemafrom lisa.secret import PATTERN_HEADTAIL, add_secretfrom lisa.util import field_metadata@dataclass_json()@dataclassclass ClientCapabilities:    core_count: int = field(default=-1)    free_memory_mb: int = field(default=-1)@dataclass_json()@dataclassclass ClientSchema:    connection: Optional[schema.RemoteNode] = field(        default=None, metadata=field_metadata(required=True)    )    capabilities: Optional[ClientCapabilities] = None@dataclass_json()@dataclassclass RackManagerClientSchema(ClientSchema):    management_port: Optional[int] = field(default=-1)@dataclass_json()@dataclassclass IdracClientSchema(ClientSchema):    iso_http_url: Optional[str] = field(default="")@dataclass_json()@dataclassclass ReadyCheckerSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="file_single", metadata=field_metadata(required=True))    timeout: int = 300@dataclass_json()@dataclassclass FileSchema:    source: str = field(default="")    destination: Optional[str] = field(default="")@dataclass_json()@dataclassclass BuildSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="smb", metadata=field_metadata(required=True))    name: str = ""    share: str = ""    files: List[FileSchema] = field(default_factory=list)@dataclass_json()@dataclassclass IpGetterSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="file_single", metadata=field_metadata(required=True))@dataclass_json()@dataclassclass KeyLoaderSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="build", metadata=field_metadata(required=True))@dataclass_json()@dataclassclass ClusterSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="rackmanager", metadata=field_metadata(required=True))    build: Optional[BuildSchema] = None    ready_checker: Optional[ReadyCheckerSchema] = None    ip_getter: Optional[IpGetterSchema] = None    key_loader: Optional[KeyLoaderSchema] = None@dataclass_json()@dataclassclass SourceSchema(schema.TypedSchema, schema.ExtendableSchemaMixin):    type: str = field(default="ado", metadata=field_metadata(required=True))    name: str = ""@dataclass_json()@dataclassclass Artifact:    artifact_name: str = ""    extract: bool = True@dataclass_json()@dataclassclass ADOSourceSchema(SourceSchema):    organization_url: str = field(default="", metadata=field_metadata(required=True))    project: str = field(default="", metadata=field_metadata(required=True))    build_id: int = 0    pipeline_name: str = ""    pat: str = field(default="", metadata=field_metadata(required=True))    artifacts: List[Artifact] = field(default_factory=list)    def __post_init__(self, *args: Any, **kwargs: Any) -> None:        if not self.organization_url:            raise ValueError("organization_url cannot be empty")        if not self.project:            raise ValueError("project cannot be empty")        if not self.pat:            raise ValueError("pat cannot be empty")        if not self.artifacts:            raise ValueError("artifacts cannot be empty")        if not self.build_id and not self.pipeline_name:            raise ValueError("build_id and pipeline_name are both empty")        add_secret(self.pat)@dataclass_json()@dataclassclass SMBBuildSchema(BuildSchema):    username: str = ""    password: str = ""    share: str = ""    server_name: str = ""    def __post_init__(self, *args: Any, **kwargs: Any) -> None:        add_secret(self.username, PATTERN_HEADTAIL)        add_secret(self.password)@dataclass_json()@dataclassclass IdracSchema(ClusterSchema):    address: str = ""    username: str = ""    password: str = ""    client: List[IdracClientSchema] = field(default_factory=list)    def __post_init__(self, *args: Any, **kwargs: Any) -> None:        add_secret(self.username, PATTERN_HEADTAIL)        add_secret(self.password)@dataclass_json()@dataclassclass RackManagerSchema(ClusterSchema):    connection: Optional[schema.RemoteNode] = field(        default=None, metadata=field_metadata(required=True)    )    client: List[RackManagerClientSchema] = field(default_factory=list)@dataclass_json()@dataclassclass BareMetalPlatformSchema:    source: Optional[SourceSchema] = field(default=None)    cluster: List[ClusterSchema] = field(default_factory=list)