import osimport reimport sysfrom dataclasses import InitVar, dataclass, fieldfrom datetime import datetime, timedelta, timezonefrom functools import lru_cache, partialfrom pathlib import Pathfrom threading import Lockfrom time import sleepfrom typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Unionimport requestsfrom assertpy import assert_thatfrom azure.core.exceptions import ResourceExistsErrorfrom azure.keyvault.certificates import (    CertificateClient,    CertificatePolicy,    KeyVaultCertificate,)from azure.keyvault.secrets import SecretClientfrom azure.mgmt.compute import ComputeManagementClientfrom azure.mgmt.compute.models import VirtualMachinefrom azure.mgmt.keyvault import KeyVaultManagementClientfrom azure.mgmt.keyvault.models import (    AccessPolicyEntry,    Permissions,    VaultCreateOrUpdateParameters,    VaultProperties,)from azure.mgmt.marketplaceordering import MarketplaceOrderingAgreements  # type: ignorefrom azure.mgmt.msi import ManagedServiceIdentityClientfrom azure.mgmt.network import NetworkManagementClient  # type: ignorefrom azure.mgmt.network.models import (  # type: ignore    PrivateDnsZoneConfig,    PrivateDnsZoneGroup,    PrivateEndpoint,    PrivateLinkServiceConnection,    PrivateLinkServiceConnectionState,    Subnet,)from azure.mgmt.privatedns import PrivateDnsManagementClient  # type: ignorefrom azure.mgmt.privatedns.models import (  # type: ignore    ARecord,    PrivateZone,    RecordSet,    SubResource,    VirtualNetworkLink,)from azure.mgmt.resource import (  # type: ignore    ResourceManagementClient,    SubscriptionClient,)from azure.mgmt.storage import StorageManagementClient  # type: ignorefrom azure.mgmt.storage.models import (  # type: ignore    Sku,    StorageAccountCreateParameters,)from azure.storage.blob import (    AccountSasPermissions,    BlobClient,    BlobSasPermissions,    BlobServiceClient,    ContainerClient,    ResourceTypes,    generate_account_sas,    generate_blob_sas,)from azure.storage.fileshare import ShareServiceClient  # type: ignorefrom dataclasses_json import dataclass_jsonfrom marshmallow import validatefrom msrestazure.azure_cloud import Cloud  # type: ignorefrom PIL import Image, UnidentifiedImageErrorfrom retry import retryfrom lisa import schema, search_spacefrom lisa.environment import Environment, load_environmentsfrom lisa.feature import Featuresfrom lisa.node import Node, RemoteNode, localfrom lisa.secret import PATTERN_HEADTAIL, PATTERN_URL, add_secret, replacefrom lisa.tools import Lsfrom lisa.util import (    LisaException,    LisaTimeoutException,    check_till_timeout,    constants,    field_metadata,    get_matched_str,    strip_strs,)from lisa.util.logger import Loggerfrom lisa.util.parallel import check_cancelledfrom lisa.util.perf_timer import create_timerif TYPE_CHECKING:    from .platform_ import AzurePlatformAZURE_SHARED_RG_NAME = "lisa_shared_resource"AZURE_VIRTUAL_NETWORK_NAME = "lisa-virtualNetwork"AZURE_SUBNET_PREFIX = "lisa-subnet-"NIC_NAME_PATTERN = re.compile(r"Microsoft.Network/networkInterfaces/(.*)", re.M)PATTERN_PUBLIC_IP_NAME = re.compile(    r"providers/Microsoft.Network/publicIPAddresses/(.*)", re.M)# /subscriptions/xxxx/resourceGroups/xxxx/providers/Microsoft.Compute/galleries/xxxx# /subscriptions/xxxx/resourceGroups/xxxx/providers/Microsoft.Storage/storageAccounts/xxxxRESOURCE_GROUP_PATTERN = re.compile(r"resourceGroups/(.*)/providers", re.M)# https://sc.blob.core.windows.net/container/xxxx/xxxx/xxxx.vhdSTORAGE_CONTAINER_BLOB_PATTERN = re.compile(    r"https://(?P<sc>.*)"    r"(?:\.blob\.core\.windows\.net|blob\.storage\.azure\.net)"    r"/(?P<container>[^/]+)/?/(?P<blob>.*)",    re.M,)# https://abcdefg.blob.core.windows.net/abcdefg?sv=2020-08-04&# st=2022-01-19T06%3A25%3A16Z&se=2022-01-19T06%3A25%3A00Z&sr=b&# sp=r&sig=DdBu3FTHQr1%2BzIY%2FdS054IlsDQ1RdfjfL3FgRgexgeo%3D# https://abcdefg.blob.storage.azure.net/1b33rftmpdhs/abcdefg?# sv=2018-03-28&sr=b&si=11111111-feff-4312-bba2-3ca6eabf9b24&# sig=xdZaRwJBwu3P2pYbQ3uEmymlovFwHrtQNVWDHyK48sg%3DSAS_URL_PATTERN = re.compile(    r"^https://.*?(?:\.blob\.core\.windows\.net|"    r"blob\.storage\.azure\.net)/.*?\?sv=[^&]+?(?:&st=[^&]+)?"    r"(?:&se=(?P<year>[\d]{4})-(?P<month>[\d]{2})-(?P<day>[\d]{2}).*?)|.*?&sig=.*?$")SAS_COPIED_CONTAINER_NAME = "lisa-sas-copied"# The timeout hours of the blob with copy pending status# If the blob is still copy pending status after the timeout hours, it can be deletedBLOB_COPY_PENDING_TIMEOUT_HOURS = 6_global_sas_vhd_copy_lock = Lock()# when call sdk APIs, it's easy to have conflict on access auth files. Use lock# to prevent it happens.global_credential_access_lock = Lock()# if user uses lisa for the first time in parallel, there will be a possibility# to create the same storage account at the same time.# add a lock to prevent it happens._global_storage_account_check_create_lock = Lock()MARKETPLACE_IMAGE_KEYS = ["publisher", "offer", "sku", "version"]SIG_IMAGE_KEYS = [    "subscription_id",    "resource_group_name",    "image_gallery",    "image_definition",    "image_version",]# IMDS is a REST API that's available at a well-known, non-routable IP address (169.254.169.254). # noqa: E501METADATA_ENDPOINT = "http://169.254.169.254/metadata/instance?api-version=2021-02-01"@dataclassclass EnvironmentContext:    resource_group_name: str = ""    resource_group_is_specified: bool = False    provision_time: float = 0@dataclassclass NodeContext:    resource_group_name: str = ""    vm_name: str = ""    username: str = ""    password: str = ""    private_key_file: str = ""    use_public_address: bool = True    public_ip_address: str = ""    private_ip_address: str = ""    location: str = ""    subscription_id: str = ""@dataclass_json()@dataclassclass AzureVmPurchasePlanSchema:    name: str    product: str    publisher: str@dataclass_json@dataclassclass AzureImageSchema:    network_data_path: Optional[        Union[search_space.SetSpace[schema.NetworkDataPath], schema.NetworkDataPath]    ] = field(  # type: ignore        default_factory=partial(            search_space.SetSpace,            items=[                schema.NetworkDataPath.Synthetic,                schema.NetworkDataPath.Sriov,            ],        ),        metadata=field_metadata(            decoder=partial(                search_space.decode_set_space_by_type, base_type=schema.NetworkDataPath            )        ),    )@dataclass_json()@dataclassclass AzureVmMarketplaceSchema(AzureImageSchema):    publisher: str = "Canonical"    offer: str = "0001-com-ubuntu-server-jammy"    sku: str = "22_04-lts"    version: str = "Latest"    def __hash__(self) -> int:        return hash(f"{self.publisher}/{self.offer}/{self.sku}/{self.version}")@dataclass_json()@dataclassclass SharedImageGallerySchema(AzureImageSchema):    subscription_id: str = ""    resource_group_name: Optional[str] = None    image_gallery: str = ""    image_definition: str = ""    image_version: str = ""    def __hash__(self) -> int:        return hash(            f"/subscriptions/{self.subscription_id}/resourceGroups/"            f"{self.resource_group_name}/providers/Microsoft.Compute/galleries/"            f"{self.image_gallery}/images/{self.image_definition}/versions/"            f"{self.image_version}"        )@dataclass_json()@dataclassclass VhdSchema(AzureImageSchema):    vhd_path: str = ""    vmgs_path: Optional[str] = None@dataclass_json()@dataclassclass AzureNodeSchema:    name: str = ""    # It decides the real computer name. It cannot be too long.    short_name: str = ""    vm_size: str = ""    # Specifies the minimum OS disk size. The size of the disk that gets provisioned    # may be larger than this depending on other requirements set by VHD, marketplace    # image etc but it will never be smaller.    osdisk_size_in_gb: int = 30    # Force to maximize capability of the vm size. It bypass requirements on    # test cases, and uses to force run performance tests on any vm size.    maximize_capability: bool = False    location: str = ""    # Required by shared gallery images which are present in    # subscription different from where LISA is run    subscription_id: str = ""    purchase_plan_raw: Optional[Union[Dict[Any, Any], str]] = field(        default=None, metadata=field_metadata(data_key="purchase_plan")    )    marketplace_raw: Optional[Union[Dict[Any, Any], str]] = field(        default=None, metadata=field_metadata(data_key="marketplace")    )    shared_gallery_raw: Optional[Union[Dict[Any, Any], str]] = field(        default=None, metadata=field_metadata(data_key="shared_gallery")    )    vhd_raw: Optional[Union[Dict[Any, Any], str]] = field(        default=None, metadata=field_metadata(data_key="vhd")    )    hyperv_generation: int = field(        default=1,        metadata=field_metadata(validate=validate.OneOf([1, 2])),    )    # for marketplace image, which need to accept terms    _purchase_plan: InitVar[Optional[AzureVmPurchasePlanSchema]] = None    # the linux and Windows has different settings. If it's not specified, it's    # True by default for SIG and vhd, and is parsed from marketplace    # image.    is_linux: Optional[bool] = None    _marketplace: InitVar[Optional[AzureVmMarketplaceSchema]] = None    _shared_gallery: InitVar[Optional[SharedImageGallerySchema]] = None    _vhd: InitVar[Optional[VhdSchema]] = None    def __post_init__(self, *args: Any, **kwargs: Any) -> None:        # trim whitespace of values.        strip_strs(            self,            [                "name",                "short_name",                "vm_size",                "location",                "subscription_id",                "marketplace_raw",                "shared_gallery_raw",                "vhd_raw",                "data_disk_caching_type",                "os_disk_type",                "data_disk_type",                "purchase_plan_raw",            ],        )        self.location = self.location.lower()        # If vhd contains sas token, need add mask        if isinstance(self.vhd_raw, str):            add_secret(self.vhd_raw, PATTERN_URL)    @property    def purchase_plan(self) -> Optional[AzureVmPurchasePlanSchema]:        # this is a safe guard and prevent mypy error on typing        if not hasattr(self, "_purchase_plan"):            self._purchase_plan: Optional[AzureVmPurchasePlanSchema] = None        purchase_plan: Optional[AzureVmPurchasePlanSchema] = self._purchase_plan        if not purchase_plan:            if isinstance(self.purchase_plan_raw, dict):                purchase_plan = schema.load_by_type(                    AzureVmPurchasePlanSchema, self.purchase_plan_raw                )                if not all(                    [                        purchase_plan.name.strip(),                        purchase_plan.product.strip(),                        purchase_plan.publisher.strip(),                    ]                ):                    purchase_plan = None                else:                    # this step makes purchase_plan_raw is validated, and                    # filter out any unwanted content.                    self.purchase_plan_raw = purchase_plan.to_dict()  # type: ignore            elif self.purchase_plan_raw:                assert isinstance(                    self.purchase_plan_raw, str                ), f"actual: {type(self.purchase_plan_raw)}"                self.purchase_plan_raw = self.purchase_plan_raw.strip()                if self.purchase_plan_raw:                    purchase_plan_strings = re.split(r"[:\s]+", self.purchase_plan_raw)                    if len(purchase_plan_strings) == 3:                        purchase_plan = AzureVmPurchasePlanSchema(                            name=purchase_plan_strings[0],                            product=purchase_plan_strings[1],                            publisher=purchase_plan_strings[2],                        )                        # purchase_plan_raw is used                        self.purchase_plan_raw = purchase_plan.to_dict()  # type: ignore                    else:                        raise LisaException(                            f"Invalid value for the provided purchase_plan "                            f"parameter: '{self.purchase_plan_raw}'."                            f"The purchase_plan parameter should be in the format: "                            f"'<name> <product> <publisher>' "                        )            self._purchase_plan = purchase_plan        return purchase_plan    @purchase_plan.setter    def purchase_plan(self, value: Optional[AzureVmPurchasePlanSchema]) -> None:        self._purchase_plan = value        if value is None:            self.purchase_plan_raw = None        else:            self.purchase_plan_raw = value.to_dict()  # type: ignore    @property    def marketplace(self) -> Optional[AzureVmMarketplaceSchema]:        # this is a safe guard and prevent mypy error on typing        if not hasattr(self, "_marketplace"):            self._marketplace: Optional[AzureVmMarketplaceSchema] = None        marketplace: Optional[AzureVmMarketplaceSchema] = self._marketplace        if not marketplace:            if isinstance(self.marketplace_raw, dict):                # Users decide the cases of image names,                #  the inconsistent cases cause the mismatched error in notifiers.                # The lower() normalizes the image names,                #  it has no impact on deployment.                self.marketplace_raw = dict(                    (k, v.lower())                    if isinstance(v, str) and k in MARKETPLACE_IMAGE_KEYS                    else (k, v)                    for k, v in self.marketplace_raw.items()                )                marketplace = schema.load_by_type(                    AzureVmMarketplaceSchema, self.marketplace_raw                )                if not all(                    [                        marketplace.publisher,                        marketplace.offer,                        marketplace.sku,                        marketplace.version,                    ]                ):                    marketplace = None                else:                    # this step makes marketplace_raw is validated, and                    # filter out any unwanted content.                    self.marketplace_raw = marketplace.to_dict()  # type: ignore            elif self.marketplace_raw:                assert isinstance(                    self.marketplace_raw, str                ), f"actual: {type(self.marketplace_raw)}"                self.marketplace_raw = self.marketplace_raw.strip()                if self.marketplace_raw:                    # Users decide the cases of image names,                    #  the inconsistent cases cause the mismatched error in notifiers.                    # The lower() normalizes the image names,                    #  it has no impact on deployment.                    marketplace_strings = re.split(                        r"[:\s]+", self.marketplace_raw.lower()                    )                    if len(marketplace_strings) == 4:                        marketplace = AzureVmMarketplaceSchema(                            publisher=marketplace_strings[0],                            offer=marketplace_strings[1],                            sku=marketplace_strings[2],                            version=marketplace_strings[3],                        )                        # marketplace_raw is used                        self.marketplace_raw = marketplace.to_dict()  # type: ignore                    else:                        raise LisaException(                            f"Invalid value for the provided marketplace "                            f"parameter: '{self.marketplace_raw}'."                            f"The marketplace parameter should be in the format: "                            f"'<Publisher> <Offer> <Sku> <Version>' "                            f"or '<Publisher>:<Offer>:<Sku>:<Version>'"                        )            self._marketplace = marketplace        return marketplace    @marketplace.setter    def marketplace(self, value: Optional[AzureVmMarketplaceSchema]) -> None:        self._marketplace = value        if value is None:            self.marketplace_raw = None        else:            self.marketplace_raw = value.to_dict()  # type: ignore    @property    def shared_gallery(self) -> Optional[SharedImageGallerySchema]:        # this is a safe guard and prevent mypy error on typing        if not hasattr(self, "_shared_gallery"):            self._shared_gallery: Optional[SharedImageGallerySchema] = None        shared_gallery: Optional[SharedImageGallerySchema] = self._shared_gallery        if shared_gallery:            return shared_gallery        if isinstance(self.shared_gallery_raw, dict):            # Users decide the cases of image names,            #  the inconsistent cases cause the mismatched error in notifiers.            # The lower() normalizes the image names,            #  it has no impact on deployment.            self.shared_gallery_raw = dict(                (k, v.lower()) if isinstance(v, str) and k in SIG_IMAGE_KEYS else (k, v)                for k, v in self.shared_gallery_raw.items()            )            shared_gallery = schema.load_by_type(                SharedImageGallerySchema, self.shared_gallery_raw            )            if not all(                [                    shared_gallery.image_definition,                    shared_gallery.image_version,                    shared_gallery.image_gallery,                ]            ):                shared_gallery = None            else:                if not shared_gallery.subscription_id:                    shared_gallery.subscription_id = self.subscription_id                # this step makes shared_gallery_raw is validated, and                # filter out any unwanted content.                self.shared_gallery_raw = shared_gallery.to_dict()  # type: ignore        elif self.shared_gallery_raw:            assert isinstance(                self.shared_gallery_raw, str            ), f"actual: {type(self.shared_gallery_raw)}"            # Users decide the cases of image names,            #  the inconsistent cases cause the mismatched error in notifiers.            # The lower() normalizes the image names,            #  it has no impact on deployment.            shared_gallery_strings = re.split(                r"[/]+", self.shared_gallery_raw.strip().lower()            )            if len(shared_gallery_strings) == 5:                shared_gallery = SharedImageGallerySchema(                    subscription_id=shared_gallery_strings[0],                    resource_group_name=shared_gallery_strings[1],                    image_gallery=shared_gallery_strings[2],                    image_definition=shared_gallery_strings[3],                    image_version=shared_gallery_strings[4],                )                # shared_gallery_raw is used                self.shared_gallery_raw = shared_gallery.to_dict()  # type: ignore            elif len(shared_gallery_strings) == 3:                shared_gallery = SharedImageGallerySchema(                    subscription_id=self.subscription_id,                    image_gallery=shared_gallery_strings[0],                    image_definition=shared_gallery_strings[1],                    image_version=shared_gallery_strings[2],                )                # shared_gallery_raw is used                self.shared_gallery_raw = shared_gallery.to_dict()  # type: ignore            else:                raise LisaException(                    f"Invalid value for the provided shared gallery "                    f"parameter: '{self.shared_gallery_raw}'."                    f"The shared gallery parameter should be in the format: "                    f"'<subscription_id>/<resource_group_name>/<image_gallery>/"                    f"<image_definition>/<image_version>' or '<image_gallery>/"                    f"<image_definition>/<image_version>'"                )        self._shared_gallery = shared_gallery        return shared_gallery    @shared_gallery.setter    def shared_gallery(self, value: Optional[SharedImageGallerySchema]) -> None:        self._shared_gallery = value        if value is None:            self.shared_gallery_raw = None        else:            self.shared_gallery_raw = value.to_dict()  # type: ignore    @property    def vhd(self) -> Optional[VhdSchema]:        # this is a safe guard and prevent mypy error on typing        if not hasattr(self, "_vhd"):            self._vhd: Optional[VhdSchema] = None        vhd: Optional[VhdSchema] = self._vhd        if vhd:            return vhd        if isinstance(self.vhd_raw, dict):            vhd = schema.load_by_type(VhdSchema, self.vhd_raw)            if not vhd.vhd_path:                vhd = None            else:                add_secret(vhd.vhd_path, PATTERN_URL)                if vhd.vmgs_path:                    add_secret(vhd.vmgs_path, PATTERN_URL)                # this step makes vhd_raw is validated, and                # filter out any unwanted content.                self.vhd_raw = vhd.to_dict()  # type: ignore        elif self.vhd_raw:            assert isinstance(self.vhd_raw, str), f"actual: {type(self.vhd_raw)}"            vhd = VhdSchema(vhd_path=self.vhd_raw)            add_secret(vhd.vhd_path, PATTERN_URL)            self.vhd_raw = vhd.to_dict()  # type: ignore        self._vhd = vhd        if vhd:            return vhd        else:            return None    @vhd.setter    def vhd(self, value: Optional[VhdSchema]) -> None:        self._vhd = value        if value is None:            self.vhd_raw = None        else:            self.vhd_raw = self._vhd.to_dict()  # type: ignore    def get_image_name(self) -> str:        result = ""        if self.vhd and self.vhd.vhd_path:            result = self.vhd.vhd_path        elif self.shared_gallery:            assert isinstance(                self.shared_gallery_raw, dict            ), f"actual type: {type(self.shared_gallery_raw)}"            if self.shared_gallery.resource_group_name:                result = "/".join(                    [self.shared_gallery_raw.get(k, "") for k in SIG_IMAGE_KEYS]                )            else:                result = (                    f"{self.shared_gallery.image_gallery}/"                    f"{self.shared_gallery.image_definition}/"                    f"{self.shared_gallery.image_version}"                )        elif self.marketplace:            assert isinstance(                self.marketplace_raw, dict            ), f"actual type: {type(self.marketplace_raw)}"            result = " ".join(                [self.marketplace_raw.get(k, "") for k in MARKETPLACE_IMAGE_KEYS]            )        return result@dataclass_json()@dataclassclass AzureNodeArmParameter(AzureNodeSchema):    nic_count: int = 1    enable_sriov: bool = False    os_disk_type: str = ""    data_disk_type: str = ""    disk_controller_type: str = ""    security_profile: Dict[str, Any] = field(default_factory=dict)    @classmethod    def from_node_runbook(cls, runbook: AzureNodeSchema) -> "AzureNodeArmParameter":        parameters = runbook.to_dict()  # type: ignore        if "marketplace" in parameters:            parameters["marketplace_raw"] = parameters["marketplace"]            del parameters["marketplace"]        if "purchase_plan" in parameters:            parameters["purchase_plan_raw"] = parameters["purchase_plan"]            del parameters["purchase_plan"]        if "shared_gallery" in parameters:            parameters["shared_gallery_raw"] = parameters["shared_gallery"]            del parameters["shared_gallery"]        if "vhd" in parameters:            parameters["vhd_raw"] = parameters["vhd"]            del parameters["vhd"]        arm_parameters = AzureNodeArmParameter(**parameters)        return arm_parametersclass DataDiskCreateOption:    DATADISK_CREATE_OPTION_TYPE_EMPTY: str = "Empty"    DATADISK_CREATE_OPTION_TYPE_FROM_IMAGE: str = "FromImage"    DATADISK_CREATE_OPTION_TYPE_ATTACH: str = "Attach"    @staticmethod    def get_create_option() -> List[str]:        return [            DataDiskCreateOption.DATADISK_CREATE_OPTION_TYPE_EMPTY,            DataDiskCreateOption.DATADISK_CREATE_OPTION_TYPE_FROM_IMAGE,            DataDiskCreateOption.DATADISK_CREATE_OPTION_TYPE_ATTACH,        ]@dataclass_json()@dataclassclass DataDiskSchema:    caching_type: str = field(        default=constants.DATADISK_CACHING_TYPE_NONE,        metadata=field_metadata(            validate=validate.OneOf(                [                    constants.DATADISK_CACHING_TYPE_NONE,                    constants.DATADISK_CACHING_TYPE_READONLY,                    constants.DATADISK_CACHING_TYPE_READYWRITE,                ]            )        ),    )    size: int = 32    iops: int = 0    throughput: int = 0  # MB/s    type: str = field(        default=schema.DiskType.StandardHDDLRS,        metadata=field_metadata(            validate=validate.OneOf(                [                    schema.DiskType.StandardHDDLRS,                    schema.DiskType.StandardSSDLRS,                    schema.DiskType.PremiumSSDLRS,                    schema.DiskType.UltraSSDLRS,                    schema.DiskType.Ephemeral,                ]            )        ),    )    create_option: str = field(        default=DataDiskCreateOption.DATADISK_CREATE_OPTION_TYPE_EMPTY,        metadata=field_metadata(            validate=validate.OneOf(DataDiskCreateOption.get_create_option())        ),    )@dataclass_json()@dataclassclass AvailabilityArmParameter:    availability_type: str = constants.AVAILABILITY_DEFAULT    availability_set_tags: Dict[str, str] = field(default_factory=dict)    availability_set_properties: Dict[str, Any] = field(default_factory=dict)    availability_zones: List[int] = field(default_factory=list)@dataclass_json()@dataclassclass AzureArmParameter:    storage_name: str = ""    vhd_storage_name: str = ""    location: str = ""    admin_username: str = ""    admin_password: str = ""    admin_key_data: str = ""    subnet_count: int = 1    availability_options: AvailabilityArmParameter = field(        default_factory=AvailabilityArmParameter    )    shared_resource_group_name: str = AZURE_SHARED_RG_NAME    nodes: List[AzureNodeArmParameter] = field(default_factory=list)    data_disks: List[DataDiskSchema] = field(default_factory=list)    vm_tags: Dict[str, Any] = field(default_factory=dict)    virtual_network_resource_group: str = ""    virtual_network_name: str = AZURE_VIRTUAL_NETWORK_NAME    subnet_prefix: str = AZURE_SUBNET_PREFIX    is_ultradisk: bool = False    def __post_init__(self, *args: Any, **kwargs: Any) -> None:        add_secret(self.admin_username, PATTERN_HEADTAIL)        add_secret(self.admin_password)        add_secret(self.admin_key_data)def get_compute_client(    platform: "AzurePlatform",    api_version: Optional[str] = None,    subscription_id: str = "",) -> ComputeManagementClient:    if not subscription_id:        subscription_id = platform.subscription_id    return ComputeManagementClient(        credential=platform.credential,        subscription_id=subscription_id,        api_version=api_version,        base_url=platform.cloud.endpoints.resource_manager,        credential_scopes=[platform.cloud.endpoints.resource_manager + "/.default"],    )def create_update_private_endpoints(    platform: "AzurePlatform",    resource_group_name: str,    location: str,    subnet_id: str,    private_link_service_id: str,    group_ids: List[str],    log: Logger,) -> Any:    network = get_network_client(platform)    private_endpoint_name = "pe_test"    status = "Approved"    description = "Auto-Approved"    private_endpoint = network.private_endpoints.begin_create_or_update(        resource_group_name=resource_group_name,        private_endpoint_name=private_endpoint_name,        parameters=PrivateEndpoint(            location=location,            subnet=Subnet(id=subnet_id),            private_link_service_connections=[                PrivateLinkServiceConnection(                    name=private_endpoint_name,                    private_link_service_id=private_link_service_id,                    group_ids=group_ids,                    private_link_service_connection_state=(                        PrivateLinkServiceConnectionState(                            status=status, description=description                        )                    ),                )            ],        ),    )    log.debug(f"create private endpoints: {private_endpoint_name}")    result = private_endpoint.result()    return result.custom_dns_configs[0].ip_addresses[0]def delete_private_endpoints(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> None:    network = get_network_client(platform)    private_endpoint_name = "pe_test"    try:        network.private_endpoints.get(            resource_group_name=resource_group_name,            private_endpoint_name=private_endpoint_name,        )        log.debug(f"found private endpoints: {private_endpoint_name}")        network.private_endpoints.begin_delete(            resource_group_name=resource_group_name,            private_endpoint_name=private_endpoint_name,        )        log.debug(f"delete private endpoints: {private_endpoint_name}")    except Exception:        log.debug(f"not find private endpoints: {private_endpoint_name}")def get_private_dns_management_client(    platform: "AzurePlatform",) -> PrivateDnsManagementClient:    return PrivateDnsManagementClient(        credential=platform.credential,        subscription_id=platform.subscription_id,        base_url=platform.cloud.endpoints.resource_manager,        credential_scopes=[platform.cloud.endpoints.resource_manager + "/.default"],    )def create_update_private_zones(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> Any:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    private_zone_location = "global"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    private_zones = private_dns_client.private_zones.begin_create_or_update(        resource_group_name=resource_group_name,        private_zone_name=private_zone_name,        parameters=PrivateZone(location=private_zone_location),  # or Private    )    log.debug(f"create private zone: {private_zone_name}")    result = private_zones.result()    return result.iddef delete_private_zones(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> None:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    try:        private_dns_client.private_zones.get(            resource_group_name=resource_group_name,            private_zone_name=private_zone_name,        )        log.debug(f"found private zone: {private_zone_name}")        timer = create_timer()        while timer.elapsed(False) < 60:            try:                private_dns_client.private_zones.begin_delete(                    resource_group_name=resource_group_name,                    private_zone_name=private_zone_name,                )                log.debug(f"delete private zone: {private_zone_name}")                break            except Exception as identifier:                if (                    "Can not delete resource before nested resources are deleted"                    in str(identifier)                ):                    sleep(1)                    continue    except Exception:        log.debug(f"not find private zone: {private_zone_name}")def create_update_record_sets(    platform: "AzurePlatform",    resource_group_name: str,    ipv4_address: str,    log: Logger,) -> None:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    relative_record_set_name = "privatelink"    record_type = "A"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    private_dns_client.record_sets.create_or_update(        resource_group_name=resource_group_name,        private_zone_name=private_zone_name,        relative_record_set_name=relative_record_set_name,        record_type=record_type,        parameters=RecordSet(ttl=10, a_records=[ARecord(ipv4_address=ipv4_address)]),    )    log.debug(f"create record sets: {relative_record_set_name}")def delete_record_sets(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> None:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    relative_record_set_name = "privatelink"    record_type = "A"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    try:        private_dns_client.record_sets.get(            resource_group_name=resource_group_name,            private_zone_name=private_zone_name,            relative_record_set_name=relative_record_set_name,            record_type=record_type,        )        log.debug(f"found record sets: {relative_record_set_name}")        private_dns_client.record_sets.delete(            resource_group_name=resource_group_name,            private_zone_name=private_zone_name,            relative_record_set_name=relative_record_set_name,            record_type=record_type,        )        log.debug(f"delete record sets: {relative_record_set_name}")    except Exception:        log.debug(f"not find record sets: {relative_record_set_name}")def create_update_virtual_network_links(    platform: "AzurePlatform",    resource_group_name: str,    virtual_network_resource_id: str,    log: Logger,) -> None:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    virtual_network_link_name = "vnetlink"    registration_enabled = False    virtual_network_link_location = "global"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    private_dns_client.virtual_network_links.begin_create_or_update(        resource_group_name=resource_group_name,        private_zone_name=private_zone_name,        virtual_network_link_name=virtual_network_link_name,        parameters=VirtualNetworkLink(            registration_enabled=registration_enabled,            location=virtual_network_link_location,            virtual_network=SubResource(id=virtual_network_resource_id),        ),    )    log.debug(f"create virtual network link: {virtual_network_link_name}")def delete_virtual_network_links(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> None:    private_dns_client = get_private_dns_management_client(platform)    private_zone_name = "privatelink"    virtual_network_link_name = "vnetlink"    private_zone_name = ".".join(        [private_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    try:        private_dns_client.virtual_network_links.get(            resource_group_name=resource_group_name,            private_zone_name=private_zone_name,            virtual_network_link_name=virtual_network_link_name,        )        log.debug(f"find virtual network link: {virtual_network_link_name}")        private_dns_client.virtual_network_links.begin_delete(            resource_group_name=resource_group_name,            private_zone_name=private_zone_name,            virtual_network_link_name=virtual_network_link_name,        )        log.debug(f"delete virtual network link: {virtual_network_link_name}")    except Exception:        log.debug(f"not find virtual network link: {virtual_network_link_name}")def create_update_private_dns_zone_groups(    platform: "AzurePlatform",    resource_group_name: str,    private_dns_zone_id: str,    log: Logger,) -> None:    network_client = get_network_client(platform)    private_dns_zone_group_name = "default"    private_endpoint_name = "pe_test"    private_dns_zone_name = "privatelink"    private_dns_zone_name = ".".join(        [private_dns_zone_name, "file", platform.cloud.suffixes.storage_endpoint]    )    # network_client.private_dns_zone_groups.delete()    network_client.private_dns_zone_groups.begin_create_or_update(        resource_group_name=resource_group_name,        private_dns_zone_group_name=private_dns_zone_group_name,        private_endpoint_name=private_endpoint_name,        parameters=PrivateDnsZoneGroup(            name=private_dns_zone_group_name,            private_dns_zone_configs=[                PrivateDnsZoneConfig(                    name=private_dns_zone_name,                    private_dns_zone_id=private_dns_zone_id,                )            ],        ),    )    log.debug(f"create private dns zone group: {private_dns_zone_group_name}")def delete_private_dns_zone_groups(    platform: "AzurePlatform",    resource_group_name: str,    log: Logger,) -> None:    network_client = get_network_client(platform)    private_dns_zone_group_name = "default"    private_endpoint_name = "pe_test"    try:        network_client.private_dns_zone_groups.get(            resource_group_name=resource_group_name,            private_endpoint_name=private_endpoint_name,            private_dns_zone_group_name=private_dns_zone_group_name,        )        log.debug(f"found private dns zone group: {private_dns_zone_group_name}")        network_client.private_dns_zone_groups.begin_delete(            resource_group_name=resource_group_name,            private_endpoint_name=private_endpoint_name,            private_dns_zone_group_name=private_dns_zone_group_name,        )        log.debug(f"delete private dns zone group: {private_dns_zone_group_name}")    except Exception:        log.debug(f"not find private dns zone group: {private_dns_zone_group_name}")def get_virtual_networks(    platform: "AzurePlatform", resource_group_name: str) -> Dict[str, List[str]]:    network_client = get_network_client(platform)    virtual_networks_list = network_client.virtual_networks.list(        resource_group_name=resource_group_name    )    virtual_network_dict: Dict[str, List[str]] = {}    for virtual_network in virtual_networks_list:        virtual_network_dict[virtual_network.id] = [            x.id for x in virtual_network.subnets        ]    return virtual_network_dictdef get_network_client(platform: "AzurePlatform") -> NetworkManagementClient:    return NetworkManagementClient(        credential=platform.credential,        subscription_id=platform.subscription_id,        base_url=platform.cloud.endpoints.resource_manager,        credential_scopes=[platform.cloud.endpoints.resource_manager + "/.default"],    )def get_storage_client(    credential: Any, subscription_id: str, cloud: Cloud) -> StorageManagementClient:    return StorageManagementClient(        credential=credential,        subscription_id=subscription_id,        base_url=cloud.endpoints.resource_manager,        credential_scopes=[cloud.endpoints.resource_manager + "/.default"],    )def get_resource_management_client(    credential: Any, subscription_id: str, cloud: Cloud) -> ResourceManagementClient:    return ResourceManagementClient(        credential=credential,        subscription_id=subscription_id,        base_url=cloud.endpoints.resource_manager,        credential_scopes=[cloud.endpoints.resource_manager + "/.default"],    )def get_managed_service_identity_client(    platform: "AzurePlatform",    subscription_id: str = "",) -> ManagedServiceIdentityClient:    if not subscription_id:        subscription_id = platform.subscription_id    return ManagedServiceIdentityClient(        credential=platform.credential,        subscription_id=subscription_id,        base_url=platform.cloud.endpoints.resource_manager,        credential_scopes=[platform.cloud.endpoints.resource_manager + "/.default"],    )def get_storage_account_name(    subscription_id: str, location: str, type_: str = "s") -> str:    subscription_id_postfix = subscription_id[-8:]    # name should be shorter than 24 character    return f"lisa{type_}{location[:11]}{subscription_id_postfix}"def get_marketplace_ordering_client(    platform: "AzurePlatform",) -> MarketplaceOrderingAgreements:    return MarketplaceOrderingAgreements(        credential=platform.credential,        subscription_id=platform.subscription_id,        base_url=platform.cloud.endpoints.resource_manager,        credential_scopes=[platform.cloud.endpoints.resource_manager + "/.default"],    )def get_node_context(node: Node) -> NodeContext:    return node.get_context(NodeContext)def get_environment_context(environment: Environment) -> EnvironmentContext:    return environment.get_context(EnvironmentContext)def wait_operation(    operation: Any, time_out: int = sys.maxsize, failure_identity: str = "") -> Any:    timer = create_timer()    wait_result: Any = None    if failure_identity:        failure_identity = f"{failure_identity} failed:"    else:        failure_identity = "Azure operation failed:"    while time_out > timer.elapsed(False):        check_cancelled()        if operation.done():            break        wait_result = operation.wait(1)        if wait_result:            raise LisaException(f"{failure_identity} {wait_result}")    if time_out < timer.elapsed():        raise LisaTimeoutException(            f"{failure_identity} timeout after {time_out} seconds."        )    result = operation.result()    if result:        result = result.as_dict()    return resultdef get_storage_credential(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,) -> Any:    """    return a shared key credential. This credential doesn't need extra     permissions to access blobs.    """    storage_client = get_storage_client(credential, subscription_id, cloud)    key = storage_client.storage_accounts.list_keys(        account_name=account_name, resource_group_name=resource_group_name    ).keys[0]    return {"account_name": account_name, "account_key": key.value}def generate_blob_sas_token(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,    container_name: str,    file_name: str,    expired_hours: int = 2,) -> Any:    shared_key_credential = get_storage_credential(        credential=credential,        subscription_id=subscription_id,        cloud=cloud,        account_name=account_name,        resource_group_name=resource_group_name,    )    sas_token = generate_blob_sas(        account_name=shared_key_credential["account_name"],        account_key=shared_key_credential["account_key"],        container_name=container_name,        blob_name=file_name,        permission=BlobSasPermissions(read=True),  # type: ignore        expiry=datetime.utcnow() + timedelta(hours=expired_hours),    )    return sas_tokendef generate_sas_token(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,    expired_hours: int = 2,    writable: bool = False,) -> Any:    shared_key_credential = get_storage_credential(        credential=credential,        cloud=cloud,        subscription_id=subscription_id,        account_name=account_name,        resource_group_name=resource_group_name,    )    resource_types = ResourceTypes(  # type: ignore        service=True, container=True, object=True    )    sas_token = generate_account_sas(        account_name=shared_key_credential["account_name"],        account_key=shared_key_credential["account_key"],        resource_types=resource_types,        permission=AccountSasPermissions(read=True, write=writable),  # type: ignore        expiry=datetime.utcnow() + timedelta(hours=expired_hours),    )    return sas_tokendef get_blob_service_client(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,) -> BlobServiceClient:    """    Create a Azure Storage container if it does not exist.    """    shared_key_credential = get_storage_credential(        credential=credential,        subscription_id=subscription_id,        cloud=cloud,        account_name=account_name,        resource_group_name=resource_group_name,    )    blob_service_client = BlobServiceClient(        f"https://{account_name}.blob.{cloud.suffixes.storage_endpoint}",        shared_key_credential,    )    return blob_service_clientdef get_or_create_storage_container(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    container_name: str,    resource_group_name: str,) -> ContainerClient:    """    Create a Azure Storage container if it does not exist.    """    blob_service_client = get_blob_service_client(        credential,        subscription_id,        cloud,        account_name,        resource_group_name,    )    container_client = blob_service_client.get_container_client(container_name)    if not container_client.exists():        container_client.create_container()    return container_clientdef check_or_create_storage_account(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,    location: str,    log: Logger,    sku: str = "Standard_LRS",    kind: str = "StorageV2",    enable_https_traffic_only: bool = True,) -> None:    # check and deploy storage account.    # storage account can be deployed inside of arm template, but if the concurrent    # is too big, Azure may not able to delete deployment script on time. so there    # will be error like below    # Creating the deployment 'name' would exceed the quota of '800'.    storage_client = get_storage_client(credential, subscription_id, cloud)    with _global_storage_account_check_create_lock:        try:            storage_client.storage_accounts.get_properties(                account_name=account_name,                resource_group_name=resource_group_name,            )            log.debug(f"found storage account: {account_name}")        except Exception:            log.debug(f"creating storage account: {account_name}")            parameters = StorageAccountCreateParameters(                sku=Sku(name=sku),                kind=kind,                location=location,                enable_https_traffic_only=enable_https_traffic_only,            )            operation = storage_client.storage_accounts.begin_create(                resource_group_name=resource_group_name,                account_name=account_name,                parameters=parameters,            )            wait_operation(operation)def delete_storage_account(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,    log: Logger,) -> None:    storage_client = get_storage_client(credential, subscription_id, cloud)    try:        storage_client.storage_accounts.get_properties(            account_name=account_name,            resource_group_name=resource_group_name,        )        log.debug(f"found storage account: {account_name}")        storage_client.storage_accounts.delete(            account_name=account_name,            resource_group_name=resource_group_name,        )        log.debug(f"delete storage account: {account_name}")    except Exception:        log.debug(f"not find storage account: {account_name}")def check_or_create_resource_group(    credential: Any,    subscription_id: str,    cloud: Cloud,    resource_group_name: str,    location: str,    log: Logger,) -> None:    with get_resource_management_client(        credential, subscription_id, cloud    ) as rm_client:        with global_credential_access_lock:            az_shared_rg_exists = rm_client.resource_groups.check_existence(                resource_group_name            )        if not az_shared_rg_exists:            log.info(f"Creating Resource group: '{resource_group_name}'")            with global_credential_access_lock:                rm_client.resource_groups.create_or_update(                    resource_group_name, {"location": location}                )            check_till_timeout(                lambda: rm_client.resource_groups.check_existence(resource_group_name)                is True,                timeout_message=f"wait for {resource_group_name} created",            )def copy_vhd_to_storage(    platform: "AzurePlatform",    storage_name: str,    src_vhd_sas_url: str,    dst_vhd_name: str,    log: Logger,) -> str:    # get original vhd's hash key for comparing.    original_key: Optional[bytearray] = None    original_blob_client = BlobClient.from_blob_url(src_vhd_sas_url)    properties = original_blob_client.get_blob_properties()    if properties.content_settings:        original_key = properties.content_settings.get(            "content_md5", None        )  # type: ignore    container_client = get_or_create_storage_container(        credential=platform.credential,        subscription_id=platform.subscription_id,        cloud=platform.cloud,        account_name=storage_name,        container_name=SAS_COPIED_CONTAINER_NAME,        resource_group_name=platform._azure_runbook.shared_resource_group_name,    )    full_vhd_path = f"{container_client.url}/{dst_vhd_name}"    # lock here to prevent a vhd is copied in multi-thread    cached_key: Optional[bytearray] = None    with _global_sas_vhd_copy_lock:        blobs = container_client.list_blobs(name_starts_with=dst_vhd_name)        blob_client = container_client.get_blob_client(dst_vhd_name)        vhd_exists = False        for blob in blobs:            if blob:                # check if hash key matched with original key.                if blob.content_settings:                    cached_key = blob.content_settings.get(                        "content_md5", None                    )  # type: ignore                if is_stuck_copying(blob_client, log):                    # Delete the stuck vhd.                    blob_client.delete_blob(delete_snapshots="include")                elif original_key and cached_key:                    if original_key == cached_key:                        log.debug("the sas url is copied already, use it directly.")                        vhd_exists = True                    else:                        log.debug("found cached vhd, but the hash key mismatched.")                else:                    log.debug(                        "No md5 content either in original blob or current blob. "                        "Then no need to check the hash key"                    )                    vhd_exists = True        if not vhd_exists:            azcopy_path = platform._azure_runbook.azcopy_path            if azcopy_path:                log.info(f"AzCopy path: {azcopy_path}")                if not os.path.exists(azcopy_path):                    raise LisaException(f"{azcopy_path} does not exist")                sas_token = generate_sas_token(                    credential=platform.credential,                    subscription_id=platform.subscription_id,                    cloud=platform.cloud,                    account_name=storage_name,                    resource_group_name=platform._azure_runbook.shared_resource_group_name,  # noqa: E501                    writable=True,                )                dst_vhd_sas_url = f"{full_vhd_path}?{sas_token}"                log.info(f"copying vhd by azcopy {dst_vhd_name}")                try:                    local().execute(                        f"{azcopy_path} copy {src_vhd_sas_url} {dst_vhd_sas_url} --recursive=true",  # noqa: E501                        expected_exit_code=0,                        expected_exit_code_failure_message=(                            "Azcopy failed to copy the blob"                        ),                        timeout=60 * 60,                    )                except Exception as identifier:                    blob_client.delete_blob(delete_snapshots="include")                    raise LisaException(f"{identifier}")                # Set metadata to mark the blob copied by AzCopy successfully                metadata = {"AzCopyStatus": "Success"}                blob_client.set_blob_metadata(metadata)            else:                blob_client.start_copy_from_url(                    src_vhd_sas_url, metadata=None, incremental_copy=False                )        wait_copy_blob(blob_client, dst_vhd_name, log)    return full_vhd_pathdef wait_copy_blob(    blob_client: Any,    vhd_path: str,    log: Logger,    timeout: int = 60 * 60,) -> None:    log.info(f"copying vhd: {vhd_path}")    if blob_client.get_blob_properties().copy.status:        check_till_timeout(            lambda: blob_client.get_blob_properties().copy.status == "success",            timeout_message=f"copying VHD: {vhd_path}",            timeout=timeout,            interval=2,        )    else:        # If the blob is copied by AzCopy, the copy.status is None.        # Confirm the copy operation is success by checking the metadata.        check_till_timeout(            lambda: blob_client.get_blob_properties().metadata.get("AzCopyStatus", None)            == "Success",            timeout_message=f"copying VHD: {vhd_path}",            timeout=timeout,            interval=2,        )    log.info("vhd copied")def get_share_service_client(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    resource_group_name: str,) -> ShareServiceClient:    shared_key_credential = get_storage_credential(        credential=credential,        subscription_id=subscription_id,        cloud=cloud,        account_name=account_name,        resource_group_name=resource_group_name,    )    share_service_client = ShareServiceClient(        f"https://{account_name}.file.{cloud.suffixes.storage_endpoint}",        shared_key_credential,    )    return share_service_clientdef get_or_create_file_share(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    file_share_name: str,    resource_group_name: str,    log: Logger,    protocols: str = "SMB",) -> str:    """    Create a Azure Storage file share if it does not exist.    """    share_service_client = get_share_service_client(        credential,        subscription_id,        cloud,        account_name,        resource_group_name,    )    all_shares = list(share_service_client.list_shares())    if file_share_name not in (x.name for x in all_shares):        log.debug(f"creating file share {file_share_name} with protocols {protocols}")        share_service_client.create_share(file_share_name, protocols=protocols)    return str("//" + share_service_client.primary_hostname + "/" + file_share_name)def delete_file_share(    credential: Any,    subscription_id: str,    cloud: Cloud,    account_name: str,    file_share_name: str,    resource_group_name: str,    log: Logger,) -> None:    """    Delete Azure Storage file share    """    share_service_client = get_share_service_client(        credential,        subscription_id,        cloud,        account_name,        resource_group_name,    )    log.debug(f"deleting file share {file_share_name}")    share_service_client.delete_share(file_share_name)def save_console_log(    resource_group_name: str,    vm_name: str,    platform: "AzurePlatform",    log: Logger,    saved_path: Optional[Path],    screenshot_file_name: str = "serial_console",) -> bytes:    compute_client = get_compute_client(platform)    with global_credential_access_lock:        try:            diagnostic_data = (                compute_client.virtual_machines.retrieve_boot_diagnostics_data(                    resource_group_name=resource_group_name, vm_name=vm_name                )            )        except ResourceExistsError as identifier:            log.debug(f"fail to get serial console log. {identifier}")            return b""    if saved_path:        screenshot_raw_name = saved_path / f"{screenshot_file_name}.bmp"        screenshot_response = requests.get(            diagnostic_data.console_screenshot_blob_uri, timeout=60        )        screenshot_raw_name.write_bytes(screenshot_response.content)        try:            with Image.open(screenshot_raw_name) as image:                image.save(                    saved_path / f"{screenshot_file_name}.png", "PNG", optimize=True                )        except UnidentifiedImageError:            log.debug(                "The screenshot is not generated. "                "The reason may be the VM is not started."            )        screenshot_raw_name.unlink()    log_response = requests.get(diagnostic_data.serial_console_log_blob_uri, timeout=60)    if log_response.status_code == 404:        log.debug(            "The serial console is not generated. "            "The reason may be the VM is not started."        )    return log_response.contentdef load_environment(    platform: "AzurePlatform",    resource_group_name: str,    use_public_address: bool,    log: Logger,) -> Environment:    """    reverse load environment from a resource group.    """    # create mock environment from environments    environment_runbook = schema.Environment()    if environment_runbook.nodes_raw is None:        environment_runbook.nodes_raw = []    vms_map: Dict[str, VirtualMachine] = {}    compute_client = get_compute_client(platform)    vms = compute_client.virtual_machines.list(resource_group_name)    for vm in vms:        node_schema = schema.RemoteNode(name=vm.name)        environment_runbook.nodes_raw.append(node_schema)        vms_map[vm.name] = vm    environments = load_environments(        schema.EnvironmentRoot(environments=[environment_runbook])    )    environment = next(x for x in environments.values())    platform_runbook: schema.Platform = platform.runbook    for node in environment.nodes.list():        assert isinstance(node, RemoteNode)        vm = vms_map.get(node.name)        assert_that(vm).described_as(            f"Cannot find vm with name {node.name}. Make sure the VM exists in "            f"resource group {resource_group_name}"        ).is_not_none()        node_context = get_node_context(node)        node_context.vm_name = node.name        node_context.resource_group_name = resource_group_name        node_context.username = platform_runbook.admin_username        node_context.password = platform_runbook.admin_password        node_context.private_key_file = platform_runbook.admin_private_key_file        node_context.location = vm.location        node_context.subscription_id = platform.subscription_id        (            node_context.public_ip_address,            node_context.private_ip_address,        ) = get_primary_ip_addresses(            platform, resource_group_name, vms_map[node_context.vm_name]        )        node_context.use_public_address = use_public_address        node.set_connection_info(            address=node_context.private_ip_address,            use_public_address=node_context.use_public_address,            public_address=node_context.public_ip_address,            username=node_context.username,            password=node_context.password,            private_key_file=node_context.private_key_file,        )        node.features = Features(node, platform)    environment_context = get_environment_context(environment)    environment_context.resource_group_is_specified = False    environment_context.resource_group_name = resource_group_name    platform.initialize_environment(environment, log)    return environmentdef get_vm(platform: "AzurePlatform", node: Node) -> Any:    context = node.get_context(NodeContext)    compute_client = get_compute_client(platform=platform)    vm = compute_client.virtual_machines.get(        context.resource_group_name, context.vm_name    )    return vm@retry(exceptions=LisaException, tries=150, delay=2)def get_primary_ip_addresses(    platform: "AzurePlatform", resource_group_name: str, vm: VirtualMachine) -> Tuple[str, str]:    network_client = get_network_client(platform)    assert vm.network_profile, "no network profile found"    assert isinstance(        vm.network_profile.network_interfaces, List    ), f"actual: {type(vm.network_profile.network_interfaces)}"    for network_interface in vm.network_profile.network_interfaces:        assert isinstance(            network_interface.id, str        ), f"actual: {type(network_interface.id)}"        nic_name = get_matched_str(network_interface.id, NIC_NAME_PATTERN)        nic = network_client.network_interfaces.get(resource_group_name, nic_name)        if nic.primary:            if not nic.ip_configurations[0].public_ip_address:                raise LisaException(f"no public address found in nic {nic.name}")            public_ip_name = get_matched_str(                nic.ip_configurations[0].public_ip_address.id, PATTERN_PUBLIC_IP_NAME            )            public_ip_address = network_client.public_ip_addresses.get(                resource_group_name,                public_ip_name,            )            return (                public_ip_address.ip_address,                nic.ip_configurations[0].private_ip_address,            )    raise LisaException(f"fail to find primary nic for vm {vm.name}")# find resource based on type name from resources section in arm templatedef find_by_name(resources: Any, type_name: str) -> Any:    return next(x for x in resources if x["type"] == type_name)def get_vhd_details(platform: "AzurePlatform", vhd_path: str) -> Any:    matched = STORAGE_CONTAINER_BLOB_PATTERN.match(vhd_path)    assert matched, f"fail to get matched info from {vhd_path}"    sc_name = matched.group("sc")    container_name = matched.group("container")    blob_name = matched.group("blob")    storage_client = get_storage_client(        platform.credential, platform.subscription_id, platform.cloud    )    # sometimes it will fail for below reason if list storage accounts like this way    # [x for x in storage_client.storage_accounts.list() if x.name == sc_name]    # failure - Message: Resource provider 'Microsoft.Storage' failed to return collection response for type 'storageAccounts'.  # noqa: E501    sc_list = storage_client.storage_accounts.list()    found_sc = None    for sc in sc_list:        if sc.name == sc_name:            found_sc = sc            break    assert (        found_sc    ), f"storage account {sc_name} not found in subscription {platform.subscription_id}"    rg = get_matched_str(found_sc.id, RESOURCE_GROUP_PATTERN)    return {        "location": found_sc.location,        "resource_group_name": rg,        "account_name": sc_name,        "container_name": container_name,        "blob_name": blob_name,    }def _generate_sas_token_for_vhd(    platform: "AzurePlatform", result_dict: Dict[str, str]) -> Any:    sc_name = result_dict["account_name"]    container_name = result_dict["container_name"]    rg = result_dict["resource_group_name"]    blob_name = result_dict["blob_name"]    source_container_client = get_or_create_storage_container(        credential=platform.credential,        subscription_id=platform.subscription_id,        cloud=platform.cloud,        account_name=sc_name,        container_name=container_name,        resource_group_name=rg,    )    source_blob = source_container_client.get_blob_client(blob_name)    sas_token = generate_sas_token(        credential=platform.credential,        subscription_id=platform.subscription_id,        cloud=platform.cloud,        account_name=sc_name,        resource_group_name=rg,    )    source_url = source_blob.url + "?" + sas_token    return source_url@lru_cache(maxsize=10)  # noqa: B019def get_deployable_vhd_path(    platform: "AzurePlatform", vhd_path: str, location: str, log: Logger) -> str:    """    The sas url is not able to create a vm directly, so this method check if    the vhd_path is a sas url. If so, copy it to a location in current    subscription, so it can be deployed.    """    matches = SAS_URL_PATTERN.match(vhd_path)    if not matches:        vhd_details = get_vhd_details(platform, vhd_path)        vhd_location = vhd_details["location"]        if location == vhd_location:            return vhd_path        else:            vhd_path = _generate_sas_token_for_vhd(platform, vhd_details)            matches = SAS_URL_PATTERN.match(vhd_path)            assert matches, f"fail to generate sas url for {vhd_path}"            log.debug(                f"the vhd location {location} is not same with running case "                f"location {vhd_location}, generate a sas url for source vhd, "                f"it needs to be copied into location {location}."            )    else:        log.debug("found the vhd is a sas url, it may need to be copied.")    original_vhd_path = vhd_path    storage_name = get_storage_account_name(        subscription_id=platform.subscription_id, location=location, type_="t"    )    check_or_create_storage_account(        platform.credential,        platform.subscription_id,        platform.cloud,        storage_name,        platform._azure_runbook.shared_resource_group_name,        location,        log,    )    normalized_vhd_name = constants.NORMALIZE_PATTERN.sub("-", vhd_path)    year = matches["year"] if matches["year"] else "9999"    month = matches["month"] if matches["month"] else "01"    day = matches["day"] if matches["day"] else "01"    # use the expire date to generate the path. It's easy to identify when    # the cache can be removed.    vhd_path = f"{year}{month}{day}/{normalized_vhd_name}.vhd"    full_vhd_path = copy_vhd_to_storage(        platform, storage_name, original_vhd_path, vhd_path, log    )    log.debug(        f"deployable vhd is cached at: {full_vhd_path}. "        f"original vhd url: {original_vhd_path}"    )    # Add substitutes for these normalized vhd names. Replace them with the original    # vhd name without SAS when printing    # e.g.    # full_vhd_path: https://lisatwestus3xx.blob.core.windows.net/lisa-sas-copied/99990101/https---userstorageaccount-blob-core-windows-net-vhds-fortinet-blob-6-7-4-vhd-sv-2019-xx.vhd  # noqa: E501    # replace it with: https://userstorageaccount.blob.core.windows.net/vhds/fortinet/blob-6.7.4.vhd?***  # noqa: E501    # vhd_path: 99990101/https---userstorageaccount-blob-core-windows-net-vhds-fortinet-blob-6-7-4-vhd-sv-2019-xx.vhd  # noqa: E501    # replace it with: fortinet/blob-6.7.4.vhd    original_vhd_path_without_sas = replace(original_vhd_path, mask=PATTERN_URL)    add_secret(        vhd_path,        sub="/".join(original_vhd_path_without_sas.split("/")[4:]).rstrip("?*"),    )    add_secret(full_vhd_path, sub=original_vhd_path_without_sas)    # In the returned message from Azure when creating VM, the blob url might contain    # the default blob port 8443, so also add substitute for the vhd path with 8443 port    full_vhd_path_with_port = "/".join(        x + ":8443" if i == 2 else x for i, x in enumerate(full_vhd_path.split("/"))    )    add_secret(full_vhd_path_with_port, sub=original_vhd_path_without_sas)    return full_vhd_pathdef is_stuck_copying(blob_client: BlobClient, log: Logger) -> bool:    props = blob_client.get_blob_properties()    copy_status = props.copy.status    if copy_status == "pending":        if props.creation_time:            delta_hours = (datetime.now(timezone.utc) - props.creation_time).seconds / (                60 * 60            )        else:            delta_hours = 0        if delta_hours > BLOB_COPY_PENDING_TIMEOUT_HOURS:            log.debug(                "the blob is pending more than "                f"{BLOB_COPY_PENDING_TIMEOUT_HOURS} hours."            )            return True    return Falsedef check_or_create_gallery(    platform: "AzurePlatform",    gallery_resource_group_name: str,    gallery_name: str,    gallery_location: str = "",    gallery_description: str = "",) -> Any:    try:        # get gallery        compute_client = get_compute_client(platform)        gallery = compute_client.galleries.get(            resource_group_name=gallery_resource_group_name,            gallery_name=gallery_name,        )    except Exception as ex:        # create the gallery if specified gallery name doesn't exist        if "ResourceNotFound" in str(ex):            gallery_post_body = {                "location": gallery_location,                "description": gallery_description,            }            operation = compute_client.galleries.begin_create_or_update(                gallery_resource_group_name,                gallery_name,                gallery_post_body,            )            gallery = wait_operation(operation)        else:            raise LisaException(ex)    return gallerydef check_or_create_gallery_image(    platform: "AzurePlatform",    gallery_resource_group_name: str,    gallery_name: str,    gallery_image_name: str,    gallery_image_location: str,    gallery_image_publisher: str,    gallery_image_offer: str,    gallery_image_sku: str,    gallery_image_ostype: str,    gallery_image_osstate: str,    gallery_image_hyperv_generation: int,    gallery_image_architecture: str,    gallery_image_securitytype: str,) -> None:    try:        compute_client = get_compute_client(platform)        compute_client.gallery_images.get(            gallery_resource_group_name,            gallery_name,            gallery_image_name,        )    except Exception as ex:        # create the gallery image if specified gallery name doesn't exist        if "ResourceNotFound" in str(ex):            image_post_body: Dict[str, Any] = {}            image_post_body = {                "location": gallery_image_location,                "os_type": gallery_image_ostype,                "os_state": gallery_image_osstate,                "hyper_v_generation": f"V{gallery_image_hyperv_generation}",                "architecture": gallery_image_architecture,                "identifier": {                    "publisher": gallery_image_publisher,                    "offer": gallery_image_offer,                    "sku": gallery_image_sku,                },            }            if gallery_image_securitytype:                image_post_body["features"] = [                    {                        "name": "SecurityType",                        "value": gallery_image_securitytype,                    }                ]            operation = compute_client.gallery_images.begin_create_or_update(                gallery_resource_group_name,                gallery_name,                gallery_image_name,                image_post_body,            )            wait_operation(operation)        else:            raise LisaException(ex)def check_or_create_gallery_image_version(    platform: "AzurePlatform",    gallery_resource_group_name: str,    gallery_name: str,    gallery_image_name: str,    gallery_image_version: str,    gallery_image_location: str,    regional_replica_count: int,    storage_account_type: str,    host_caching_type: str,    vhd_path: str,    vhd_resource_group_name: str,    vhd_storage_account_name: str,    gallery_image_target_regions: List[str],) -> None:    try:        compute_client = get_compute_client(platform)        compute_client.gallery_image_versions.get(            gallery_resource_group_name,            gallery_name,            gallery_image_name,            gallery_image_version,        )    except Exception as ex:        # create the gallery if specified gallery name doesn't exist        if "ResourceNotFound" in str(ex):            target_regions: List[Dict[str, str]] = []            for target_region in gallery_image_target_regions:                target_regions.append(                    {                        "name": target_region,                        "regional_replica_count": str(regional_replica_count),                        "storage_account_type": storage_account_type,                    }                )            image_version_post_body = {                "location": gallery_image_location,                "publishing_profile": {"target_regions": target_regions},                "storageProfile": {                    "osDiskImage": {                        "hostCaching": host_caching_type,                        "source": {                            "uri": vhd_path,                            "id": (                                f"/subscriptions/{platform.subscription_id}/"                                f"resourceGroups/{vhd_resource_group_name}"                                "/providers/Microsoft.Storage/storageAccounts/"                                f"{vhd_storage_account_name}"                            ),                        },                    },                },            }            operation = compute_client.gallery_image_versions.begin_create_or_update(                gallery_resource_group_name,                gallery_name,                gallery_image_name,                gallery_image_version,                image_version_post_body,            )            wait_operation(operation)        else:            raise LisaException(ex)def check_blob_exist(    platform: "AzurePlatform",    account_name: str,    container_name: str,    resource_group_name: str,    blob_name: str,) -> bool:    container_client = get_or_create_storage_container(        credential=platform.credential,        subscription_id=platform.subscription_id,        cloud=platform.cloud,        account_name=account_name,        container_name=container_name,        resource_group_name=resource_group_name,    )    blob_client = container_client.get_blob_client(blob_name)    return blob_client.exists()class DataDisk:    # refer https://docs.microsoft.com/en-us/azure/virtual-machines/disks-types    IOPS_SIZE_DICT: Dict[schema.DiskType, Dict[int, int]] = {        schema.DiskType.PremiumSSDLRS: {            120: 4,            240: 64,            500: 128,            1100: 256,            2300: 512,            5000: 1024,            7500: 2048,            16000: 8192,            18000: 16384,            20000: 32767,        },        schema.DiskType.StandardHDDLRS: {            500: 32,            1300: 8192,            2000: 16384,        },        schema.DiskType.StandardSSDLRS: {            500: 4,            2000: 8192,            4000: 16384,            6000: 32767,        },    }    @staticmethod    def get_size(disk_type: schema.DiskType, data_disk_iops: int = 1) -> int:        if disk_type in [            schema.DiskType.PremiumSSDLRS,            schema.DiskType.StandardHDDLRS,            schema.DiskType.StandardSSDLRS,        ]:            iops_dict = DataDisk.IOPS_SIZE_DICT[disk_type]            iops = [key for key in iops_dict.keys() if key >= data_disk_iops]            if not iops:                raise LisaException(                    f"IOPS {data_disk_iops} is invalid for disk type {disk_type}."                )            min_iops = min(iops)            return iops_dict[min_iops]        else:            raise LisaException(f"Data disk type {disk_type} is unsupported.")def get_certificate_client(    vault_url: str, platform: "AzurePlatform") -> CertificateClient:    return CertificateClient(vault_url, platform.credential)def get_secret_client(vault_url: str, platform: "AzurePlatform") -> SecretClient:    return SecretClient(vault_url, platform.credential)def get_key_vault_management_client(    platform: "AzurePlatform",) -> KeyVaultManagementClient:    return KeyVaultManagementClient(platform.credential, platform.subscription_id)def get_tenant_id(credential: Any) -> Any:    # Initialize the Subscription client    subscription_client = SubscriptionClient(credential)    # Get the subscription    subscription = next(subscription_client.subscriptions.list())    return subscription.tenant_iddef get_azurevm_metadata() -> Any:    headers = {"Metadata": "true"}    try:        response = requests.get(METADATA_ENDPOINT, headers=headers, timeout=10)        response.raise_for_status()        metadata = response.json()        return metadata    except Exception:        return ""def get_azurevm_name() -> str:    meta_data = get_azurevm_metadata()    if meta_data:        return str(meta_data["compute"]["name"])    else:        return ""def get_resource_group_name() -> str:    meta_data = get_azurevm_metadata()    if meta_data:        return str(meta_data["compute"]["resourceGroupName"])    else:        return ""def get_managed_identity_object_id(    platform: "AzurePlatform", resource_group_name: str, vm_name: str) -> str:    compute_client = get_compute_client(        platform, subscription_id=platform.subscription_id    )    vm_identity = compute_client.virtual_machines.get(        resource_group_name, vm_name    ).identity    user_assigned_identity_resource_id = ""    # Check if the VM has user-assigned managed identity    if vm_identity and vm_identity.type == "UserAssigned":        user_assigned_identity_id = vm_identity.user_assigned_identities        if user_assigned_identity_id:            # Iterate over user-assigned identities            for _, identity_value in user_assigned_identity_id.items():                user_assigned_identity_resource_id = identity_value.principal_id            if user_assigned_identity_resource_id:                return user_assigned_identity_resource_id    # Check if the VM has system-assigned managed identity    if vm_identity and vm_identity.type == "SystemAssigned":        return str(vm_identity.principal_id)    return ""def get_identity_id(    platform: "AzurePlatform", application_id: Optional[str] = None) -> Any:    if not application_id:        # if the run machine resides on Azure        # get the object ID of the managed identity        if get_resource_group_name() and get_azurevm_name():            object_id = get_managed_identity_object_id(                platform, get_resource_group_name(), get_azurevm_name()            )            if object_id:                return object_id    base_url = "https://graph.microsoft.com/"    api_version = "v1.0"    # If application_id is not provided or is None, use /me endpoint    if application_id:        endpoint = f"servicePrincipals(appId='{application_id}')"    else:        endpoint = "me"    graph_api_url = f"{base_url}{api_version}/{endpoint}"    token = platform.credential.get_token("https://graph.microsoft.com/.default").token    # Set up the API call headers    headers = {        "Authorization": f"Bearer {token}",        "Content-Type": "application/json",    }    # Set a timeout of 10 seconds for the request    response = requests.get(graph_api_url, headers=headers, timeout=10)    if response.status_code != 200:        raise LisaException(            f"Failed to retrieve user object ID. "            f"Status code: {response.status_code}. "            f"Response: {response.text}"        )    return response.json().get("id")def add_system_assign_identity(    platform: "AzurePlatform",    resource_group_name: str,    vm_name: str,    location: str,    log: Logger,) -> Any:    compute_client = get_compute_client(platform)    params_identity = {"type": "SystemAssigned"}    params_create = {"location": location, "identity": params_identity}    vm_poller = compute_client.virtual_machines.begin_update(        resource_group_name,        vm_name,        params_create,    )    vm_result = vm_poller.result()    object_id_vm = vm_result.identity.principal_id    log.debug(f"VM object ID assigned: {object_id_vm}")    if not object_id_vm:        raise ValueError(            "Cannot retrieve managed identity after set system assigned identity on vm"        )    return object_id_vmdef add_user_assign_identity(    platform: "AzurePlatform",    resource_group_name: str,    vm_name: str,    identify_id: str,    log: Logger,) -> None:    compute_client = get_compute_client(platform)    identity: Dict[str, Any] = {identify_id: {}}    params_identity = {"type": "UserAssigned", "userAssignedIdentities": identity}    params_create = {"identity": params_identity}    operation = compute_client.virtual_machines.begin_update(        resource_group_name,        vm_name,        params_create,    )    wait_operation(operation)    log.debug(f"{identify_id} is assigned to vm {vm_name} successfully")def add_tag_for_vm(    platform: "AzurePlatform",    resource_group_name: str,    vm_name: str,    tag: Dict[str, str],    log: Logger,) -> None:    compute_client = get_compute_client(platform)    vm = compute_client.virtual_machines.get(resource_group_name, vm_name)    vm.tags.update(tag)    params = {"tags": vm.tags}    operation = compute_client.virtual_machines.begin_update(        resource_group_name,        vm_name,        params,    )    wait_operation(operation)    log.debug(f"tag: {tag} has been added in {vm_name} successfully")def get_matching_key_vault_name(    platform: "AzurePlatform",    location: str,    resource_group: str,    pattern: str = ".*",) -> Any:    """    Get the name of a Key Vault that exists in a specific region and resource group    and matches the given pattern.    """    key_vault_client = get_key_vault_management_client(platform)    key_vaults = key_vault_client.vaults.list_by_resource_group(resource_group)    for vault in key_vaults:        if vault.location == location:            if re.fullmatch(pattern, vault.name):                return vault.name    return Nonedef create_keyvault(    platform: "AzurePlatform",    location: str,    vault_name: str,    resource_group_name: str,    vault_properties: VaultProperties,) -> Any:    keyvault_client = get_key_vault_management_client(platform)    parameters = VaultCreateOrUpdateParameters(        location=location, properties=vault_properties    )    keyvault_poller = keyvault_client.vaults.begin_create_or_update(        resource_group_name, vault_name, parameters    )    return keyvault_poller.result()def assign_access_policy(    platform: "AzurePlatform",    resource_group_name: str,    tenant_id: str,    object_id: str,    vault_name: str,) -> Any:    keyvault_client = get_key_vault_management_client(platform)    permissions = Permissions(keys=["all"], secrets=["all"], certificates=["all"])    # Fetch the current policies and add the new policy    vault = keyvault_client.vaults.get(resource_group_name, vault_name)    current_policies = vault.properties.access_policies    new_policy = AccessPolicyEntry(        tenant_id=tenant_id,        object_id=object_id,        permissions=permissions,    )    current_policies.append(new_policy)    # Update the vault with the new policies    vault.properties.access_policies = current_policies    keyvault_poller = keyvault_client.vaults.begin_create_or_update(        resource_group_name, vault_name, vault    )    return keyvault_poller.result()@retry(tries=5, delay=1)def create_certificate(    platform: "AzurePlatform",    vault_url: str,    cert_name: str,    log: Logger,) -> str:    certificate_client = get_certificate_client(vault_url, platform)    secret_client = get_secret_client(vault_url, platform)    cert_policy = CertificatePolicy.get_default()    # Create certificate    create_certificate_result = certificate_client.begin_create_certificate(        cert_name, policy=cert_policy    )    log.debug(        f"Certificate '{cert_name}' has been created. "        f"Result: {create_certificate_result}"    )    certificate_client.update_certificate_properties(        certificate_name=cert_name, enabled=True    )    secret_id: Optional[str] = secret_client.get_secret(name=cert_name).id    if secret_id:        # Example: "https://example.vault.azure.net/secrets/Cert-123/SomeVersion"        # Expected match for 'cert_url':        # "https://example.vault.azure.net/secrets/Cert-123"        match = re.match(            r"(?P<cert_url>https://.+?/secrets/.+?)(?:/[^/]+)?$", secret_id        )        if match:            secret_url_without_version = match.group("cert_url")            return secret_url_without_version        else:            raise LisaException(                f"Failed to parse the URL pattern of secret ID: '{secret_id}'."            )    else:        raise LisaException(f"Failed to retrieve secret ID:'{cert_name}'.")def check_certificate_existence(    vault_url: str, cert_name: str, log: Logger, platform: "AzurePlatform") -> bool:    certificate_client = CertificateClient(        vault_url=vault_url, credential=platform.credential    )    try:        certificate = certificate_client.get_certificate(cert_name)        log.debug(f"Cert found '{certificate.name}'")        return True    except Exception as e:        if "not found" in str(e).lower():            log.debug(f"Certificate '{cert_name}' does not exist.")            return False        else:            # Directly raise an exception without logging an error            raise LisaException(                f"Unexpected error checking certificate '{cert_name}': {e}"            )@retry(tries=10, delay=1)def rotate_certificate(    platform: "AzurePlatform",    vault_url: str,    cert_name: str,    log: Logger,) -> None:    certificate_client = get_certificate_client(vault_url, platform)    # Retrieve the old version of the certificate    if not certificate_client.get_certificate(cert_name):        error_message = f"Failed to retrieve old version of certificate: {cert_name}"        raise LisaException(error_message)    cert_policy = CertificatePolicy.get_default()    # Create only the specified certificate    # Create certificate    create_certificate_poller = certificate_client.begin_create_certificate(        cert_name, policy=cert_policy    )    create_certificate_result = create_certificate_poller.result()    # Handle possible None value    if (        isinstance(create_certificate_result, KeyVaultCertificate)        and hasattr(create_certificate_result, "properties")        and create_certificate_result.properties    ):        new_certificate_version = create_certificate_result.properties.version        log.debug(            f"New version of certificate '{cert_name}': {new_certificate_version}. "            "Certificate rotated."        )    else:        error_message = "Failed to retrieve properties from create certificate result."        raise LisaException(error_message)    certificate_client.update_certificate_properties(        certificate_name=cert_name, enabled=True    )@retry(tries=10, delay=1)def delete_certificate(    platform: "AzurePlatform",    vault_url: str,    cert_name: str,    log: Logger,) -> bool:    certificate_client = get_certificate_client(vault_url, platform)    try:        certificate_client.begin_delete_certificate(cert_name)        log.debug(f"Certificate {cert_name} deleted successfully.")        return True    except Exception:        error_message = f"Failed to delete certificate: {cert_name}"        raise LisaException(error_message)def is_cloud_init_enabled(node: Node) -> bool:    ls_tool = node.tools[Ls]    if ls_tool.path_exists(        "/var/log/cloud-init.log", sudo=True    ) and ls_tool.path_exists("/var/lib/cloud/instance", sudo=True):        return True    return False