from dataclasses import dataclassfrom pathlib import Pathfrom typing import Any, List, Type, castfrom dataclasses_json import dataclass_jsonfrom lisa import messages, notifier, schemafrom lisa.messages import SubTestMessage, TestResultMessage, TestResultMessageBasefrom lisa.runner import print_resultsfrom lisa.util import LisaException, constants@dataclass_json()@dataclassclass TextResultSchema(schema.Notifier):    include_subtest: bool = Falseclass TextResult(notifier.Notifier):    """    Creating log notifier to dump text formatted results for easier    view in editing mode. The original log is complete but too long to    check only the summary.    """    @classmethod    def type_name(cls) -> str:        return "text_result"    @classmethod    def type_schema(cls) -> Type[schema.TypedSchema]:        return TextResultSchema    def _received_message(self, message: messages.MessageBase) -> None:        if isinstance(message, TestResultMessage):            if message.is_completed:                self._received_messages.append(message)        elif isinstance(message, SubTestMessage):            if self._include_subtest:                self._received_messages.append(message)        else:            raise LisaException(f"Received unsubscribed message type: {message.type}")    def _subscribed_message_type(self) -> List[Type[messages.MessageBase]]:        return [TestResultMessage, SubTestMessage]    def _initialize(self, *args: Any, **kwargs: Any) -> None:        self._result_path = Path(            f"{constants.RUN_LOCAL_LOG_PATH}/lisa-{constants.RUN_ID}-result.txt"        )        if self._result_path.exists():            raise LisaException("File already exists")        runbook = cast(TextResultSchema, self.runbook)        self._include_subtest = runbook.include_subtest        self._received_messages: List[TestResultMessageBase] = []    def finalize(self) -> None:        with open(self._result_path, "w") as result_file:            print_results(self._received_messages, result_file.write, add_ending=True)