from dataclasses import dataclassfrom datetime import datetimefrom typing import Any, List, Type, castfrom dataclasses_json import dataclass_jsonfrom lisa import messages, notifier, schemafrom lisa.util import constantsfrom .common import simplify_message@dataclass_json()@dataclassclass ConsoleSchema(schema.Notifier):    file_name: str = "messages.log"class Console(notifier.Notifier):    """    It's a sample notifier, output subscribed message to file. It can be used to    troubleshooting what kind of message received together.    """    @classmethod    def type_name(cls) -> str:        return constants.NOTIFIER_FILE    @classmethod    def type_schema(cls) -> Type[schema.TypedSchema]:        return ConsoleSchema    def finalize(self) -> None:        return super().finalize()    def _received_message(self, message: messages.MessageBase) -> None:        simplify_message(message)        # write every time to refresh the content immediately.        with open(self._file_path, "a") as f:            f.write(f"{datetime.now():%Y-%m-%d %H:%M:%S.%ff}: {message}\n")    def _subscribed_message_type(self) -> List[Type[messages.MessageBase]]:        return [messages.MessageBase]    def _initialize(self, *args: Any, **kwargs: Any) -> None:        runbook = cast(ConsoleSchema, self.runbook)        self._file_path = constants.RUN_LOCAL_LOG_PATH / runbook.file_name