__doc__ = """pyparsing module - Classes and methods to define and execute parsing grammars=============================================================================The pyparsing module is an alternative approach to creating andexecuting simple grammars, vs. the traditional lex/yacc approach, or theuse of regular expressions.  With pyparsing, you don't need to learna new syntax for defining grammars or matching expressions - the parsingmodule provides a library of classes that you use to construct thegrammar directly in Python.Here is a program to parse "Hello, World!" (or any greeting of the form``"<salutation>, <addressee>!"``), built up using :class:`Word`,:class:`Literal`, and :class:`And` elements(the :meth:`'+'<ParserElement.__add__>` operators create :class:`And` expressions,and the strings are auto-converted to :class:`Literal` expressions)::    from pyparsing import Word, alphas    # define grammar of a greeting    greet = Word(alphas) + "," + Word(alphas) + "!"    hello = "Hello, World!"    print(hello, "->", greet.parseString(hello))The program outputs the following::    Hello, World! -> ['Hello', ',', 'World', '!']The Python representation of the grammar is quite readable, owing to theself-explanatory class names, and the use of :class:`'+'<And>`,:class:`'|'<MatchFirst>`, :class:`'^'<Or>` and :class:`'&'<Each>` operators.The :class:`ParseResults` object returned from:class:`ParserElement.parseString` can beaccessed as a nested list, a dictionary, or an object with namedattributes.The pyparsing module handles some of the problems that are typicallyvexing when writing text parsers:  - extra or missing whitespace (the above program will also handle    "Hello,World!", "Hello  ,  World  !", etc.)  - quoted strings  - embedded commentsGetting Started ------------------Visit the classes :class:`ParserElement` and :class:`ParseResults` tosee the base classes that most other pyparsingclasses inherit from. Use the docstrings for examples of how to: - construct literal match expressions from :class:`Literal` and   :class:`CaselessLiteral` classes - construct character word-group expressions using the :class:`Word`   class - see how to create repetitive expressions using :class:`ZeroOrMore`   and :class:`OneOrMore` classes - use :class:`'+'<And>`, :class:`'|'<MatchFirst>`, :class:`'^'<Or>`,   and :class:`'&'<Each>` operators to combine simple expressions into   more complex ones - associate names with your parsed results using   :class:`ParserElement.setResultsName` - access the parsed data, which is returned as a :class:`ParseResults`   object - find some helpful expression short-cuts like :class:`delimitedList`   and :class:`oneOf` - find more useful common expressions in the :class:`pyparsing_common`   namespace class"""from collections import namedtupleversion_info = namedtuple("version_info", "major minor micro releaseLevel serial")__version_info__ = version_info(3, 0, 0, "beta", 2)__version__ = (    "{}.{}.{}".format(*__version_info__[:3])    + ("{}{}".format(__version_info__.releaseLevel[0], __version_info__.serial), "")[        __version_info__.releaseLevel == "final"    ])__versionTime__ = "24 December 2020 05:11 UTC"__author__ = "Paul McGuire <ptmcg@users.sourceforge.net>"from .util import *from .exceptions import *from .actions import *from .core import __diag__, __compat__from .results import *from .core import *from .core import _builtin_exprs as core_builtin_exprsfrom .helpers import *from .helpers import _builtin_exprs as helper_builtin_exprsfrom .unicode import unicode_set, pyparsing_unicode as unicodefrom .testing import pyparsing_test as testingfrom .common import (    pyparsing_common as common,    _builtin_exprs as common_builtin_exprs,)# define backward compat synonymspyparsing_unicode = unicodepyparsing_common = commonpyparsing_test = testingcore_builtin_exprs += common_builtin_exprs + helper_builtin_exprs__all__ = [    "__version__",    "__versionTime__",    "__author__",    "__compat__",    "__diag__",    "And",    "CaselessKeyword",    "CaselessLiteral",    "CharsNotIn",    "Combine",    "Dict",    "Each",    "Empty",    "FollowedBy",    "Forward",    "GoToColumn",    "Group",    "IndentedBlock",    "Keyword",    "LineEnd",    "LineStart",    "Literal",    "Located",    "PrecededBy",    "MatchFirst",    "NoMatch",    "NotAny",    "OneOrMore",    "OnlyOnce",    "Optional",    "Or",    "ParseBaseException",    "ParseElementEnhance",    "ParseException",    "ParseExpression",    "ParseFatalException",    "ParseResults",    "ParseSyntaxException",    "ParserElement",    "QuotedString",    "RecursiveGrammarException",    "Regex",    "SkipTo",    "StringEnd",    "StringStart",    "Suppress",    "Token",    "TokenConverter",    "White",    "Word",    "WordEnd",    "WordStart",    "ZeroOrMore",    "Char",    "alphanums",    "alphas",    "alphas8bit",    "anyCloseTag",    "anyOpenTag",    "cStyleComment",    "col",    "commonHTMLEntity",    "countedArray",    "cppStyleComment",    "dblQuotedString",    "dblSlashComment",    "delimitedList",    "dictOf",    "empty",    "hexnums",    "htmlComment",    "javaStyleComment",    "line",    "lineEnd",    "lineStart",    "lineno",    "makeHTMLTags",    "makeXMLTags",    "matchOnlyAtCol",    "matchPreviousExpr",    "matchPreviousLiteral",    "nestedExpr",    "nullDebugAction",    "nums",    "oneOf",    "opAssoc",    "printables",    "punc8bit",    "pythonStyleComment",    "quotedString",    "removeQuotes",    "replaceHTMLEntity",    "replaceWith",    "restOfLine",    "sglQuotedString",    "srange",    "stringEnd",    "stringStart",    "traceParseAction",    "unicodeString",    "withAttribute",    "indentedBlock",    "originalTextFor",    "ungroup",    "infixNotation",    "locatedExpr",    "withClass",    "CloseMatch",    "tokenMap",    "pyparsing_common",    "pyparsing_unicode",    "unicode_set",    "conditionAsParseAction",    "pyparsing_test",]