from thirdparty.colorama import init, Fore, Back, Stylefrom thirdparty.pyparsing import Literal, Word, Combine, Optional, Suppress, delimitedList, oneOfclass ColorOutput(object):    def __init__(self, colors=True):        self.colors = colors        self.fore_table = {            "red": Fore.RED,            "green": Fore.GREEN,            "yellow": Fore.YELLOW,            "blue": Fore.BLUE,            "magenta": Fore.MAGENTA,            "cyan": Fore.CYAN,            "white": Fore.WHITE        }        self.back_table = {            "red": Back.RED,            "green": Back.GREEN,            "yellow": Back.YELLOW,            "blue": Back.BLUE,            "magenta": Back.MAGENTA,            "cyan": Back.CYAN,            "white": Back.WHITE        }        self.escape_seq = None        self.prepare_sequence_escaper()        init()    def color(self, msg, fore=None, back=None, bright=False):        if not self.colors:            return msg        if bright:            msg = Style.BRIGHT + msg        if fore:            msg = self.fore_table[fore] + msg        if back:            msg = self.back_table[back] + msg        return msg + Style.RESET_ALL    # Credit: https://stackoverflow.com/a/2187024/12238982    def prepare_sequence_escaper(self):        ESC = Literal("\x1b")        integer = Word("0123456789")        alphas = list("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")        self.escape_seq = Combine(            ESC + "[" + Optional(delimitedList(integer, ";")) + oneOf(alphas)        )    def clean_color(self, msg):        return Suppress(self.escape_seq).transformString(msg)