class Response(object):    def __init__(self, response):        self.status = response.status_code        self.headers = response.headers        self.body = b""        for chunk in response.iter_content(chunk_size=8192):            self.body += chunk    def __eq__(self, other):        return self.status == other.status and self.body == other.body    def __cmp__(self, other):        return (self.body > other) - (self.body < other)    def __len__(self):        return len(self.body)    def __hash__(self):        return hash(self.body)    @property    def redirect(self):        return self.headers.get("location")    @property    def length(self):        if "content-length" in dict(self.headers):            return int(self.headers.get("content-length"))        return len(self.body)