import sysimport unittestfrom PyQt5.QtWidgets import QApplicationfrom linakdeskapp.gui.device_status_widget import DeviceStatusWidget as TestWidgetfrom .device_connector_mock import DeviceConnectorMockapp = QApplication(sys.argv)class DeviceStatusWidgetTest(unittest.TestCase):    def setUp(self):        # # Called before testfunction is executed        self.widget = TestWidget()    def tearDown(self):        # # Called after testfunction was executed        self.widget = None    def test_labels_noDevice(self):        statusInfo = self.widget.ui.statusLabel.text()        deviceName = self.widget.ui.deviceLabel.text()        userType = self.widget.ui.userTypeLabel.text()        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(statusInfo, "disconnected")        self.assertEqual(deviceName, "")        self.assertEqual(userType, "")        self.assertEqual(devicePosition, "")    def test_labels_connectedDevice(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector(device)        statusInfo = self.widget.ui.statusLabel.text()        deviceName = self.widget.ui.deviceLabel.text()        userType = self.widget.ui.userTypeLabel.text()        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(statusInfo, "connected")        self.assertEqual(deviceName, "Device#1")        self.assertEqual(userType, "Owner")        self.assertEqual(devicePosition, "83 cm")    def test_labels_positionChange(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector(device)        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(devicePosition, "83 cm")        device.setPosition(77)        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(devicePosition, "77 cm")        device.setPosition(99)        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(devicePosition, "99 cm")    def test_attach_None(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector(device)        statusInfo = self.widget.ui.statusLabel.text()        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(statusInfo, "connected")        self.assertEqual(devicePosition, "83 cm")        self.widget.attachConnector(None)        device.setPosition(55)        statusInfo = self.widget.ui.statusLabel.text()        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(statusInfo, "disconnected")        self.assertEqual(devicePosition, "")    def test_attach_twoDevices(self):        device1 = DeviceConnectorMock("Device#1", "Owner", 83)        device2 = DeviceConnectorMock("Device#2", "Guest", 93)        self.widget.attachConnector(device1)        self.widget.attachConnector(device2)        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(devicePosition, "93 cm")        device1.setPosition(55)        device1.disconnect()        devicePosition = self.widget.ui.positionLabel.text()        self.assertEqual(devicePosition, "93 cm")