import sysimport unittestfrom PyQt5.QtWidgets import QApplicationfrom PyQt5.QtTest import QTestfrom PyQt5.QtCore import Qtfrom linakdeskapp.gui.device_control_widget import DeviceControlWidget as TestWidgetfrom .device_connector_mock import DeviceConnectorMockapp = QApplication(sys.argv)class DeviceControlWidgetTest(unittest.TestCase):    def setUp(self):        ## Called before testfunction is executed        self.widget = TestWidget()    def tearDown(self):        ## Called after testfunction was executed        self.widget = None    def test_disconnected(self):        upPB = self.widget.ui.upPB        self.assertFalse( upPB.isEnabled() )        downPB = self.widget.ui.downPB        self.assertFalse( downPB.isEnabled() )    def test_upPB(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector( device )        positionStart = device.currentPosition()        upPB = self.widget.ui.upPB        QTest.mousePress(upPB, Qt.LeftButton)        self.assertEquals(1, device.upCounter)        self.assertEquals(0, device.downCounter)        self.assertEquals(0, device.stopCounter)        QTest.qSleep(1000)        QTest.mouseRelease(upPB, Qt.LeftButton)        self.assertEquals(1, device.upCounter)        self.assertEquals(0, device.downCounter)        self.assertEquals(1, device.stopCounter)        positionEnd = device.currentPosition()        self.assertGreater(positionEnd, positionStart)    def test_downPB(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector( device )        positionStart = device.currentPosition()        downPB = self.widget.ui.downPB        QTest.mousePress(downPB, Qt.LeftButton)        self.assertEquals(0, device.upCounter)        self.assertEquals(1, device.downCounter)        self.assertEquals(0, device.stopCounter)        QTest.qSleep(1000)        QTest.mouseRelease(downPB, Qt.LeftButton)        self.assertEquals(0, device.upCounter)        self.assertEquals(1, device.downCounter)        self.assertEquals(1, device.stopCounter)        positionEnd = device.currentPosition()        self.assertLess(positionEnd, positionStart)    def test_favPB(self):        device = DeviceConnectorMock("Device#1", "Owner", 83)        self.widget.attachConnector( device )        layout = self.widget.ui.favLayout        favSize = device.favSlotsNumber()        self.assertEquals(favSize, layout.count())        positionStart = device.currentPosition()        fav1PB = layout.itemAt(0).widget()        QTest.mouseClick(fav1PB, Qt.LeftButton)        self.assertEquals(1, device.positionCounter)        positionEnd = device.currentPosition()        self.assertLess(positionEnd, positionStart)