import unittestfrom .device_connector_mock import DeviceConnectorMockclass DeviceConnectorTest(unittest.TestCase):    def setUp(self):        ## Called before testfunction is executed        self.connector = DeviceConnectorMock()    def tearDown(self):        ## Called after testfunction was executed        self.connector = None    def test_scanDevices(self):        devices = self.connector.scanDevices()        self.assertEqual(devices[0].name, "Desk1")        self.assertEqual(devices[1].name, "Desk2")    def test_connect(self):        self.assertFalse( self.connector.isConnected() )        self.assertEqual( self.connector.address(), None )        self.assertEqual( self.connector.connectionCounter, 0 )        self.connector.connectTo("aaa")        self.assertTrue( self.connector.isConnected() )        self.assertEqual( self.connector.address(), "aaa" )        self.assertEqual( self.connector.connectionCounter, 2 )        self.connector.scanDevices()        self.assertTrue( self.connector.isConnected() )        self.assertEqual( self.connector.address(), "aaa" )        self.assertEqual( self.connector.connectionCounter, 2 )    def test_name(self):        self.connector.connectTo("Device#1")        devName = self.connector.name()        self.assertEqual( devName, "Custom Desk")    def test_positionCm(self):        self.connector.connectTo("Device#1")        self.assertEqual( self.connector.positionCounter, 0)        self.connector.setPosition(33)        position = self.connector.positionCm()        self.assertEqual( position, "33 cm")        self.assertEqual( self.connector.positionCounter, 1)    def test_moveUp(self):        self.connector.connectTo("Device#1")        self.assertEqual( self.connector.positionCounter, 0)        self.connector.moveUp()        self.assertEqual( self.connector.positionCounter, 1)    def test_moveDown(self):        self.connector.connectTo("Device#1")        self.assertEqual( self.connector.positionCounter, 0)        self.connector.moveDown()        self.assertEqual( self.connector.positionCounter, 1)