import unittestimport loggingimport linakdeskapp.logger as logger_LOGGER = logging.getLogger(__name__)consoleHandler = logger.create_stdout_handler()_LOGGER.addHandler( consoleHandler )'''Observations:    1. object generator lives within inner scope of 'with' statement    2. returned object ('as') from generator lives outside of 'with' inner scope    3. '__enter__' and '__exit__' are called on generator'''class Counter(object):    def __init__(self):        self.constructor = 0        self.enter = 0        self.execute = 0        self.exit = 0        self.destructor = 0class ObjectA(object):    logger = None    counter = None    def __init__(self):        # self.logger.warn("__init__: %r %r", self, ObjectA.counter)        ObjectA.counter.constructor += 1    def __enter__(self):        # self.logger.warn("__enter__: %r %r", self, ObjectA.counter)        ObjectA.counter.enter += 1        return self    def __exit__(self, exc_type, exc_val, exc_tb):        # self.logger.warn("__exit__: %r %r", self, ObjectA.counter)        ObjectA.counter.exit += 1    def __del__(self):        # self.logger.warn("__del__: %r %r", self, ObjectA.counter)        ObjectA.counter.destructor += 1    def execute(self):        ObjectA.counter.execute += 1ObjectA.logger = _LOGGER.getChild(ObjectA.__name__)class ObjectGenerator(object):    logger = None    counter = None    def __init__(self):        # self.logger.warn("__init__: %r %r", self, ObjectGenerator.counter)        ObjectGenerator.counter.constructor += 1    def __enter__(self):        # self.logger.warn("__enter__: %r %r", self, ObjectGenerator.counter)        ObjectGenerator.counter.enter += 1        return ObjectA()    def __exit__(self, exc_type, exc_val, exc_tb):        # self.logger.warn("__exit__: %r %r", self, ObjectGenerator.counter)        ObjectGenerator.counter.exit += 1    def __del__(self):        # self.logger.warn("__del__: %r %r", self, ObjectGenerator.counter)        ObjectGenerator.counter.destructor += 1    def execute(self):        ObjectGenerator.counter.execute += 1    @staticmethod    def insideFunction():        # self.logger.warn("insideFunction before: %r", ObjectGenerator.counter)        with ObjectGenerator() as obj:            # self.logger.warn("obj: %r", obj)            obj.execute()        # self.logger.warn("insideFunction after: %r", ObjectGenerator.counter)ObjectGenerator.logger = _LOGGER.getChild(ObjectGenerator.__name__)class SelfGenerator(object):    logger = None    counter = None    def __init__(self):        # self.logger.warn("__init__: %r %r", self, SelfGenerator.counter)        SelfGenerator.counter.constructor += 1    def __enter__(self):        # self.logger.warn("__enter__: %r %r", self, SelfGenerator.counter)        SelfGenerator.counter.enter += 1        return self    def __exit__(self, exc_type, exc_val, exc_tb):        # self.logger.warn("__exit__: %r %r", self, SelfGenerator.counter)        SelfGenerator.counter.exit += 1    def __del__(self):        # self.logger.warn("__del__: %r %r", self, SelfGenerator.counter)        SelfGenerator.counter.destructor += 1    def execute(self):        SelfGenerator.counter.execute += 1    @staticmethod    def insideFunction():        # self.logger.warn("insideFunction before: %r", SelfGenerator.counter)        with SelfGenerator() as obj:            # self.logger.warn("obj: %r", obj)            obj.execute()        # self.logger.warn("insideFunction after: %r", SelfGenerator.counter)SelfGenerator.logger = _LOGGER.getChild(SelfGenerator.__name__)class ObjectGeneratorTest(unittest.TestCase):    def setUp(self):        ObjectGenerator.counter = Counter()        ObjectA.counter = Counter()    def tearDown(self):        pass    def test_byConstructor(self):        with ObjectGenerator() as obj:            obj.execute()        genCounter = ObjectGenerator.counter        self.assertEqual(genCounter.constructor, 1)        self.assertEqual(genCounter.enter, 1)        self.assertEqual(genCounter.execute, 0)        self.assertEqual(genCounter.exit, 1)        self.assertEqual(genCounter.destructor, 1)        objCounter = ObjectA.counter        self.assertEqual(objCounter.constructor, 1)        self.assertEqual(objCounter.enter, 0)        self.assertEqual(objCounter.execute, 1)        self.assertEqual(objCounter.exit, 0)        self.assertEqual(objCounter.destructor, 0)      ## object alive    def test_insideFunction(self):        ObjectGenerator.insideFunction()        genCounter = ObjectGenerator.counter        self.assertEqual(genCounter.constructor, 1)        self.assertEqual(genCounter.enter, 1)        self.assertEqual(genCounter.execute, 0)        self.assertEqual(genCounter.exit, 1)        self.assertEqual(genCounter.destructor, 1)        objCounter = ObjectA.counter        self.assertEqual(objCounter.constructor, 1)        self.assertEqual(objCounter.enter, 0)        self.assertEqual(objCounter.execute, 1)        self.assertEqual(objCounter.exit, 0)        self.assertEqual(objCounter.destructor, 1)      ## object destroyedclass SelfGeneratorTest(unittest.TestCase):    def setUp(self):        SelfGenerator.counter = Counter()        ObjectA.counter = Counter()    def tearDown(self):        pass    def test_byConstructor(self):        with SelfGenerator() as obj:            obj.execute()        genCounter = SelfGenerator.counter        self.assertEqual(genCounter.constructor, 1)        self.assertEqual(genCounter.enter, 1)        self.assertEqual(genCounter.execute, 1)        self.assertEqual(genCounter.exit, 1)        self.assertEqual(genCounter.destructor, 0)      ## generator alive    def test_insideFunction(self):        SelfGenerator.insideFunction()        genCounter = SelfGenerator.counter        self.assertEqual(genCounter.constructor, 1)        self.assertEqual(genCounter.enter, 1)        self.assertEqual(genCounter.execute, 1)        self.assertEqual(genCounter.exit, 1)        self.assertEqual(genCounter.destructor, 1)      ## generator destroyed