import loggingtry:    import pandasexcept ImportError:    ### No module named <name>    logging.exception("Exception while importing")    exit(1)from .mpl_canvas import matplotlib, DynamicMplCanvas_LOGGER = logging.getLogger(__name__)class PositionChart(DynamicMplCanvas):    def __init__(self, parentWidget=None):        super().__init__(parentWidget, 10, 10, 80)        self.xdata = list()        self.ydata = list()        linesList = self.plot.plot_date( self.xdata, self.ydata, 'r',                                         linewidth=3, antialiased=True)        self.line = linesList[0]#         self.fig.suptitle('Desk position', y=0.95, fontsize=18)        self.plot.set_xlabel('Time', fontsize=14)        self.plot.set_ylabel('Height', fontsize=14)        formatter = matplotlib.dates.DateFormatter('%H:%M:%S')        self.plot.xaxis.set_major_formatter( formatter )        self.plot.margins( y=0.2 )        self.plot.set_xmargin(0.0)      ## prevents empty space between first tick and y axis        # rotates and right aligns the x labels, and moves the bottom of the        # axes up to make room for them        self.fig.autofmt_xdate()        self._set_plot_data()    def addData(self, deskHeight):        currTime = self.getCurrTime()        self.xdata.append(currTime)        self.ydata.append(deskHeight)        self._set_plot_data()    def clearData(self):        self.xdata.clear()        self.ydata.clear()        self._set_plot_data()    def updateData(self):        yLen = len(self.ydata)        if yLen < 1:            ## no data - nothing to do            return False        last = self.ydata[-1]        if yLen < 2:            ## only one value            self.addData( last )            return True        ## two or more values        last2 = self.ydata[-2]        if last != last2:            self.addData( last )            return True        self.xdata[-1] = self.getCurrTime()        self._set_plot_data()        return True    def getCurrTime(self):        currTime = pandas.Timestamp.now()        return currTime    def _set_plot_data(self):        if len(self.xdata) < 2:            return        self.line.set_xdata( self.xdata )        self.line.set_ydata( self.ydata )        ticks = self._generate_ticks(12)        self.plot.set_xticks( ticks )        ### hide first and last major tick (next to plot edges)        xticks = self.plot.xaxis.get_major_ticks()        xticks[0].label1.set_visible(False)        ##xticks[-1].label1.set_visible(False)        self.plot.relim(True)        self.plot.autoscale_view()        self.fig.tight_layout()                 ## make space for labels of axis#         self.fig.subplots_adjust(top=0.82)      ## make space for suptitle    def _generate_ticks(self, number):        if number < 1:            return list()        start = self.xdata[0].timestamp()        tzoffset = start - pandas.Timestamp( start, unit="s" ).timestamp()        if number < 2:            middle = (start + self.xdata[-1].timestamp()) / 2 + tzoffset            ts = pandas.Timestamp( middle, unit="s" )            ticks = [ts]            return ticks        delta = (self.xdata[-1].timestamp() - start) / (number - 1)        ticks = list()        ticks.append( self.xdata[0] )        currTs = start + tzoffset        for _ in range(1, number):            currTs += delta            ts = pandas.Timestamp( currTs, unit="s" )            ticks.append( ts )        return ticks