import loggingfrom . import uiloaderfrom .mpl.mpl_toolbar import DynamicToolbar_LOGGER = logging.getLogger(__name__)UiTargetClass, QtBaseClass = uiloader.loadUiFromClassName( __file__ )class PositionChartWidget(QtBaseClass):    logger = None    def __init__(self, parentWidget=None):        super().__init__(parentWidget)        self.ui = UiTargetClass()        self.ui.setupUi(self)        self.device = None        enabledChart = True        bgcolor = parentWidget.palette().color(parentWidget.backgroundRole())        self.ui.positionChart.setBackgroundByQColor( bgcolor )        self.ui.enabledCB.setChecked( enabledChart )        self.ui.enabledCB.stateChanged.connect( self._toggleEnabled )        self.toolbar = DynamicToolbar(self.ui.positionChart, self)        self.ui.toolbarLayout.addWidget( self.toolbar )        self._refreshWidget()    def attachConnector(self, connector):        if self.device is not None:            ## disconnect old object            self.device.connectionStateChanged.disconnect( self._refreshWidget )            self.device.positionChanged.disconnect( self._updatePositionState )        self.device = connector        self._refreshWidget()        if self.device is not None:            ## connect new object            self.device.connectionStateChanged.connect( self._refreshWidget )            self.device.positionChanged.connect( self._updatePositionState )    def loadSettings(self, settings):        settings.beginGroup( self.objectName() )        enabled = settings.value("chart_enabled", True, type=bool)        settings.endGroup()        self.ui.enabledCB.setChecked( enabled )    def saveSettings(self, settings):        settings.beginGroup( self.objectName() )        enabledChart = self.ui.enabledCB.isChecked()        settings.setValue("chart_enabled", enabledChart)        settings.endGroup()    def _refreshWidget(self):        ## self.logger.info("setting enabled: %s", enabled)        connected = self.isDeviceConnected()        if connected is True:            enabledChart = self.ui.enabledCB.isChecked()            self.toolbar.setEnabled( enabledChart )            self.ui.positionChart.setEnabled( enabledChart )            self._updatePositionState()         ## add current position        else:            self.toolbar.setEnabled( False )            self.ui.positionChart.setEnabled( False )    def isDeviceConnected(self):        if self.device is None:            return False        return self.device.isConnected()    def _updatePositionState(self):        enabledChart = self.ui.enabledCB.isChecked()        if enabledChart is False:            return        deskHeight = self.device.currentPosition()        self.ui.positionChart.addData( deskHeight )    def _toggleEnabled(self, state):        ## state: 0 -- unchecked        ## state: 2 -- checked        self._refreshWidget()PositionChartWidget.logger = _LOGGER.getChild(PositionChartWidget.__name__)