from . import uiloaderfrom linakdeskapp.gui.device_connector import ConnectionStateUiTargetClass, QtBaseClass = uiloader.loadUiFromClassName( __file__ )class DeviceStatusWidget(QtBaseClass):    def __init__(self, parentWidget=None):        super().__init__(parentWidget)        self.device = None        self.ui = UiTargetClass()        self.ui.setupUi(self)        self._refreshWidget()    def attachConnector(self, connector):        if self.device is not None:            ## disconnect old object            self.device.connectionStateChanged.disconnect( self._refreshWidget )            self.device.settingChanged.disconnect( self._refreshWidget )            self.device.positionChanged.disconnect( self._refreshPosition )            self.device.speedChanged.disconnect( self._refreshSpeed )        self.device = connector        self._refreshWidget()        if self.device is not None:            ## connect new object            self.device.connectionStateChanged.connect( self._refreshWidget )            self.device.settingChanged.connect( self._refreshWidget )            self.device.positionChanged.connect( self._refreshPosition )            self.device.speedChanged.connect( self._refreshSpeed )    def _refreshWidget(self):        status = self.getDeviceConnectionStatus()        if status == ConnectionState.CONNECTED:            self.ui.statusLabel.setText( "connected" )            self.ui.deviceLabel.setText( self.device.name() )            self.ui.deviceTypeLabel.setText( self.device.deviceType() )            self.ui.userTypeLabel.setText( self.device.userType() )            reminderSettings = self.device.reminderSettings()            if reminderSettings is not None:                self.ui.reminderLabel.setText( reminderSettings.currentReminderInfo() )            else:                self.ui.reminderLabel.setText( "None" )            self._refreshPosition()            self._refreshSpeed()            return        if status == ConnectionState.CONN_IN_PROGRESS:            self.ui.statusLabel.setText("connecting...")        else:            self.ui.statusLabel.setText("disconnected")        ## clear rest        self.ui.deviceLabel.setText("")        self.ui.deviceTypeLabel.setText("")        self.ui.userTypeLabel.setText("")        self.ui.reminderLabel.setText("")        self.ui.positionLabel.setText("")        self.ui.speedLabel.setText("")    def getDeviceConnectionStatus(self):        if self.device is None:            return ConnectionState.DISCONNECTED        return self.device.getConnectionStatus()    def _refreshPosition(self):        self.ui.positionLabel.setText( self.device.positionCm() )    def _refreshSpeed(self):        currSpeed = self.device.currentSpeed()        self.ui.speedLabel.setText( str(currSpeed) )