import functoolsfrom . import uiloaderfrom .qt import QPushButtonfrom .qt import clearLayoutUiTargetClass, QtBaseClass = uiloader.loadUiFromClassName( __file__ )class DeviceControlWidget(QtBaseClass):    def __init__(self, parentWidget=None):        super().__init__(parentWidget)        self.device = None        self.favButtons = list()        self.ui = UiTargetClass()        self.ui.setupUi(self)        self._refreshWidget()        self.ui.upPB.pressed.connect(self._goingUp)        self.ui.upPB.released.connect(self._stopMoving)        self.ui.downPB.pressed.connect(self._goingDown)        self.ui.downPB.released.connect(self._stopMoving)        self.ui.stopPB.clicked.connect(self._stopMoving)        self.ui.topPB.clicked.connect(self._goingTop)        self.ui.bottomPB.clicked.connect(self._goingBottom)    def attachConnector(self, connector):        if self.device is not None:            ## disconnect old object            self.device.connectionStateChanged.connect( self._refreshWidget )            self.device.favoritiesChanged.disconnect( self._refreshFavLayout )        self.ui.deviceStatus.attachConnector(connector)        self.device = connector        self._refreshWidget()        if self.device is not None:            ## connect new object            self.device.connectionStateChanged.connect( self._refreshWidget )            self.device.favoritiesChanged.connect( self._refreshFavLayout )    def _refreshWidget(self):        connected = self.isDeviceConnected()        if connected is False:            self.ui.upPB.setEnabled(False)            self.ui.downPB.setEnabled(False)            self.ui.stopPB.setEnabled(False)            self.ui.topPB.setEnabled(False)            self.ui.bottomPB.setEnabled(False)            self.ui.favLayout.setEnabled(False)            self._clearFavLayout()        else:            self.ui.upPB.setEnabled(True)            self.ui.downPB.setEnabled(True)            self.ui.stopPB.setEnabled(True)            self.ui.topPB.setEnabled(True)            self.ui.bottomPB.setEnabled(True)            self.ui.favLayout.setEnabled(True)            self._genFavButtons()    def isDeviceConnected(self):        if self.device is None:            return False        return self.device.isConnected()    def _goingUp(self):        if self.device is None:            return        self.device.moveUp()    def _goingDown(self):        if self.device is None:            return        self.device.moveDown()    def _goingTop(self):        if self.device is None:            return        self.device.moveToTop()    def _goingBottom(self):        if self.device is None:            return        self.device.moveToBottom()    def _stopMoving(self):        if self.device is None:            return        self.device.stopMoving()    def _moveToFav(self, favIndex):        if self.device is None:            return        self.device.moveToFav( favIndex )    def _getFavList(self):        if self.device is None:            return []        return self.device.favValues()    def _clearFavLayout(self):        clearLayout( self.ui.favLayout )        self.favButtons.clear()    def _genFavButtons(self):        self._clearFavLayout()        favourities = self._getFavList()        for i in range( len(favourities) ):            fav = favourities[i]            button = QPushButton(self)            self._updateFavButton(button, fav)            favHandler = functools.partial(self._moveToFav, i)            button.clicked.connect( favHandler )            self.ui.favLayout.addWidget( button )            self.favButtons.append(button)    def _refreshFavLayout(self, favIndex):        self._refreshFavButton(favIndex)    def _refreshFavButton(self, favIndex):        favourities = self._getFavList()        if favIndex >= len(favourities):            return        favValue = favourities[ favIndex ]        button = self.favButtons[ favIndex ]        self._updateFavButton(button, favValue)    def _updateFavButton(self, button, favValue):        label = str( favValue )        button.setText( label )        if favValue is not None:            button.setEnabled( True )        else:            button.setEnabled( False )