from enum import Enum, unique, autoimport abc@uniqueclass ConnectionState(Enum):    CONNECTED           = auto()    CONN_IN_PROGRESS    = auto()    DISCONNECTED        = auto()class DeviceConnector(metaclass=abc.ABCMeta):    def __init__(self):        pass    @abc.abstractmethod    def address(self):        raise NotImplementedError('You need to define this method in derived class!')    def isConnected(self):        status = self.getConnectionStatus()        return status == ConnectionState.CONNECTED    @abc.abstractmethod    def getConnectionStatus(self) -> ConnectionState:        raise NotImplementedError('You need to define this method in derived class!')    @abc.abstractmethod    def scanDevices(self):        raise NotImplementedError('You need to define this method in derived class!')    @abc.abstractmethod    def connectTo(self, deviceAddr):        raise NotImplementedError('You need to define this method in derived class!')    @abc.abstractmethod    def reconnect(self):        raise NotImplementedError('You need to define this method in derived class!')    @abc.abstractmethod    def disconnect(self):        raise NotImplementedError('You need to define this method in derived class!')class ScanItem():    def __init__(self, name, address):        self._name = name        self._address = address    @property    def name(self):        return self._name    @property    def address(self):        return self._address