# Generated by Django 2.2.17 on 2021-05-24 10:02

import api_basebone.core.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.SlugField(unique=True, verbose_name='代号')),
                ('name', models.CharField(max_length=50, verbose_name='名称')),
                ('description', models.TextField(blank=True, null=True, verbose_name='说明')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('create_by', api_basebone.core.fields.UserField(auto_current_add=True, db_constraint=False, on_delete=django.db.models.deletion.PROTECT, related_name='created_categories', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='lightning_code.Category', verbose_name='上级目录')),
                ('update_by', api_basebone.core.fields.UserField(auto_current=True, db_constraint=False, on_delete=django.db.models.deletion.PROTECT, related_name='updated_categories', to=settings.AUTH_USER_MODEL, verbose_name='更新人')),
            ],
            options={
                'verbose_name': '目录',
                'verbose_name_plural': '目录',
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='标签')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('create_by', api_basebone.core.fields.UserField(auto_current_add=True, db_constraint=False, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
            ],
            options={
                'verbose_name': '标签',
                'verbose_name_plural': '标签',
            },
        ),
        migrations.CreateModel(
            name='Function',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(max_length=100, unique=True, verbose_name='函数名')),
                ('scope', models.IntegerField(choices=[(0, '后端'), (1, '前端')], verbose_name='运行环境')),
                ('language', models.CharField(choices=[('python', 'Python'), ('json', 'Json'), ('javascript', 'Javascript'), ('xml', 'XML')], default='python', max_length=30, verbose_name='编程语言')),
                ('description', models.TextField(blank=True, null=True, verbose_name='说明')),
                ('code', models.TextField(blank=True, null=True, verbose_name='代码')),
                ('released_code', models.TextField(blank=True, null=True, verbose_name='已发布代码')),
                ('return_type', models.CharField(choices=[('string', '字符串'), ('integer', '整数'), ('decimal', '浮点数'), ('bool', '布尔值'), ('date', '日期'), ('ref', '数据'), ('image', '图片')], max_length=20, verbose_name='返回值类型')),
                ('return_type_ref', models.CharField(blank=True, max_length=50, null=True, verbose_name='返回值模型')),
                ('released_check_sum', models.CharField(blank=True, default='', max_length=64, null=True, verbose_name='发布版校验码')),
                ('parameter_check_sum', models.CharField(blank=True, default='', max_length=64, null=True, verbose_name='参数校验码')),
                ('version', models.PositiveIntegerField(default=0, verbose_name='版本')),
                ('enable', models.BooleanField(default=True, verbose_name='启用')),
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='lightning_code.Category', verbose_name='目录')),
                ('create_by', api_basebone.core.fields.UserField(auto_current_add=True, db_constraint=False, on_delete=django.db.models.deletion.PROTECT, related_name='created_functions', to=settings.AUTH_USER_MODEL, verbose_name='创建人')),
                ('tags', models.ManyToManyField(blank=True, null=True, to='lightning_code.Tag', verbose_name='标签')),
                ('update_by', api_basebone.core.fields.UserField(auto_current=True, db_constraint=False, on_delete=django.db.models.deletion.PROTECT, related_name='updated_functions', to=settings.AUTH_USER_MODEL, verbose_name='更新人')),
            ],
            options={
                'verbose_name': '函数',
                'verbose_name_plural': '函数',
            },
        ),
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(verbose_name='参数名')),
                ('display_name', models.CharField(blank=True, max_length=50, null=True, verbose_name='显示名')),
                ('type', models.CharField(choices=[('string', '字符串'), ('integer', '整数'), ('decimal', '浮点数'), ('bool', '布尔值'), ('date', '日期'), ('ref', '数据'), ('image', '图片')], max_length=20, verbose_name='类型')),
                ('ref', models.CharField(blank=True, max_length=50, null=True, verbose_name='模型')),
                ('required', models.BooleanField(default=True, verbose_name='必填')),
                ('default_value', models.TextField(blank=True, null=True, verbose_name='默认值')),
                ('description', models.CharField(blank=True, max_length=1024, null=True, verbose_name='说明')),
                ('function', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lightning_code.Function', verbose_name='函数')),
            ],
            options={
                'verbose_name': '参数',
                'verbose_name_plural': '参数',
                'index_together': {('function', 'name')},
            },
        ),
    ]
