# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic import Extra,  BaseModel, Field, StrictFloat, StrictInt
from lightly.openapi_generated.swagger_client.models.selection_strategy_threshold_operation import SelectionStrategyThresholdOperation
from lightly.openapi_generated.swagger_client.models.selection_strategy_type import SelectionStrategyType

class SelectionConfigEntryStrategy(BaseModel):
    """
    SelectionConfigEntryStrategy
    """
    type: SelectionStrategyType = Field(...)
    stopping_condition_minimum_distance: Optional[Union[StrictFloat, StrictInt]] = None
    threshold: Optional[Union[StrictFloat, StrictInt]] = None
    operation: Optional[SelectionStrategyThresholdOperation] = None
    target: Optional[Dict[str, Any]] = None
    __properties = ["type", "stopping_condition_minimum_distance", "threshold", "operation", "target"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> SelectionConfigEntryStrategy:
        """Create an instance of SelectionConfigEntryStrategy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SelectionConfigEntryStrategy:
        """Create an instance of SelectionConfigEntryStrategy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SelectionConfigEntryStrategy.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in SelectionConfigEntryStrategy) in the input: " + str(obj))

        _obj = SelectionConfigEntryStrategy.parse_obj({
            "type": obj.get("type"),
            "stopping_condition_minimum_distance": obj.get("stopping_condition_minimum_distance"),
            "threshold": obj.get("threshold"),
            "operation": obj.get("operation"),
            "target": obj.get("target")
        })
        return _obj

