# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic import Extra,  BaseModel, Field, confloat, conint, conlist

class SampleMetaData(BaseModel):
    """
    SampleMetaData
    """
    custom: Optional[Dict[str, Any]] = None
    dynamic: Optional[Dict[str, Any]] = None
    sharpness: Optional[Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)]] = None
    luminance: Optional[Union[confloat(le=100, ge=0, strict=True), conint(le=100, ge=0, strict=True)]] = None
    size_in_bytes: Optional[conint(strict=True, ge=0)] = Field(None, alias="sizeInBytes")
    snr: Optional[Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)]] = None
    uniform_row_ratio: Optional[Union[confloat(le=1, ge=0, strict=True), conint(le=1, ge=0, strict=True)]] = Field(None, alias="uniformRowRatio")
    mean: Optional[conlist(Union[confloat(le=1, ge=0, strict=True), conint(le=1, ge=0, strict=True)], max_items=3, min_items=3)] = None
    shape: Optional[conlist(conint(strict=True, ge=0), max_items=3, min_items=3)] = None
    std: Optional[conlist(Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)], max_items=3, min_items=3)] = None
    sum_of_squares: Optional[conlist(Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)], max_items=3, min_items=3)] = Field(None, alias="sumOfSquares")
    sum_of_values: Optional[conlist(Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)], max_items=3, min_items=3)] = Field(None, alias="sumOfValues")
    __properties = ["custom", "dynamic", "sharpness", "luminance", "sizeInBytes", "snr", "uniformRowRatio", "mean", "shape", "std", "sumOfSquares", "sumOfValues"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> SampleMetaData:
        """Create an instance of SampleMetaData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if custom (nullable) is None
        # and __fields_set__ contains the field
        if self.custom is None and "custom" in self.__fields_set__:
            _dict['custom' if by_alias else 'custom'] = None

        # set to None if dynamic (nullable) is None
        # and __fields_set__ contains the field
        if self.dynamic is None and "dynamic" in self.__fields_set__:
            _dict['dynamic' if by_alias else 'dynamic'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SampleMetaData:
        """Create an instance of SampleMetaData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SampleMetaData.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in SampleMetaData) in the input: " + str(obj))

        _obj = SampleMetaData.parse_obj({
            "custom": obj.get("custom"),
            "dynamic": obj.get("dynamic"),
            "sharpness": obj.get("sharpness"),
            "luminance": obj.get("luminance"),
            "size_in_bytes": obj.get("sizeInBytes"),
            "snr": obj.get("snr"),
            "uniform_row_ratio": obj.get("uniformRowRatio"),
            "mean": obj.get("mean"),
            "shape": obj.get("shape"),
            "std": obj.get("std"),
            "sum_of_squares": obj.get("sumOfSquares"),
            "sum_of_values": obj.get("sumOfValues")
        })
        return _obj

