# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import Extra,  BaseModel, Field, StrictBool
from lightly.openapi_generated.swagger_client.models.docker_worker_config_v3_datasource_input_expiration import DockerWorkerConfigV3DatasourceInputExpiration

class DockerWorkerConfigV3DockerDatasource(BaseModel):
    """
    DockerWorkerConfigV3DockerDatasource
    """
    bypass_verify: Optional[StrictBool] = Field(None, alias="bypassVerify")
    enable_datapool_update: Optional[StrictBool] = Field(None, alias="enableDatapoolUpdate")
    process_all: Optional[StrictBool] = Field(None, alias="processAll")
    input_expiration: Optional[DockerWorkerConfigV3DatasourceInputExpiration] = Field(None, alias="inputExpiration")
    __properties = ["bypassVerify", "enableDatapoolUpdate", "processAll", "inputExpiration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> DockerWorkerConfigV3DockerDatasource:
        """Create an instance of DockerWorkerConfigV3DockerDatasource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of input_expiration
        if self.input_expiration:
            _dict['inputExpiration' if by_alias else 'input_expiration'] = self.input_expiration.to_dict(by_alias=by_alias)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DockerWorkerConfigV3DockerDatasource:
        """Create an instance of DockerWorkerConfigV3DockerDatasource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DockerWorkerConfigV3DockerDatasource.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in DockerWorkerConfigV3DockerDatasource) in the input: " + str(obj))

        _obj = DockerWorkerConfigV3DockerDatasource.parse_obj({
            "bypass_verify": obj.get("bypassVerify"),
            "enable_datapool_update": obj.get("enableDatapoolUpdate"),
            "process_all": obj.get("processAll"),
            "input_expiration": DockerWorkerConfigV3DatasourceInputExpiration.from_dict(obj.get("inputExpiration")) if obj.get("inputExpiration") is not None else None
        })
        return _obj

