# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@lightly.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import Extra,  BaseModel, Field, StrictBool, StrictStr, conlist
from lightly.openapi_generated.swagger_client.models.datasource_raw_samples_predictions_data_row import DatasourceRawSamplesPredictionsDataRow

class DatasourceRawSamplesPredictionsData(BaseModel):
    """
    DatasourceRawSamplesPredictionsData
    """
    has_more: StrictBool = Field(..., alias="hasMore", description="Set to `false` if end of list is reached. Otherwise `true`.")
    cursor: StrictStr = Field(..., description="A cursor that indicates the current position in the list. Must be passed to future requests to continue reading from the same list. ")
    data: conlist(DatasourceRawSamplesPredictionsDataRow) = Field(..., description="Array containing the raw samples prediction objects")
    __properties = ["hasMore", "cursor", "data"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True
        use_enum_values = True
        extra = Extra.forbid

    def to_str(self, by_alias: bool = False) -> str:
        """Returns the string representation of the model"""
        return pprint.pformat(self.dict(by_alias=by_alias))

    def to_json(self, by_alias: bool = False) -> str:
        """Returns the JSON representation of the model"""
        return json.dumps(self.to_dict(by_alias=by_alias))

    @classmethod
    def from_json(cls, json_str: str) -> DatasourceRawSamplesPredictionsData:
        """Create an instance of DatasourceRawSamplesPredictionsData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, by_alias: bool = False):
        """Returns the dictionary representation of the model"""
        _dict = self.dict(by_alias=by_alias,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item in self.data:
                if _item:
                    _items.append(_item.to_dict(by_alias=by_alias))
            _dict['data' if by_alias else 'data'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DatasourceRawSamplesPredictionsData:
        """Create an instance of DatasourceRawSamplesPredictionsData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DatasourceRawSamplesPredictionsData.parse_obj(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in DatasourceRawSamplesPredictionsData) in the input: " + str(obj))

        _obj = DatasourceRawSamplesPredictionsData.parse_obj({
            "has_more": obj.get("hasMore"),
            "cursor": obj.get("cursor"),
            "data": [DatasourceRawSamplesPredictionsDataRow.from_dict(_item) for _item in obj.get("data")] if obj.get("data") is not None else None
        })
        return _obj

